static const char file_id[] = "../../../../src/domains/thor/stars/ThorNOR.chdl";

////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
// All rights reserved.
// See the file ~ptolemy/copyright for copyright notice, 
// limitation of liability, and disclaimer of warranty provisions. 
//
////////////////////////////////////////////////////////////////////////

////

//  Conversion done 1992/11/26, 12:42:20 by pepp version 2.6.
//  Input is coming from file "../../../../src/domains/thor/stars/ThorNOR.chdl".

#include "ThorStar.h"
#include "ThorState.h"
#include "libarp.h"
#include "KnownBlock.h"
#include "ThorPrintOverl.h"
#include "ThorErrHandler.h"

static ThorErrHandler* StatErrHandler = 0;

#ifdef EXITMOD
#undef EXITMOD
#endif
#define EXITMOD(x) StatErrHandler->status = x; return;
#define exit(x) StatErrHandler->status = x; StatErrHandler->flush(); return;

/*	NOR()
 *		Generic mult-input NOR gate
 */

const char *star_nm_ThorNOR = "ThorNOR";

class ThorNOR : public ThorStar
{
private:

//	    Inport list: (between lines 9 and 11)
    MultiInThorPort	indat;

//	    Outport list: (between lines 13 and 15)
    OutThorPort		fun;

public:
    int			isItModel() { return TRUE; }
    ThorNOR();		// Constructor
    void		go();
    void		setup();
    Block*		makeNew() const { LOG_NEW; return new ThorNOR; }

};

ThorNOR :: ThorNOR ()	// Constructor
{
    setDescriptor("\n"
"** This star's code is generated by pepp, version 2.6, from a chdl model. **\n""\n"

"/*	NOR()\n"
" *		Generic mult-input NOR gate\n"
" */\n");

//	Ports:

    addPort(indat.setPort("indat",this));

    addPort(fun.setPort("fun",this));
}

void ThorNOR :: setup()
{
}

static ThorNOR proto;
static KnownBlock entry(proto,"NOR");

void ThorNOR :: go()
{
#define index  strchr
#define new   _new_

    ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);
    StatErrHandler = &errHandler;

// line 6 "../../../../src/domains/thor/stars/ThorNOR.chdl"

#define	RCSID "$Header: NOR.c,v 1.2 86/12/30 23:49:29 div Exp $"

// line 12 "../../../../src/domains/thor/stars/ThorNOR.chdl"

// line 16 "../../../../src/domains/thor/stars/ThorNOR.chdl"

	register int i;

	if ( OUT_COUNT != 1)
	{
		fprintf(stderr,"ERROR: NOR(): wrong # of outputs\n");
		EXITMOD(-2);
	}
	fun = ONE;
						/* for all inputs	*/
	for ( i = IN_COUNT-1; i>=0; i--)
	{
		switch(indat[i]) {
		case ONE:
			fun = ZERO;
			EXITMOD(0);		/* break out of for() */
		case ZERO:
			break;
		default:
			fun = UNDEF;
			break;
		}
	}
	EXITMOD(0);
}

