static const char file_id[] = "../../../../src/domains/thor/stars/ThorMUX.chdl";

////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
// All rights reserved.
// See the file ~ptolemy/copyright for copyright notice, 
// limitation of liability, and disclaimer of warranty provisions. 
//
////////////////////////////////////////////////////////////////////////

////

//  Conversion done 1992/11/26, 12:42:16 by pepp version 2.6.
//  Input is coming from file "../../../../src/domains/thor/stars/ThorMUX.chdl".

#include "ThorStar.h"
#include "ThorState.h"
#include "libarp.h"
#include "KnownBlock.h"
#include "ThorPrintOverl.h"
#include "ThorErrHandler.h"

static ThorErrHandler* StatErrHandler = 0;

#ifdef EXITMOD
#undef EXITMOD
#endif
#define EXITMOD(x) StatErrHandler->status = x; return;
#define exit(x) StatErrHandler->status = x; StatErrHandler->flush(); return;

/*	MUX()
 *		Multiplexes Inputs to outputs 
 * 	@(#)ThorMUX.chdl	1.1 11/16/92
 */

const char *star_nm_ThorMUX = "ThorMUX";

class ThorMUX : public ThorStar
{
private:

//	    Inport list: (between lines 10 and 13)
    MultiInThorPort	input;
    MultiInThorPort	select;

//	    Outport list: (between lines 15 and 17)
    OutThorPort		output;

//	    State list: (between lines 19 and 22)
    int			numInputs;
    ThorState		_numInputs_;
    int			numSelect;
    ThorState		_numSelect_;

public:
    int			isItModel() { return TRUE; }
    ThorMUX();		// Constructor
    void		go();
    void		setup();
    Block*		makeNew() const { LOG_NEW; return new ThorMUX; }

};

ThorMUX :: ThorMUX ()	// Constructor
{
    setDescriptor("\n"
"** This star's code is generated by pepp, version 2.6, from a chdl model. **\n""\n"

"/*	MUX()\n"
" *		Multiplexes Inputs to outputs \n"
" * 	@(#)ThorMUX.chdl	1.1 11/16/92\n"
" */\n");

//	Ports:

    addPort(input.setPort("input",this));
    addPort(select.setPort("select",this));

    addPort(output.setPort("output",this));

//	States:

    addState(_numInputs_.setThorState("numInputs",this,"0",&numInputs));
    addState(_numSelect_.setThorState("numSelect",this,"0",&numSelect));
}

void ThorMUX :: setup()
{
}

static ThorMUX proto;
static KnownBlock entry(proto,"MUX");

void ThorMUX :: go()
{
#define index  strchr
#define new   _new_

    ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);
    StatErrHandler = &errHandler;

// line 7 "../../../../src/domains/thor/stars/ThorMUX.chdl"

#define	RCSID "$Header: AND.c,v 1.2 86/12/30 23:49:00 div Exp $"

// line 14 "../../../../src/domains/thor/stars/ThorMUX.chdl"

// line 18 "../../../../src/domains/thor/stars/ThorMUX.chdl"

// line 23 "../../../../src/domains/thor/stars/ThorMUX.chdl"

	int numIn = 2 << (numSelect-1);
	if( numIn != numInputs)
	{
		fprintf(stderr,"ERROR: MUX(): wrong # of input/select lines\n");
		EXITMOD(-2);
	}

	int sel;
	sel = fpack(select,(numSelect-1),0);
	output = input[sel];

	EXITMOD(0);
}

