static const char file_id[] = "ThorDualPortedRam.cc";

////////////////////////////////////////////////////////////////////////
// @(#)ThorDualPortedRam.cc	1.3 11/26/92
// Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
// All rights reserved.
// See the file ~ptolemy/copyright for copyright notice,
// limitation of liability, and disclaimer of warranty provisions.
//
////////////////////////////////////////////////////////////////////////

////

//  Conversion done 1992/01/20, 12:32:24 by pepp version 2.5.
//  Input is coming from file "ThorDualPortedRam.chdl".

#include "ThorStar.h"
#include "ThorState.h"
#include "StringState.h"
#include "libarp.h"
#include "KnownBlock.h"
/*
#include "ThorPrintOverl.h"
#include "ThorErrHandler.h" 
*/
#include "lib.h"
#include <stdio.h>
#include "uarp.h"
#include "libarp.h"

/*
static ThorErrHandler* StatErrHandler = 0;

#ifdef EXITMOD
#undef EXITMOD
#endif
#define EXITMOD(x) StatErrHandler->status = x; return;
#define exit(x) StatErrHandler->status = x; StatErrHandler->flush(); return;
*/


/*
* Thor model for dual-port RAM 				
*/

   char *getenv();

const char *star_nm_ThorDualPortedRam = "ThorDualPortedRam";

class ThorDualPortedRam : public ThorStar
{
private:

//	    Inport list: (between lines 10 and 20)
    InThorPort		ReadBar1;
    InThorPort		WriteBar1;
    InThorPort		ReadBar2;
    InThorPort		WriteBar2;

    InThorPort		AB1;
    InThorPort		AB2;

    InThorPort		DB_in1;
    InThorPort		DB_in2;

    OutThorPort		DB_out1;
    OutThorPort		DB_out2;

// State list
    IntState 		ram_size;
    StringState   	ramDataFile;
    

public:
    int			isItMonitor() { return TRUE; }
    ThorDualPortedRam();		// Constructor
    void		go();
    void		setup();
    int			pack(int *arin,  int msb, int lsb);
    void		unpack(int *arout,  int msb, int lsb,int number);
    Block*		makeNew() const { LOG_NEW; return new ThorDualPortedRam; }

int *ram_data;		/* pointer to memory representing RAM */
int *ram_ptr;		/* pointer to memory representing RAM */
int address;

   FILE *fp;
   int i;
   char filename[512];
   char *frigg_path;
   int AddressBus1[16],AddressBus2[16];
   int DataBus1_In[24],DataBus2_In[24];
   int DataBus1_Out[24],DataBus2_Out[24];
};

ThorDualPortedRam :: ThorDualPortedRam ()	// Constructor
{
    setDescriptor( "\n"
"** This star's code has been changed after pepp. **\n""\n");

//	Ports:

    addPort(ReadBar1.setPort("ReadBar1",this));
    addPort(WriteBar1.setPort("WriteBar1",this));
    addPort(ReadBar2.setPort("ReadBar2",this));
    addPort(WriteBar2.setPort("WriteBar2",this));

    addPort(AB1.setPort("AB1",this));
    addPort(AB2.setPort("AB2",this));

    addPort(DB_in1.setPort("DB_in1",this));
    addPort(DB_in2.setPort("DB_in2",this));
    addPort(DB_out1.setPort("DB_out1",this));
    addPort(DB_out2.setPort("DB_out2",this));

    addState(ram_size.setState("ram_size",this,"8192","Size of the memory"));
    addState(ramDataFile.setState("ramDataFile",this,"dual_ram.dat","File to initialize the data in the RAM" ));
}

void ThorDualPortedRam :: setup()
{
   	ram_data = (int *) malloc(int(ram_size) * sizeof(int));
  	ram_ptr = ram_data;

   	if (ram_data == NULL) 
	{
      		fprintf(stderr, "Thor: ram.c: Couldn't allocate ram_data!\n") ;
      		exit(-1);
      	}

	const char* fName = expandPathName(ramDataFile);

   	if ((fp = fopen(fName, "r"))==NULL) 
	{
  		for (i = 0; i < ram_size; i++)	/* fill memory with zero */
    		ram_data[i] = 0;
      	}
	else 
	{
  		i = 0;
		/* initialize data */
		while ((i++ <= ram_size) && (fscanf(fp,"%d",ram_ptr++)!= EOF));
  		fclose(fp);
	}

  	fsetword(DataBus1_Out, 23, 0, FLOAT);
  	fsetword(DataBus2_Out, 23, 0, FLOAT);

}

static ThorDualPortedRam proto;
static KnownBlock entry(proto,"DualPortedRam");

void ThorDualPortedRam :: go()
{
#define index  strchr
#define new   _new_


//    ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);
//    StatErrHandler = &errHandler;


	unpack(AddressBus1,15,0,AB1);
	unpack(AddressBus2,15,0,AB2);
	unpack(DataBus1_In,23,0,DB_in1);
	unpack(DataBus2_In,23,0,DB_in2);


	if ( (WriteBar1 == ZERO) && (ReadBar1 == ZERO) ) 
	{
		/* error */
    		goto port2;
    	}

  	if (WriteBar1 == ZERO) 
	{		
		/* WRITE */
    		if (fckbin(AddressBus1, 15, 0) != PASSED)  
		{     
			/* check bits of address */
      			goto port2;
      		}
    		if (fckbin(DataBus1_In, 23, 0) != PASSED)  
		{        
			/* check bits of data */
      			goto port2;
      		}
    		address = AB1;
    		if ( (address < 0) || (address >= ram_size) ) 
		{
      			goto port2;
      		}
    		ram_data[address] = DB_in1;		
		/* store word from bus */

    	} /* write by peripheral, for mem it is reading into itself */

  	else if (ReadBar1 == ZERO) 
	{		
		/* READ */
    		if (fckbin(AddressBus1, 15, 0) != PASSED)  
		{     
			/* check bits of address */
      			goto port2;
      		}
    		address = AB1;
    		if ( (address < 0) || (address >= ram_size) ) 
		{
      			goto port2;
      		}

		DB_out1 = ram_data[address];

    	} /* read */

	/* default, float outputs */
  	else if ( ( WriteBar1 == ONE) && (ReadBar1 == ONE) ) 
	{
		DB_out1 = -3;		
    	} /* default */

port2:

  	if ( (WriteBar2 == ZERO) && (ReadBar2 == ZERO) ) 
	{	  
		/* error */
    		EXITMOD(0);
    	}

  	if (WriteBar2 == ZERO) 
	{		
		/* WRITE */
    		if (fckbin(AddressBus2, 15, 0) != PASSED)  
		{     
			/* check bits of address */
      			EXITMOD(0);
      		}
    		if (fckbin(DataBus2_In, 23, 0) != PASSED)  
		{        
			/* check bits of data */
      			EXITMOD(0);
      		}
    		address = AB2;
    		if ( (address < 0) || (address >= ram_size) ) 
		{
      			EXITMOD(0);
      		}

    		ram_data[address] = DB_in2;		
		/* store word from bus */
    	} /* write */

  	else if (ReadBar2 == ZERO) 
	{		
		/* READ */
    		if (fckbin(AddressBus2, 15, 0) != PASSED)  
		{     
			/* check bits of address */
      			EXITMOD(0);
      		}

    		address = AB2;
    		if ( (address < 0) || (address >= ram_size) ) 
		{
      			EXITMOD(0);
      		}
		/* place word on bus */
		DB_out2=ram_data[address]; 
   
	} /* read */

	/* default, float outputs */
  	else if ( (ReadBar2 == ONE ) && (WriteBar2 == ONE ) )
	{	
		DB_out2 = -3; 
    		EXITMOD(0);
    	} /* default */

   EXITMOD(0);

} /* ram.c */


int ThorDualPortedRam :: pack(
 int    *arin,          /* ptr to input array   */
 int    msb,            /* array index of MSB   */
 int    lsb)            /* array index of LSB   */

{

/*  Packs an array into a 32 bit integer. signed.
 * If the array (representing the bus input) consists of all
 * FLOAT or UNDEF, then converts it to a number which is FLOAT or UNDEF
*/

        int error,number=0;
        int dir;
        int     m1,l1;  /* used by FDUMP */

        m1 = msb; l1 = lsb;

        error = PASSED;
        error |= fckmsize(msb,lsb);

/*
if(msb >24 || lsb >24 )
ferr(wont work);
*/

        if (error == PASSED)
        {
                number = 0;
                dir = DIR(msb,lsb);

                while ( (lsb != msb) && (error >= PASSED) )
                {
                    switch ( arin[msb] )
                    {
                        case ZERO:
                                number <<= 1;
                                /* number += 0;*/
                                break;

                        case ONE:
                                number <<= 1;
		                number += 1;
                                break;

                        case UNDEF:
                                number = -2;
                                /*number = UNDEF; */
                                break;

                        case FLOAT:
                                number = -3;
                                /*number = FLOAT; */
                                break;

                        default:
                                error |= FAILED;
                                break;
                    }
                    msb -= dir;
                }
                                        /* now the case: (msb==lsb) */
                if (error == PASSED)
                {
                    switch ( arin[msb] )
                    {
                        case ZERO:
                                number <<= 1;
                                /* number += 0;*/
                                break;

                        case ONE:
                                number <<= 1;
                                number += 1;
                                break;

                        case UNDEF:
                                number = -2;
                                /*number = UNDEF; */
                                break;

                        case FLOAT:
                                number = -3;
                                /*number = FLOAT; */
                                break;

                        default:
                                error |= FAILED;
                                break;
                    }
                }
        }/*end if (error == PASSED ) */

        if (error < PASSED)
        {
                ferr(error,"PACK: Array not packed due to:");
        }

/*      put call sequence here as a reminder
int pack(arin,msb,lsb)
*/


        return(number);

} /* end pack() */


void ThorDualPortedRam :: unpack(int *arout, int msb, int lsb, int number)
{
int     test=0;

if(number==FLOAT) test=3;
else if(number==UNDEF) test=2;
else test=0;

/*
if(msb>24 || lsb >24)
ferr(wont work )
*/
        switch(number) {

        case -3:

                if (lsb >= msb)
                {
                        while (msb <= lsb)
                        {
                        arout[lsb--] = FLOAT;
                        }
                }
                else
                {
                        while (lsb <= msb)
                        {
                        arout[lsb++] = FLOAT;
                        }
                }
                break;


        case -2:

                if (lsb >= msb)
                {
                        while (msb <= lsb)
                        {
                        arout[lsb--] = UNDEF;
                        }
                }
                else
                {
                        while (lsb <= msb)
                        {
                        arout[lsb++] = UNDEF;
                        }
                }
                break;


        default:
		if (lsb >= msb)
                {
                        while (msb <= lsb)
                        {
                        arout[lsb--] = number & 0x1;
                        number = number >>1;
                        }
                }
                else
                {
                        while (lsb <= msb)
                        {
                        arout[lsb++] = number & 0x1;
                        number = number >>1;
                        }
                }
                break;
        }       /* switch */
}
