static const char file_id[] = "../../../../src/domains/thor/stars/ThorCOUNT.chdl";

////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
// All rights reserved.
// See the file ~ptolemy/copyright for copyright notice, 
// limitation of liability, and disclaimer of warranty provisions. 
//
////////////////////////////////////////////////////////////////////////

////

//  Conversion done 1992/11/26, 12:42:03 by pepp version 2.6.
//  Input is coming from file "../../../../src/domains/thor/stars/ThorCOUNT.chdl".

#include "ThorStar.h"
#include "ThorState.h"
#include "libarp.h"
#include "KnownBlock.h"
#include "ThorPrintOverl.h"
#include "ThorErrHandler.h"

static ThorErrHandler* StatErrHandler = 0;

#ifdef EXITMOD
#undef EXITMOD
#endif
#define EXITMOD(x) StatErrHandler->status = x; return;
#define exit(x) StatErrHandler->status = x; StatErrHandler->flush(); return;

/*	COUNT()
 *
 *	This function will count in binary form,
 *	incrementing the count by one at each togl period.
 *	The togl period is set by the parameter of the fcn and
 *	toggles the LSB of the output at this rate.
 *	The function is capable of handling up to 31 output nodes.
 *	(31 is machine dependent -- the length of an int on the VAX11/780)
 *	e.g. 
 *		(f=COUNT)(n=usrname)(o=a,b,c,d,e,f)(v=0,0,0,0,0,0)(s=1[2]);
 *			- f is the LSB.
 *			- a is the MSB.
 *			- togl_rate = 2.
 *			- initial output is 000000.
 *	If initial values are undefined, then initial output is 000000.
 */

const char *star_nm_ThorCOUNT = "ThorCOUNT";

class ThorCOUNT : public ThorStar
{
private:

//	    Outport list: (between lines 21 and 23)
    MultiOutThorPort	outdat;

//	    State list: (between lines 25 and 27)
    int			toglrate;
    ThorState		_toglrate_;

public:
    int			isItGenerator() { return TRUE; }
    ThorCOUNT();		// Constructor
    void		go();
    void		setup();
    Block*		makeNew() const { LOG_NEW; return new ThorCOUNT; }

};

ThorCOUNT :: ThorCOUNT ()	// Constructor
{
    setDescriptor("\n"
"** This star's code is generated by pepp, version 2.6, from a chdl model. **\n""\n"

"/*	COUNT()\n"
" *\n"
" *	This function will count in binary form,\n"
" *	incrementing the count by one at each togl period.\n"
" *	The togl period is set by the parameter of the fcn and\n"
" *	toggles the LSB of the output at this rate.\n"
" *	The function is capable of handling up to 31 output nodes.\n"
" *	(31 is machine dependent -- the length of an int on the VAX11/780)\n"
" *	e.g. \n"
" *		(f=COUNT)(n=usrname)(o=a,b,c,d,e,f)(v=0,0,0,0,0,0)(s=1[2]);\n"
" *			- f is the LSB.\n"
" *			- a is the MSB.\n"
" *			- togl_rate = 2.\n"
" *			- initial output is 000000.\n"
" *	If initial values are undefined, then initial output is 000000.\n"
" */\n");

//	Ports:

    addPort(outdat.setPort("outdat",this));

//	States:

    addState(_toglrate_.setThorState("toglrate",this,"0",&toglrate));
}

void ThorCOUNT :: setup()
{
}

static ThorCOUNT proto;
static KnownBlock entry(proto,"COUNT");

void ThorCOUNT :: go()
{
#define index  strchr
#define new   _new_

    ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);
    StatErrHandler = &errHandler;

// line 18 "../../../../src/domains/thor/stars/ThorCOUNT.chdl"

#define RCSID "$Header: COUNT.c,v 1.3 87/04/02 12:27:20 rla Exp $"

// line 24 "../../../../src/domains/thor/stars/ThorCOUNT.chdl"

// line 28 "../../../../src/domains/thor/stars/ThorCOUNT.chdl"

	register int i;

    if (current_time == 0) {	/* INIT */
	/* shouldn't need to check this anymore */
	if ( OUT_COUNT <= 0 )
	{	fprintf(stderr,
"ERROR:  COUNT(): needs at least 1 output -- %d\n", OUT_COUNT);
		EXITMOD(-2);
	}
	if (( ST_COUNT != 1 )
	/* check if toglrate is set properly: S.Lee, 2/23/91 */
	|| (toglrate <= 0))
	{
		fprintf(stderr,
"ERROR: COUNT(): error in defining toglrate -- %d\n", ST_COUNT);
		EXITMOD(-3);
	}

	for ( i=OUT_COUNT-1; i>=0; --i)
	{
		if ( outdat[i] > ONE )
			outdat[i] = ZERO;
	}

	self_sched(toglrate, SELF0);
	EXITMOD(0);
    } /* ENDINIT */

	if ((current_time % toglrate) == 0) {
		for (i = OUT_COUNT-1; i>=0; --i)
		{
			if (outdat[i] == ZERO)	/* check each bit */
			{
				outdat[i] = ONE;
				break;	/* out of for loop */
			} else {
				outdat[i] = ZERO;
			}
		}

		self_sched(toglrate, SELF0);
	}
	EXITMOD(0);
}

