# include <stdio.h>
# define U(x) x
# define NLSTATE pp2previous=PP2NEWLINE
# define BEGIN pp2bgin = pp2svec + 1 +
# define INITIAL 0
# define PP2LERR pp2svec
# define PP2STATE (pp2estate-pp2svec-1)
# define PP2OPTIM 1
# define PP2LMAX BUFSIZ
# define output(c) putc(c,pp2out)
# define input() (((pp2tchar=pp2sptr>pp2sbuf?U(*--pp2sptr):getc(pp2in))==10?(pp2lineno++,pp2tchar):pp2tchar)==EOF?0:pp2tchar)
# define unput(c) {pp2tchar= (c);if(pp2tchar=='\n')pp2lineno--;*pp2sptr++=pp2tchar;}
# define pp2more() (pp2morfg=1)
# define ECHO fprintf(pp2out, "%s",pp2text)
# define REJECT { nstr = pp2reject(); goto pp2fussy;}
int pp2leng; extern char pp2text[];
int pp2morfg;
extern char *pp2sptr, pp2sbuf[];
int pp2tchar;
FILE *pp2in = {stdin}, *pp2out = {stdout};
extern int pp2lineno;
struct pp2svf { 
	struct pp2work *pp2stoff;
	struct pp2svf *pp2other;
	int *pp2stops;};
struct pp2svf *pp2estate;
extern struct pp2svf pp2svec[], *pp2bgin;

/**************************************************************************
 * Version identification:
 * @(#)pass2Lex.l	1.5	7/16/92
 *
 *  Copyright (c) 1990,1991 The Regents of the University of California.
 *                        All Rights Reserved.
 *
 *  Programmer:  Anders Wass
 *  Date of creation: 11/02/90
 *
 *
 *  Description:
 *
 * This file performs the vector macro expansion supported by thor
 * preprocessor epp. The algorithm is this: Everything that don't match is
 * copied to output. Code within C-comments are ignored. First match to
 * occur should be `name['. If `name' is declared a vector in the model,
 * pattern matching continues. Otherwise `name' is copied to output and the
 * search for next `name[' begins.
 *
 * When a valid name is found, `name' is temporarly stored and lex switch
 * state to skip over `['. After that lex switch state again to look for
 * four different cases: `]', `] =', `:', and an `index'.
 * In the two first cases a pair of empty brackets was found and
 * fpack/funpack translation should be performed and vector pattern matching
 * should be started from the beginning.
 * The third case indicate that default first index should be used and the
 * fourth case an index symbol was found. The two last cases forces lex to
 * switch state again.
 *
 * In this state lex looks for `[', `]', and `:'. The first case indicate
 * that `index' found actually is a vector name and should be handled
 * according to that. Therefor `name[' is written to the output and `index'
 * is stored as `name' instead. Lex is then switched back to its previous state.
 * The second case indicates that a plain vector is found and no translation
 * should be prerformed. `name' and `index' are written to output to form a
 * plain vector notation.
 * The third case indicates that a second index is to be expected and a
 * translation should be performed later on.
 *
 * Next state looks for a `]' or an `index2'. If `index2' is found, it will
 * be temporarly stored. Both cases will have lex to switch to the CLOSING
 * state.
 * This state share its actions partly with INDEX1. When we get here
 * there is now doubt about that translation should be performed.
 *
 * This pattern matching algorithm is in no way waterproof but should
 * perform as well as the algorithm in epp. The more complex the expressions
 * inside the brackets become, the more likely is this algorithm to fail.
 * However, the purpose of this program is NOT to compile the model. And
 * clean well written code should not create any trouble with translations.
 *
 *	-- Anders Wass 1990/11/02
 *
 ********************************************************************************/


static char identification[] = "@(#)pass2Lex.l	1.5\t7/16/92  (c) UC Berkeley";

#ifndef PP2STACKSIZE
#define PP2STACKSIZE 32
#endif

static struct pp2svf *pp2svfstack[PP2STACKSIZE];
static int pp2stackptr=0;
static char lstack_id[] =
    "@(#)lexststack.Pc\tv1.00\t1990/10/23  (c) UCB,  A Wass";

static void initpp2svfstack()
{
    pp2stackptr=0;
    pp2svfstack[0] = pp2bgin + 1;
}

static void pp2lexpush(state)
    struct pp2svf *state;
{
    if (pp2stackptr>=PP2STACKSIZE) {
	fprintf(stderr,"lex: state stack overflow. (>=%d)\n",PP2STACKSIZE);
	exit(1);
    }
    pp2svfstack[pp2stackptr++] = state;
}

static struct pp2svf *pp2lexpop()
{
    if (pp2stackptr==0) {
	fprintf(stderr,"lex: state stack underflow.\n");
	exit(1);
    }
    return pp2svfstack[--pp2stackptr];
}

extern char* strcpy();

#define POP pp2bgin = pp2lexpop()
#define PUSH pp2lexpush(pp2bgin)
#define CLEARSTSTACK initpp2svfstack()

typedef struct vector {
    char name[128];
    char i1[512];
    char i2[512];
} VECTOR;

#include "comdefs.h"

	/* File from pass1 and resulting C++ file from pass2 */
static FILE *pass1fp = NULL, *pass2fp = NULL;

static VECTOR vec;

static NAMETABLE *NameTable = NULL;
static int funpackflg=0, firstind=1, lpar=0;
static int numOfUnpack=0, numOfPack=0, fstlbrack=0, errflg=0;
void fpack(), funpack();
# define VECT 2
# define INDEX1 4
# define INDEX2 6
# define INDEX3 8
# define CLOSING 10
# define COMMENT 12
# define PP2NEWLINE 10
pp2lex(){
int nstr; extern int pp2previous;
   CLEARSTSTACK;
   pp2in=pass1fp;
   pp2out=pass2fp;
   firstind=1;
   lpar=0;
   vec.name[0] = vec.i1[0] = vec.i2[0] = NULL;
   BEGIN 0;
while((nstr = pp2look()) >= 0)
pp2fussy: switch(nstr){
case 0:
if(pp2wrap()) return(0); break;
case 1:
	{
			    ECHO;
			    POP;
#ifndef NO_DEBUG
			    if (debug>2)
				dbgmsg(__FILE__, __LINE__,
				       "<COMMENT> `*/': Popping state. [_flg=%d.\n",
				       fstlbrack);
#endif
			}
break;
case 2:
	case 3:
case 4:
	{
			    ECHO;
#ifndef NO_DEBUG
			    if (debug>2)
				dbgmsg(__FILE__, __LINE__,
				       "<COMMENT> `\\n|[^*\\n]*|*': [_flg=%d.\n", fstlbrack);
#endif
			}
break;
case 5:
		{
			    ECHO;
			    PUSH; BEGIN COMMENT;
#ifndef NO_DEBUG
			    if (debug>2)
				dbgmsg(__FILE__, __LINE__,
				       "<?> `/*': Pushing to state COMMENT. [_flg=%d.\n",
				       fstlbrack);
#endif
			}
break;
case 6:
		{
			    while (lpar) putc(')',pp2out), lpar--;
			    putc(';',pp2out);
			}
break;
case 7:
		case 8:
		{
			    ECHO;
			}
break;
case 9:
	{   fputc('\n',pp2out); /* remove mult. blank lines */ }
break;
case 10:
{
			    if (getvecinfo(pp2text,NameTable)) {
				if (fstlbrack) {
				    fprintf(pp2out,"%s[",vec.name);
				    fstlbrack=0;
				}
				strcpy(vec.name,pp2text);
				BEGIN VECT;
#ifndef NO_DEBUG
				if (debug>2)
				    dbgmsg(__FILE__, __LINE__,
					   "%s\n%s [_flg=%d, text = \"%s\".\n",
					   "<0> `{NAME}/({ST}*)\\[':",
					   "Going to state VECT.", fstlbrack, pp2text);
#endif
			    }
			    else {
				ECHO;
				BEGIN 0;
#ifndef NO_DEBUG
				if (debug>2)
				    dbgmsg(__FILE__, __LINE__,
					   "%s\n%s [_flg=%d, text = \"%s\".\n",
					   "<0> `{NAME}/({ST}*)\\[':",
					   "Going to state 0.", fstlbrack, pp2text);
#endif
			    }
			}
break;
case 11:
	{
			    fstlbrack=1;
#ifndef NO_DEBUG
			    if (debug>2)
				dbgmsg(__FILE__, __LINE__,
				       "<VECT> `\\[{ST}*': %s [_flg=%d.\n",
				       "Going to state INDEX1.", fstlbrack);
#endif
			    BEGIN INDEX1;
			}
break;
case 12:
	{
			    if (fstlbrack) fprintf(pp2out,pp2text);
#ifndef NO_DEBUG
			    if (debug>2)
				dbgmsg(__FILE__, __LINE__,
				       "<VECT> `{ST}+': [_flg=%d.\n", fstlbrack);
#endif
			}
break;
case 13:
{
			    fstlbrack=0;
			    fpack(pp2out,&vec,NameTable);
			    firstind=1;
			    BEGIN 0;
#ifndef NO_DEBUG
			    if (debug>2)
				dbgmsg(__FILE__, __LINE__,
				       "<INDEX1,CLOSING> `\\]{ST}*': %s [_flg=%d.\n",
				       "Going to state 0.", fstlbrack);
#endif
			}
break;
case 14:
{
			    fstlbrack=0;
			    funpack(pp2out,&vec,NameTable);
			    lpar++;
			    firstind=1;
			    BEGIN 0;
#ifndef NO_DEBUG
			    if (debug>2)
				dbgmsg(__FILE__, __LINE__,
				       "<INDEX1,CLOSING> `\\]({ST}*)={ST}*': %s [_flg=%d.\n",
				       "Going to state 0.",fstlbrack);
#endif
			}
break;
case 15:
	{
			    unput(':');
			    BEGIN INDEX3;
			    firstind=0;
			    fstlbrack=0;
#ifndef NO_DEBUG
			    if (debug>2)
				dbgmsg(__FILE__, __LINE__,
				       "<INDEX1> `:': Going to state INDEX3. [_flg=%d.\n",
				       fstlbrack);
#endif
			}
break;
case 16:
	{
			    if (fstlbrack) ECHO;
#ifndef NO_DEBUG
			    if (debug>2)
				dbgmsg(__FILE__, __LINE__,
				       "<INDEX1> `{ST}+': [_flg=%d.\n", fstlbrack);
#endif
			}
break;
case 17:
{
			    strcpy(firstind ? vec.i1 : vec.i2,pp2text);
			    BEGIN INDEX2;
#ifndef NO_DEBUG
			    if (debug>2)
				dbgmsg(__FILE__, __LINE__,
				       "<INDEX1> `[^\\[\\]:]*': %s [_flg=%d.\n",
				       "Going to State INDEX2.", fstlbrack);
#endif
			}
break;
case 18:
	{
			    fprintf(pp2out,"%s[%s",vec.name,(pp2text+1));
			    strcpy(vec.name,vec.i1);
			    vec.i1[0] = NULL;
			    BEGIN INDEX1;
#ifndef NO_DEBUG
			    if (debug>2)
				dbgmsg(__FILE__, __LINE__,
				       "<INDEX2> `\\[{ST}*': %s [_flg=%d.\n",
				       "Going to state INDEX1.", fstlbrack);
#endif
			}
break;
case 19:
	{
			    fprintf(pp2out,"%s[%s]",vec.name,vec.i1);
			    fstlbrack=0;
			    vec.name [0] = vec.i1[0] = NULL;
			    BEGIN 0;
#ifndef NO_DEBUG
			    if (debug>2)
				dbgmsg(__FILE__, __LINE__,
				       "<INDEX2> `\\]': Going to state 0. [_flg=%d.\n",
				       fstlbrack);
#endif
			}
break;
case 20:
	{
			    BEGIN INDEX3;
			    firstind=0;
			    fstlbrack=0;
#ifndef NO_DEBUG
			    if (debug>2)
				dbgmsg(__FILE__, __LINE__,
				       "<INDEX2> `:{ST}*': %s [_flg=%d.\n",
				       "Going to state INDEX3.", fstlbrack);
#endif
			}
break;
case 21:
	{
			    unput(']');
			    BEGIN CLOSING;
#ifndef NO_DEBUG
			    if (debug>2)
				dbgmsg(__FILE__, __LINE__,
				       "<INDEX3> `\\]': %s [_flg=%d.\n",
				       "Going to state CLOSING.", fstlbrack);
#endif
			}
break;
case 22:
	{
			    if (fstlbrack) ECHO;
#ifndef NO_DEBUG
			    if (debug>2)
				dbgmsg(__FILE__, __LINE__,
				       "<INDEX3> `{ST}+': [_flg=%d.\n", fstlbrack);
#endif
			}
break;
case 23:
	{
			    strcpy(firstind ? vec.i1 : vec.i2,pp2text);
			    BEGIN CLOSING;
#ifndef NO_DEBUG
			    if (debug>2)
				dbgmsg(__FILE__, __LINE__,
				       "<INDEX3> `[^\\]]*': %s [_flg=%d.\n",
				       "Going to state CLOSING.", fstlbrack);
#endif
			}
break;
case -1:
break;
default:
fprintf(pp2out,"bad switch pp2look %d",nstr);
} return(0); }
/* end of pp2lex */

int pp2wrap() { return 1; }

static void fpack(fp,vector,tbl)
    FILE *fp;
    VECTOR *vector;
    NAMETABLE *tbl;
{
    char *ind1, *ind2, *s;
    NAMETABLE *infop = getvecinfo(vector->name,tbl);

    if (!infop) {
	errmsg("s","\"%s\": Macro error. No vector with name \"%s\" is declared.\n",
	       FileIParse, vector->name);
	errflg++;
	gsignal(1);
    }

    switch (infop->type) {
    case BIG_END:
	ind1 = vector->i1[0] ? vector->i1 :
	    (sprintf(vector->i1,"(%s)-1",infop->size), vector->i1);
	ind2 = vector->i2[0] ? vector->i2 : strcpy(vector->i2,"0");
	break;
    case LIT_END:
	ind1 = vector->i1[0] ? vector->i1 : strcpy(vector->i1,"0");
	ind2 = vector->i2[0] ? vector->i2 :
	    (sprintf(vector->i2,"(%s)-1",infop->size), vector->i2);
	break;
    default:
	errmsg("f","Bad endian value to vector \"%s\" in function `%s'.\n",
	       vector->name, "fpack");
	errmsg("s","\t\"%s\" declared in file \"%s\" on line %d.\n",
	       vector->name, FileIParse, infop->lineno);
	errmsg("S","\tShouldn't occur. BIG_END=%d, LIT_END=%d, value found = %d.\n%s",
	       BIG_END, LIT_END, infop->type, "\t(Data have been corrupted ???)\n");
	gsignal(1);
	break;
    }

    fprintf(pp2out,"fpack(%s,%s,%s)", infop->name, ind1, ind2);
    vector->name[0] = vector->i1[0] = vector->i2[0] = NULL;
    numOfPack++;
}

static void funpack(fp,vector,tbl)
    FILE *fp;
    VECTOR *vector;
    NAMETABLE *tbl;
{
    char *ind1, *ind2, *s;
    NAMETABLE *infop = getvecinfo(vector->name,tbl);

    if (!infop) {
	errmsg("s","\"%s\": Macro error. No vector with name \"%s\" is declared.\n",
	       FileIParse, vector->name);
	errflg++;
	gsignal(1);
    }

    switch (infop->type) {
    case BIG_END:
	ind1 = vector->i1[0] ? vector->i1 :
	    (sprintf(vector->i1,"(%s)-1",infop->size), vector->i1);
	ind2 = vector->i2[0] ? vector->i2 : strcpy(vector->i2,"0");
	break;
    case LIT_END:
	ind1 = vector->i1[0] ? vector->i1 : strcpy(vector->i1,"0");
	ind2 = vector->i2[0] ? vector->i2 :
	    (sprintf(vector->i2,"(%s)-1",infop->size), vector->i2);
	break;
    default:
	errmsg("f","Bad endian value to vector \"%s\" in function `%s'.\n",
	       vector->name, "funpack");
	errmsg("s","\t\"%s\" declared in file \"%s\" on line %d.\n",
	       vector->name, FileIParse, infop->lineno);
	errmsg("S","\tShouldn't occur. BIG_END=%d, LIT_END=%d, value found = %d.\n%s",
	       BIG_END, LIT_END, infop->type, "\t(Data have been corrupted ???)\n");
	gsignal(1);
	break;
    }
    
    fprintf(pp2out,"funpack(%s,%s,%s,", infop->name, ind1, ind2);
    vector->name[0] = vector->i1[0] = vector->i2[0] = NULL;
    numOfUnpack++;
}

int pass2(ifp,ofp,ofname,mfname,nametbl)
    FILE *ifp, *ofp;
    char *ofname, *mfname;
    NAMETABLE *nametbl;
{
    int retval = 0;
    errflg=0;

    if (!ifp) {
	errmsg("f","No file opened to read from.\n");
	return 3;
    }
    pass1fp = ifp;
    if (!ofp) {
	errmsg("f","No file opened to write to.\n");
	return 4;
    }
    pass2fp = ofp;
    FileIParse = mfname ? mfname : "(stdin)"; /* name that might be used by */
				/* external functions called within this block. */
    NameTable = nametbl;

    pp2lex();
    if (errflg)
	retval = 2;
    if (!(numOfPack || numOfUnpack))
	retval = retval ? retval : 1; /* don't overide error flag */
    else {
	errmsg(verbflg?"o":"O","Expansion statistics:");
	if (numOfPack)
	    errmsg(verbflg?"s":"S","   fpack   %3d.", numOfPack);
	if (numOfUnpack)
	    errmsg(verbflg?"s":"S","   funpack %3d.", numOfUnpack);
	errmsg(verbflg?"s":"S","\n");
    }
    pass1fp = pass2fp = NULL;
    FileIParse = NULL;
    return retval;
}

/* <EOF> pass2Lex.l */
int pp2vstop[] = {
0,

3,
17,
23,
0,

3,
17,
23,
0,

3,
17,
23,
0,

3,
17,
23,
0,

3,
17,
23,
0,

3,
17,
23,
0,

3,
17,
23,
0,

3,
17,
23,
0,

3,
17,
23,
0,

3,
17,
23,
0,

3,
17,
23,
0,

3,
17,
23,
0,

3,
17,
23,
0,

3,
17,
23,
0,

7,
0,

8,
0,

6,
0,

-10,
0,

7,
0,

8,
9,
0,

7,
12,
0,

11,
0,

7,
12,
0,

17,
0,

7,
16,
17,
0,

8,
17,
0,

7,
17,
0,

17,
0,

15,
0,

6,
17,
0,

17,
-10,
0,

13,
0,

7,
16,
17,
0,

8,
9,
17,
0,

20,
0,

18,
0,

19,
0,

23,
0,

7,
22,
23,
0,

8,
23,
0,

7,
23,
0,

23,
0,

6,
23,
0,

23,
-10,
0,

21,
0,

7,
22,
23,
0,

8,
9,
23,
0,

3,
0,

3,
7,
0,

2,
8,
0,

4,
0,

3,
0,

3,
6,
0,

3,
-10,
0,

3,
7,
0,

2,
8,
9,
0,

5,
0,

10,
0,

9,
0,

12,
0,

12,
0,

16,
17,
0,

5,
17,
0,

17,
0,

14,
0,

16,
17,
0,

9,
17,
0,

17,
0,

22,
23,
0,

5,
23,
0,

23,
0,

10,
23,
0,

22,
23,
0,

9,
23,
0,

23,
0,

1,
0,

3,
0,

3,
10,
0,

3,
0,
0};
# define PP2TYPE char
struct pp2work { PP2TYPE verify, advance; } pp2crank[] = {
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,15,	1,16,	
3,22,	1,15,	2,20,	2,21,	
20,61,	20,62,	22,63,	0,0,	
0,0,	0,0,	23,23,	24,64,	
36,36,	0,0,	37,37,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,15,	0,0,	3,22,	
0,0,	2,20,	0,0,	20,61,	
64,64,	22,63,	4,24,	4,21,	
17,58,	23,23,	24,64,	36,36,	
1,17,	37,37,	0,0,	0,0,	
0,0,	40,72,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
1,18,	0,0,	7,36,	64,64,	
0,0,	4,24,	1,19,	1,19,	
1,19,	1,19,	1,19,	1,19,	
1,19,	1,19,	1,19,	1,19,	
1,19,	1,19,	1,19,	1,19,	
1,19,	1,19,	1,19,	1,19,	
1,19,	1,19,	1,19,	1,19,	
1,19,	1,19,	1,19,	1,19,	
6,34,	6,35,	3,23,	7,37,	
1,19,	7,38,	1,19,	1,19,	
1,19,	1,19,	1,19,	1,19,	
1,19,	1,19,	1,19,	1,19,	
1,19,	1,19,	1,19,	1,19,	
1,19,	1,19,	1,19,	1,19,	
1,19,	1,19,	1,19,	1,19,	
1,19,	1,19,	1,19,	1,19,	
4,23,	5,25,	8,20,	8,21,	
11,33,	27,0,	6,29,	41,0,	
28,0,	5,26,	5,27,	9,39,	
5,28,	40,0,	12,20,	12,21,	
10,47,	10,48,	6,31,	9,40,	
9,41,	13,49,	9,42,	14,56,	
14,57,	8,20,	42,0,	26,65,	
44,0,	13,50,	13,51,	43,73,	
13,50,	52,79,	73,0,	75,0,	
5,25,	12,20,	27,0,	29,66,	
27,0,	28,0,	5,25,	28,0,	
0,0,	50,0,	9,39,	5,29,	
31,0,	33,33,	6,0,	8,36,	
9,39,	0,0,	10,43,	29,0,	
13,49,	9,43,	5,30,	5,31,	
53,0,	14,53,	13,52,	0,0,	
0,0,	5,32,	10,44,	13,53,	
9,39,	9,44,	54,0,	66,0,	
33,33,	14,54,	68,68,	9,45,	
26,0,	50,0,	13,49,	13,54,	
72,72,	31,0,	43,0,	31,0,	
8,37,	13,55,	8,38,	59,59,	
29,0,	0,0,	29,0,	5,0,	
53,58,	5,33,	0,0,	47,76,	
47,77,	68,68,	12,33,	48,78,	
48,77,	33,68,	54,0,	9,46,	
66,0,	74,74,	66,0,	76,76,	
76,77,	26,0,	59,59,	26,0,	
0,0,	13,49,	19,0,	19,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	19,0,	19,59,	19,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	0,0,	19,0,	19,0,	
19,0,	19,19,	19,0,	19,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	32,67,	34,69,	34,70,	
72,0,	35,71,	35,70,	56,82,	
56,62,	59,60,	81,0,	19,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	19,0,	19,19,	47,0,	
77,78,	77,77,	0,0,	48,0,	
25,25,	65,65,	45,74,	74,75,	
32,32,	74,0,	0,0,	76,0,	
25,25,	25,25,	0,0,	25,25,	
78,78,	78,77,	0,0,	0,0,	
56,0,	0,0,	81,0,	67,67,	
19,60,	19,0,	19,0,	19,0,	
0,0,	19,0,	32,0,	34,0,	
0,0,	45,45,	35,0,	39,39,	
0,0,	32,32,	0,0,	25,25,	
49,49,	0,0,	0,0,	39,39,	
39,39,	25,25,	39,39,	0,0,	
49,49,	49,0,	0,0,	49,49,	
55,80,	55,0,	65,0,	0,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	25,0,	45,45,	32,60,	
34,0,	32,0,	34,0,	35,0,	
25,25,	35,0,	39,39,	0,0,	
67,0,	69,69,	69,70,	49,49,	
39,39,	70,71,	70,70,	55,55,	
0,0,	49,0,	71,71,	71,70,	
77,0,	55,0,	0,0,	65,0,	
45,75,	65,0,	45,0,	0,0,	
39,39,	0,0,	25,0,	0,0,	
25,0,	49,49,	0,0,	39,39,	
78,0,	0,0,	80,80,	80,0,	
49,49,	67,60,	0,0,	67,0,	
55,55,	82,82,	82,62,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	69,0,	0,0,	
0,0,	0,0,	70,0,	39,0,	
0,0,	0,0,	0,0,	71,0,	
49,49,	0,0,	55,81,	80,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	82,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	69,0,	
0,0,	69,0,	0,0,	70,0,	
0,0,	70,0,	0,0,	0,0,	
71,0,	0,0,	71,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
80,81,	0,0,	0,0,	0,0,	
0,0};
struct pp2svf pp2svec[] = {
0,	0,	0,
pp2crank+1,	0,		pp2vstop+1,
pp2crank+5,	pp2svec+1,	pp2vstop+5,
pp2crank+3,	pp2svec+1,	pp2vstop+9,
pp2crank+33,	pp2svec+1,	pp2vstop+13,
pp2crank+-124,	0,		pp2vstop+17,
pp2crank+-83,	pp2svec+5,	pp2vstop+21,
pp2crank+4,	pp2svec+1,	pp2vstop+25,
pp2crank+117,	pp2svec+1,	pp2vstop+29,
pp2crank+-134,	0,		pp2vstop+33,
pp2crank+-131,	pp2svec+9,	pp2vstop+37,
pp2crank+35,	pp2svec+1,	pp2vstop+41,
pp2crank+129,	pp2svec+1,	pp2vstop+45,
pp2crank+-144,	0,		pp2vstop+49,
pp2crank+-138,	pp2svec+13,	pp2vstop+53,
pp2crank+0,	0,		pp2vstop+57,
pp2crank+0,	0,		pp2vstop+59,
pp2crank+2,	0,		0,	
pp2crank+0,	0,		pp2vstop+61,
pp2crank+-237,	0,		pp2vstop+63,
pp2crank+7,	0,		pp2vstop+65,
pp2crank+0,	pp2svec+20,	pp2vstop+67,
pp2crank+9,	0,		pp2vstop+70,
pp2crank+13,	0,		pp2vstop+73,
pp2crank+14,	pp2svec+20,	pp2vstop+75,
pp2crank+-307,	0,		pp2vstop+78,
pp2crank+-142,	pp2svec+25,	pp2vstop+80,
pp2crank+-71,	pp2svec+25,	pp2vstop+84,
pp2crank+-74,	pp2svec+25,	pp2vstop+87,
pp2crank+-121,	pp2svec+25,	pp2vstop+90,
pp2crank+0,	0,		pp2vstop+92,
pp2crank+-114,	pp2svec+25,	pp2vstop+94,
pp2crank+-276,	pp2svec+25,	pp2vstop+97,
pp2crank+164,	0,		pp2vstop+100,
pp2crank+-277,	pp2svec+25,	pp2vstop+102,
pp2crank+-280,	pp2svec+25,	pp2vstop+106,
pp2crank+15,	0,		pp2vstop+110,
pp2crank+17,	0,		pp2vstop+112,
pp2crank+0,	0,		pp2vstop+114,
pp2crank+-338,	0,		pp2vstop+116,
pp2crank+-44,	pp2svec+39,	pp2vstop+118,
pp2crank+-38,	pp2svec+39,	pp2vstop+122,
pp2crank+-57,	pp2svec+39,	pp2vstop+125,
pp2crank+-113,	pp2svec+39,	pp2vstop+128,
pp2crank+-59,	pp2svec+39,	pp2vstop+130,
pp2crank+-301,	pp2svec+39,	pp2vstop+133,
pp2crank+0,	0,		pp2vstop+136,
pp2crank+-210,	pp2svec+39,	pp2vstop+138,
pp2crank+-214,	pp2svec+39,	pp2vstop+142,
pp2crank+-343,	0,		pp2vstop+146,
pp2crank+-159,	pp2svec+49,	pp2vstop+148,
pp2crank+0,	0,		pp2vstop+151,
pp2crank+110,	0,		pp2vstop+154,
pp2crank+-174,	pp2svec+49,	pp2vstop+156,
pp2crank+-184,	pp2svec+49,	pp2vstop+158,
pp2crank+-347,	pp2svec+49,	pp2vstop+161,
pp2crank+-282,	pp2svec+49,	pp2vstop+164,
pp2crank+0,	pp2svec+20,	pp2vstop+167,
pp2crank+0,	0,		pp2vstop+171,
pp2crank+202,	0,		0,	
pp2crank+0,	0,		pp2vstop+173,
pp2crank+0,	pp2svec+20,	0,	
pp2crank+0,	pp2svec+20,	pp2vstop+175,
pp2crank+0,	pp2svec+22,	pp2vstop+177,
pp2crank+31,	pp2svec+20,	pp2vstop+179,
pp2crank+-300,	pp2svec+25,	pp2vstop+181,
pp2crank+-137,	pp2svec+25,	pp2vstop+184,
pp2crank+-318,	pp2svec+25,	pp2vstop+187,
pp2crank+189,	0,		pp2vstop+189,
pp2crank+-368,	pp2svec+25,	pp2vstop+191,
pp2crank+-372,	pp2svec+25,	pp2vstop+194,
pp2crank+-377,	pp2svec+25,	pp2vstop+197,
pp2crank+-195,	pp2svec+39,	pp2vstop+199,
pp2crank+-65,	pp2svec+39,	pp2vstop+202,
pp2crank+-220,	pp2svec+39,	pp2vstop+205,
pp2crank+-66,	pp2svec+39,	pp2vstop+207,
pp2crank+-222,	pp2svec+39,	pp2vstop+210,
pp2crank+-295,	pp2svec+39,	pp2vstop+213,
pp2crank+-311,	pp2svec+39,	pp2vstop+216,
pp2crank+0,	0,		pp2vstop+218,
pp2crank+-397,	pp2svec+49,	pp2vstop+220,
pp2crank+-284,	pp2svec+49,	pp2vstop+222,
pp2crank+-404,	pp2svec+49,	pp2vstop+225,
0,	0,	0};
struct pp2work *pp2top = pp2crank+488;
struct pp2svf *pp2bgin = pp2svec+1;
char pp2match[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,014 ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,01  ,01  ,'$' ,01  ,01  ,01  ,
01  ,01  ,'*' ,01  ,01  ,01  ,01  ,01  ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,':' ,01  ,01  ,01  ,01  ,01  ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,':' ,01  ,']' ,01  ,'A' ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,01  ,01  ,01  ,01  ,
0};
char pp2extra[] = {
0,0,0,0,0,0,0,0,
0,0,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int pp2lineno =1;
# define PP2U(x) x
# define NLSTATE pp2previous=PP2NEWLINE
char pp2text[PP2LMAX];
struct pp2svf *pp2lstate [PP2LMAX], **pp2lsp, **pp2olsp;
char pp2sbuf[PP2LMAX];
char *pp2sptr = pp2sbuf;
int *pp2fnd;
extern struct pp2svf *pp2estate;
int pp2previous = PP2NEWLINE;
pp2look(){
	register struct pp2svf *pp2state, **lsp;
	register struct pp2work *pp2t;
	struct pp2svf *pp2z;
	int pp2ch, pp2first;
	struct pp2work *pp2r;
# ifdef LEXDEBUG
	int debug;
# endif
	char *pp2lastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	pp2first=1;
	if (!pp2morfg)
		pp2lastch = pp2text;
	else {
		pp2morfg=0;
		pp2lastch = pp2text+pp2leng;
		}
	for(;;){
		lsp = pp2lstate;
		pp2estate = pp2state = pp2bgin;
		if (pp2previous==PP2NEWLINE) pp2state++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(pp2out,"state %d\n",pp2state-pp2svec-1);
# endif
			pp2t = pp2state->pp2stoff;
			if(pp2t == pp2crank && !pp2first){  /* may not be any transitions */
				pp2z = pp2state->pp2other;
				if(pp2z == 0)break;
				if(pp2z->pp2stoff == pp2crank)break;
				}
			*pp2lastch++ = pp2ch = input();
			pp2first=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(pp2out,"char ");
				allprint(pp2ch);
				putchar('\n');
				}
# endif
			pp2r = pp2t;
			if ( (int)pp2t > (int)pp2crank){
				pp2t = pp2r + pp2ch;
				if (pp2t <= pp2top && pp2t->verify+pp2svec == pp2state){
					if(pp2t->advance+pp2svec == PP2LERR)	/* error transitions */
						{unput(*--pp2lastch);break;}
					*lsp++ = pp2state = pp2t->advance+pp2svec;
					goto contin;
					}
				}
# ifdef PP2OPTIM
			else if((int)pp2t < (int)pp2crank) {		/* r < pp2crank */
				pp2t = pp2r = pp2crank+(pp2crank-pp2t);
# ifdef LEXDEBUG
				if(debug)fprintf(pp2out,"compressed state\n");
# endif
				pp2t = pp2t + pp2ch;
				if(pp2t <= pp2top && pp2t->verify+pp2svec == pp2state){
					if(pp2t->advance+pp2svec == PP2LERR)	/* error transitions */
						{unput(*--pp2lastch);break;}
					*lsp++ = pp2state = pp2t->advance+pp2svec;
					goto contin;
					}
				pp2t = pp2r + PP2U(pp2match[pp2ch]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(pp2out,"try fall back character ");
					allprint(PP2U(pp2match[pp2ch]));
					putchar('\n');
					}
# endif
				if(pp2t <= pp2top && pp2t->verify+pp2svec == pp2state){
					if(pp2t->advance+pp2svec == PP2LERR)	/* error transition */
						{unput(*--pp2lastch);break;}
					*lsp++ = pp2state = pp2t->advance+pp2svec;
					goto contin;
					}
				}
			if ((pp2state = pp2state->pp2other) && (pp2t= pp2state->pp2stoff) != pp2crank){
# ifdef LEXDEBUG
				if(debug)fprintf(pp2out,"fall back to state %d\n",pp2state-pp2svec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--pp2lastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(pp2out,"state %d char ",pp2state-pp2svec-1);
				allprint(pp2ch);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(pp2out,"stopped at %d with ",*(lsp-1)-pp2svec-1);
			allprint(pp2ch);
			putchar('\n');
			}
# endif
		while (lsp-- > pp2lstate){
			*pp2lastch-- = 0;
			if (*lsp != 0 && (pp2fnd= (*lsp)->pp2stops) && *pp2fnd > 0){
				pp2olsp = lsp;
				if(pp2extra[*pp2fnd]){		/* must backup */
					while(pp2back((*lsp)->pp2stops,-*pp2fnd) != 1 && lsp > pp2lstate){
						lsp--;
						unput(*pp2lastch--);
						}
					}
				pp2previous = PP2U(*pp2lastch);
				pp2lsp = lsp;
				pp2leng = pp2lastch-pp2text+1;
				pp2text[pp2leng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(pp2out,"\nmatch ");
					sprint(pp2text);
					fprintf(pp2out," action %d\n",*pp2fnd);
					}
# endif
				return(*pp2fnd++);
				}
			unput(*pp2lastch);
			}
		if (pp2text[0] == 0  /* && feof(pp2in) */)
			{
			pp2sptr=pp2sbuf;
			return(0);
			}
		pp2previous = pp2text[0] = input();
		if (pp2previous>0)
			output(pp2previous);
		pp2lastch=pp2text;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
pp2back(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
pp2input(){
	return(input());
	}
pp2output(c)
  int c; {
	output(c);
	}
pp2unput(c)
   int c; {
	unput(c);
	}
