%{

/**************************************************************************
 * Version identification:
 * @(#)pass1Lex.l	1.9	10/9/91
 *
 *  Copyright (c) 1990,1991 The Regents of the University of California.
 *                        All Rights Reserved.
 *
 *  Programmer:  Anders Wass
 *  Date of creation: 11/02/91
 *  Modified:  05/14/91  A Wass.  Added code to pick the first comment block
 *				  and use that as a descriptor text.
 *
 *
 *  Description:
 *
 * This is a lexical analyzer to yacc pass1. It looks for keywords or
 * characters with special meaning and returns the appropriate token to
 * yacc. Every character or word that not match is copied to the outfile.
 * No vector macro translation is done here, since I thought it would be
 * easier to deal with that after the new C++ file was created, since this
 * new file differ quite a lot from both the model file and the C-file
 * generated by epp.
 *
 *	-- Anders Wass 1990/11/02
 *
 ****************************************************************************/


static char identification[] = "@(#)pass1Lex.l	1.9\t10/9/91  (c) UC Berkeley";

#ifndef YYSTACKSIZE
#define YYSTACKSIZE 32
#endif

static struct yysvf *yysvfstack[YYSTACKSIZE];
static int yystackptr=0;
static char lstack_id[] =
    "@(#)lexststack.Pc\t1.0\t1990/10/23  (c) UCB,  A Wass";

static void inityysvfstack()
{
    yystackptr=0;
    yysvfstack[0] = yybgin + 1;
}

static void yylexpush(state)
    struct yysvf *state;
{
    if (yystackptr>=YYSTACKSIZE) {
	fprintf(stderr,"lex: state stack overflow. (>=%d)\n",YYSTACKSIZE);
	exit(1);
    }
    yysvfstack[yystackptr++] = state;
}

static struct yysvf *yylexpop()
{
    if (yystackptr==0) {
	fprintf(stderr,"lex: state stack underflow.\n");
	exit(1);
    }
    return yysvfstack[--yystackptr];
}

#define POP yybgin = yylexpop()
#define PUSH yylexpush(yybgin)
#define CLEARSTSTACK inityysvfstack()

#include "comdefs.h"
#include "pass1Syn.h"
#include <ctype.h>

/* resulting C++ file, existing C-model file and tmporary `go' c-code file */
extern FILE *ccfile, *modfile, *cctmp;
extern FILE *p1lexout;		/* set by function pass1() */
extern ICL *iclptr;		/* declared in utils.c, used in pass1Syn.y as well. */
#define STRBUFSIZ 2*BUFSIZ
static char descbuf[STRBUFSIZ];
static char *descptr = NULL;
int elflg=0, tell=0, modflg = 0, descflg = 0, eocomflg = 0,
    comcnt = 0, lastcomline = 0, cancat = 0;

static char* pstrncat(to,from,n)
    char *to, *from;
    int n;
{
    int totlen = strlen(to) + n;
    strncat(to,from,n);
    to[totlen] = NULL;
    return to;
}

static int getstrlen(s1,s2)
    char *s1, *s2;
{
    register int l1, l2, ltot;
    l1 = strlen(s1); l2 = strlen(s2);
    ltot = l1 + l2;
    if (ltot < STRBUFSIZ - 1)
	return l2;
    else
	return STRBUFSIZ - l1 - 1;
}

static void unset_cancat()
{
    if (!cancat) return;
    cancat = 0;
    errmsg("s","\"%s\", line %3d: warning: %s\n  (%s %s %d characters.)\n",
	   FileIParse, yylineno, "Descriptor buffer full.",
	   "Text will be truncated.",
	   "Original string longer than", STRBUFSIZ - 1);
}

%}

%a 3000
%p 3000

D		[0-9]
E		[DEde][+-]?{D}+
FF		\14

NAME		_?[a-zA-Z][a-zA-Z0-9_\$]*
    /* INTEGER		[-+]?{D}+
       REAL		[-+]?{D}+"." |
		[-+]?{D}+"."{D}*({E})? |
		[-+]?{D}+{E} */

%START ICODE MDL LIST TEMP CV COMMENT

%%
    CLEARSTSTACK;
    yyin=modfile;
    yyout=p1lexout;
    if (!descptr) {
	descptr = descbuf;
	*descptr = NULL;
	cancat = 1;
    }

" \t"			{
			    fputs(yytext,p1lexout);
			    if (descflg && cancat) {
				int slen;
				if (slen = getstrlen(descptr,yytext))
				    pstrncat(descptr,yytext,slen);
				else
				    unset_cancat();
			    }
			}
{FF}			;
\n			{
			    fputs("\n",p1lexout);
			    if ((descflg || eocomflg) && cancat) {
				int slen;
				eocomflg = 0;
				if (getstrlen(descptr,"\n"))
				    strcat(descptr,"\n");
				else
				    unset_cancat();
			    }
			    if (tell) {
				whereIam(p1lexout,yylineno,FileIParse);
				tell=0;
			    }
			}

^([ \t]*)?#([ \t]*)?[a-zA-Z].* {
			    if (yytext[yyleng-1] == '\\')
				yymore();
			    else
				fprintf(p1lexout,"%s", yytext); 
			}

MODEL			{   modflg++; BEGIN MDL; return MODEL;   }
<MDL>[(){]		{
			    if (yytext[0] == '{') {
				p1lexout = cctmp;
				BEGIN 0;
			    }
			    return *yytext;
			}
<MDL>{NAME}		{   yylval.str = savestr(yytext); return WORD;   }
IN_LIST			{   BEGIN LIST; yylval.ival = yylineno; return IN_LIST;   }
OUT_LIST		{   BEGIN LIST; yylval.ival = yylineno; return OUT_LIST;   }
BI_LIST			{   BEGIN LIST; yylval.ival = yylineno; return BI_LIST;   }
ST_LIST			{   BEGIN LIST; yylval.ival = yylineno; return ST_LIST;   }

<LIST>ENDLIST		{
			    elflg=1;
			    tell=1;
			    yylval.ival = yylineno;
			    return ENDLIST;   }
<LIST>[(),;]		{
			    if (elflg && *yytext == ';') {
				elflg=0;
				BEGIN 0;
			    }
			    return *yytext;
			}
<TEMP,CV>[(),;]		{   if (*yytext == ';') BEGIN 0; return *yytext;   }
<LIST>SIG		{   yylval.ival = yylineno; return SIG;   }
<LIST>TSIG		{   yylval.ival = yylineno; return TSIG;   }
<LIST>GRP		{   yylval.ival = yylineno; return GRP;   }
<LIST>BUS		{   yylval.ival = yylineno; return GRP;   }
<LIST>REG		{   yylval.ival = yylineno; return GRP;   }
<LIST>MEM		{   yylval.ival = yylineno; return GRP;   }
<LIST>VGRP		{   yylval.ival = yylineno; return VGRP;   }
<LIST>VBUS		{   yylval.ival = yylineno; return VGRP;   }
<LIST>TGRP		{   yylval.ival = yylineno; return TGRP;   }
<LIST,TEMP>[-+]?{D}+	{   yylval.str = savestr(yytext); return WORD;   }
<LIST,TEMP>BIGENDIAN	{   return BIGEND;   }
<LIST,TEMP>LSB0		{   return BIGEND;   }
<LIST,TEMP>LITTLEENDIAN	{   return LITTLEEND;   }
<LIST,TEMP>MSB0		{   return LITTLEEND;   }
<LIST,TEMP>{NAME}	{   yylval.str = savestr(yytext); return WORD;   }
<LIST,TEMP>[ \t{FF}]*	{   ;   }
<LIST,TEMP,CV>\n	{   ;   }
<CV>[ \t]*PRIVATE	{   yylval.ival = yylineno; return PRIVATE;   }
<CV>[ \t]*PROTECTED	{   yylval.ival = yylineno; return PROTECTED;   }
<CV>[ \t]*PUBLIC	{   yylval.ival = yylineno; return PUBLIC;   }
<CV>[^(),;\n]*		{
			    char *s = yytext;
			    while (isspace(*s)) s++; /* remove leading spaces */
			    yylval.str = savestr(s);
			    s = yylval.str;
			    while (*s) s++;
			    s--;
			    while (isspace(*s) && s > yylval.str) s--;
			    *(s+1) = NULL; /* remove trailing spaces */
			    return WORD;
			}
TSIG			{   BEGIN TEMP; yylval.ival = yylineno; return TSIG;   }
TGRP			{   BEGIN TEMP; yylval.ival = yylineno; return TGRP;   }
"C++VAR"		{   BEGIN CV; yylval.ival = yylineno; return CVAR;  }

INIT			{   BEGIN ICODE;   }
<ICODE>^[ \t]*ENDINIT[ \t\n]*;? {
			    tell=1;
			    BEGIN 0;
			}
<ICODE>.*		{   iclptr = saveInitCode(yytext,yylineno,iclptr);   }

<COMMENT>"*/"		{
			    fprintf(p1lexout,"%s",yytext);
			    if (descflg && cancat) {
				int slen;
				eocomflg = 1;
				descflg = 0;
				if (slen = getstrlen(descptr,yytext))
				    pstrncat(descptr,yytext,slen);
				else
				    unset_cancat();
			    }
			    lastcomline = yylineno;
			    POP;
			}
<COMMENT>[^*\n]*	|
<COMMENT>"*"		{
			    fprintf(p1lexout,"%s",yytext);
			    if (descflg && cancat) {
				int slen;
				if (slen = getstrlen(descptr,yytext))
				    pstrncat(descptr,yytext,slen);
				else
				    unset_cancat();
			    }
			}
"/*"			{
			    comcnt++;
			    if (comcnt > 1 && yylineno - lastcomline <= 1)
				comcnt--;
			    if (comcnt == 1 && !modflg) {
				int slen;
				descflg = 1;
				eocomflg = 0;
				if (slen = getstrlen(descptr,yytext))
				    pstrncat(descptr,yytext,slen);
				else
				    unset_cancat();
			    }
			    fprintf(p1lexout,"%s",yytext);
			    PUSH; BEGIN COMMENT;
			}
^[.]*			{   fprintf(p1lexout,"%s",yytext);   }
%%

int yywrap() { return 1; }

char *getdescriptor()
{
    if (descbuf[0])
	return descbuf;
    else
	return NULL;
}

static char *bptr = NULL, *start = NULL;

static char linebuf[256];

char *getdescline(strptr)
    char *strptr;
{
    char *stop, *s;
    if (strptr) {
	bptr = start = strptr;
    }
    if (!start || !*start)
	return NULL;
    
    for (s = linebuf, stop = start; *stop && *stop != '\n'; s++, stop++) {
	if (*stop == '"')
	    *s++ = '\\';
	*s = *stop;
    }
    *s = NULL;
    if (*stop)
	stop++;
    start = stop;
    return linebuf;
}
