# include <stdio.h>
# define U(x) x
# define NLSTATE pp1previous=PP1NEWLINE
# define BEGIN pp1bgin = pp1svec + 1 +
# define INITIAL 0
# define PP1LERR pp1svec
# define PP1STATE (pp1estate-pp1svec-1)
# define PP1OPTIM 1
# define PP1LMAX BUFSIZ
# define output(c) putc(c,pp1out)
# define input() (((pp1tchar=pp1sptr>pp1sbuf?U(*--pp1sptr):getc(pp1in))==10?(pp1lineno++,pp1tchar):pp1tchar)==EOF?0:pp1tchar)
# define unput(c) {pp1tchar= (c);if(pp1tchar=='\n')pp1lineno--;*pp1sptr++=pp1tchar;}
# define pp1more() (pp1morfg=1)
# define ECHO fprintf(pp1out, "%s",pp1text)
# define REJECT { nstr = pp1reject(); goto pp1fussy;}
int pp1leng; extern char pp1text[];
int pp1morfg;
extern char *pp1sptr, pp1sbuf[];
int pp1tchar;
FILE *pp1in = {stdin}, *pp1out = {stdout};
extern int pp1lineno;
struct pp1svf { 
	struct pp1work *pp1stoff;
	struct pp1svf *pp1other;
	int *pp1stops;};
struct pp1svf *pp1estate;
extern struct pp1svf pp1svec[], *pp1bgin;

/**************************************************************************
 * Version identification:
 * @(#)pass1Lex.l	1.9	10/9/91
 *
 *  Copyright (c) 1990,1991 The Regents of the University of California.
 *                        All Rights Reserved.
 *
 *  Programmer:  Anders Wass
 *  Date of creation: 11/02/91
 *  Modified:  05/14/91  A Wass.  Added code to pick the first comment block
 *				  and use that as a descriptor text.
 *
 *
 *  Description:
 *
 * This is a lexical analyzer to yacc pass1. It looks for keywords or
 * characters with special meaning and returns the appropriate token to
 * yacc. Every character or word that not match is copied to the outfile.
 * No vector macro translation is done here, since I thought it would be
 * easier to deal with that after the new C++ file was created, since this
 * new file differ quite a lot from both the model file and the C-file
 * generated by epp.
 *
 *	-- Anders Wass 1990/11/02
 *
 ****************************************************************************/


static char identification[] = "@(#)pass1Lex.l	1.9\t10/9/91  (c) UC Berkeley";

#ifndef PP1STACKSIZE
#define PP1STACKSIZE 32
#endif

static struct pp1svf *pp1svfstack[PP1STACKSIZE];
static int pp1stackptr=0;
static char lstack_id[] =
    "@(#)lexststack.Pc\t1.0\t1990/10/23  (c) UCB,  A Wass";

static void initpp1svfstack()
{
    pp1stackptr=0;
    pp1svfstack[0] = pp1bgin + 1;
}

static void pp1lexpush(state)
    struct pp1svf *state;
{
    if (pp1stackptr>=PP1STACKSIZE) {
	fprintf(stderr,"lex: state stack overflow. (>=%d)\n",PP1STACKSIZE);
	exit(1);
    }
    pp1svfstack[pp1stackptr++] = state;
}

static struct pp1svf *pp1lexpop()
{
    if (pp1stackptr==0) {
	fprintf(stderr,"lex: state stack underflow.\n");
	exit(1);
    }
    return pp1svfstack[--pp1stackptr];
}

#define POP pp1bgin = pp1lexpop()
#define PUSH pp1lexpush(pp1bgin)
#define CLEARSTSTACK initpp1svfstack()

#include "comdefs.h"
#include "pass1Syn.h"
#include <ctype.h>

/* resulting C++ file, existing C-model file and tmporary `go' c-code file */
extern FILE *ccfile, *modfile, *cctmp;
extern FILE *p1lexout;		/* set by function pass1() */
extern ICL *iclptr;		/* declared in utils.c, used in pass1Syn.y as well. */
#define STRBUFSIZ 2*BUFSIZ
static char descbuf[STRBUFSIZ];
static char *descptr = NULL;
int elflg=0, tell=0, modflg = 0, descflg = 0, eocomflg = 0,
    comcnt = 0, lastcomline = 0, cancat = 0;

static char* pstrncat(to,from,n)
    char *to, *from;
    int n;
{
    int totlen = strlen(to) + n;
    strncat(to,from,n);
    to[totlen] = NULL;
    return to;
}

static int getstrlen(s1,s2)
    char *s1, *s2;
{
    register int l1, l2, ltot;
    l1 = strlen(s1); l2 = strlen(s2);
    ltot = l1 + l2;
    if (ltot < STRBUFSIZ - 1)
	return l2;
    else
	return STRBUFSIZ - l1 - 1;
}

static void unset_cancat()
{
    if (!cancat) return;
    cancat = 0;
    errmsg("s","\"%s\", line %3d: warning: %s\n  (%s %s %d characters.)\n",
	   FileIParse, pp1lineno, "Descriptor buffer full.",
	   "Text will be truncated.",
	   "Original string longer than", STRBUFSIZ - 1);
}

    /* INTEGER		[-+]?{D}+
       REAL		[-+]?{D}+"." |
		[-+]?{D}+"."{D}*({E})? |
		[-+]?{D}+{E} */
# define ICODE 2
# define MDL 4
# define LIST 6
# define TEMP 8
# define CV 10
# define COMMENT 12
# define PP1NEWLINE 10
pp1lex(){
int nstr; extern int pp1previous;
   CLEARSTSTACK;
   pp1in=modfile;
   pp1out=p1lexout;
   if (!descptr) {
	descptr = descbuf;
	*descptr = NULL;
	cancat = 1;
    }
while((nstr = pp1look()) >= 0)
pp1fussy: switch(nstr){
case 0:
if(pp1wrap()) return(0); break;
case 1:
		{
			    fputs(pp1text,p1lexout);
			    if (descflg && cancat) {
				int slen;
				if (slen = getstrlen(descptr,pp1text))
				    pstrncat(descptr,pp1text,slen);
				else
				    unset_cancat();
			    }
			}
break;
case 2:
		;
break;
case 3:
		{
			    fputs("\n",p1lexout);
			    if ((descflg || eocomflg) && cancat) {
				int slen;
				eocomflg = 0;
				if (getstrlen(descptr,"\n"))
				    strcat(descptr,"\n");
				else
				    unset_cancat();
			    }
			    if (tell) {
				whereIam(p1lexout,pp1lineno,FileIParse);
				tell=0;
			    }
			}
break;
case 4:
{
			    if (pp1text[pp1leng-1] == '\\')
				pp1more();
			    else
				fprintf(p1lexout,"%s", pp1text); 
			}
break;
case 5:
		{   modflg++; BEGIN MDL; return MODEL;   }
break;
case 6:
	{
			    if (pp1text[0] == '{') {
				p1lexout = cctmp;
				BEGIN 0;
			    }
			    return *pp1text;
			}
break;
case 7:
	{   pp1lval.str = savestr(pp1text); return WORD;   }
break;
case 8:
		{   BEGIN LIST; pp1lval.ival = pp1lineno; return IN_LIST;   }
break;
case 9:
	{   BEGIN LIST; pp1lval.ival = pp1lineno; return OUT_LIST;   }
break;
case 10:
		{   BEGIN LIST; pp1lval.ival = pp1lineno; return BI_LIST;   }
break;
case 11:
		{   BEGIN LIST; pp1lval.ival = pp1lineno; return ST_LIST;   }
break;
case 12:
	{
			    elflg=1;
			    tell=1;
			    pp1lval.ival = pp1lineno;
			    return ENDLIST;   }
break;
case 13:
	{
			    if (elflg && *pp1text == ';') {
				elflg=0;
				BEGIN 0;
			    }
			    return *pp1text;
			}
break;
case 14:
	{   if (*pp1text == ';') BEGIN 0; return *pp1text;   }
break;
case 15:
	{   pp1lval.ival = pp1lineno; return SIG;   }
break;
case 16:
	{   pp1lval.ival = pp1lineno; return TSIG;   }
break;
case 17:
	{   pp1lval.ival = pp1lineno; return GRP;   }
break;
case 18:
	{   pp1lval.ival = pp1lineno; return GRP;   }
break;
case 19:
	{   pp1lval.ival = pp1lineno; return GRP;   }
break;
case 20:
	{   pp1lval.ival = pp1lineno; return GRP;   }
break;
case 21:
	{   pp1lval.ival = pp1lineno; return VGRP;   }
break;
case 22:
	{   pp1lval.ival = pp1lineno; return VGRP;   }
break;
case 23:
	{   pp1lval.ival = pp1lineno; return TGRP;   }
break;
case 24:
{   pp1lval.str = savestr(pp1text); return WORD;   }
break;
case 25:
{   return BIGEND;   }
break;
case 26:
	{   return BIGEND;   }
break;
case 27:
{   return LITTLEEND;   }
break;
case 28:
	{   return LITTLEEND;   }
break;
case 29:
{   pp1lval.str = savestr(pp1text); return WORD;   }
break;
case 30:
{   ;   }
break;
case 31:
{   ;   }
break;
case 32:
{   pp1lval.ival = pp1lineno; return PRIVATE;   }
break;
case 33:
{   pp1lval.ival = pp1lineno; return PROTECTED;   }
break;
case 34:
{   pp1lval.ival = pp1lineno; return PUBLIC;   }
break;
case 35:
	{
			    char *s = pp1text;
			    while (isspace(*s)) s++; /* remove leading spaces */
			    pp1lval.str = savestr(s);
			    s = pp1lval.str;
			    while (*s) s++;
			    s--;
			    while (isspace(*s) && s > pp1lval.str) s--;
			    *(s+1) = NULL; /* remove trailing spaces */
			    return WORD;
			}
break;
case 36:
		{   BEGIN TEMP; pp1lval.ival = pp1lineno; return TSIG;   }
break;
case 37:
		{   BEGIN TEMP; pp1lval.ival = pp1lineno; return TGRP;   }
break;
case 38:
	{   BEGIN CV; pp1lval.ival = pp1lineno; return CVAR;  }
break;
case 39:
		{   BEGIN ICODE;   }
break;
case 40:
{
			    tell=1;
			    BEGIN 0;
			}
break;
case 41:
	{   iclptr = saveInitCode(pp1text,pp1lineno,iclptr);   }
break;
case 42:
	{
			    fprintf(p1lexout,"%s",pp1text);
			    if (descflg && cancat) {
				int slen;
				eocomflg = 1;
				descflg = 0;
				if (slen = getstrlen(descptr,pp1text))
				    pstrncat(descptr,pp1text,slen);
				else
				    unset_cancat();
			    }
			    lastcomline = pp1lineno;
			    POP;
			}
break;
case 43:
case 44:
	{
			    fprintf(p1lexout,"%s",pp1text);
			    if (descflg && cancat) {
				int slen;
				if (slen = getstrlen(descptr,pp1text))
				    pstrncat(descptr,pp1text,slen);
				else
				    unset_cancat();
			    }
			}
break;
case 45:
		{
			    comcnt++;
			    if (comcnt > 1 && pp1lineno - lastcomline <= 1)
				comcnt--;
			    if (comcnt == 1 && !modflg) {
				int slen;
				descflg = 1;
				eocomflg = 0;
				if (slen = getstrlen(descptr,pp1text))
				    pstrncat(descptr,pp1text,slen);
				else
				    unset_cancat();
			    }
			    fprintf(p1lexout,"%s",pp1text);
			    PUSH; BEGIN COMMENT;
			}
break;
case 46:
		{   fprintf(p1lexout,"%s",pp1text);   }
break;
case -1:
break;
default:
fprintf(pp1out,"bad switch pp1look %d",nstr);
} return(0); }
/* end of pp1lex */

int pp1wrap() { return 1; }

char *getdescriptor()
{
    if (descbuf[0])
	return descbuf;
    else
	return NULL;
}

static char *bptr = NULL, *start = NULL;

static char linebuf[256];

char *getdescline(strptr)
    char *strptr;
{
    char *stop, *s;
    if (strptr) {
	bptr = start = strptr;
    }
    if (!start || !*start)
	return NULL;
    
    for (s = linebuf, stop = start; *stop && *stop != '\n'; s++, stop++) {
	if (*stop == '"')
	    *s++ = '\\';
	*s = *stop;
    }
    *s = NULL;
    if (*stop)
	stop++;
    start = stop;
    return linebuf;
}
int pp1vstop[] = {
0,

30,
35,
41,
43,
46,
0,

30,
35,
41,
43,
46,
0,

30,
35,
41,
43,
46,
0,

30,
35,
41,
43,
46,
0,

30,
35,
41,
43,
46,
0,

30,
35,
41,
43,
46,
0,

30,
35,
41,
43,
46,
0,

30,
35,
41,
43,
46,
0,

30,
35,
41,
43,
46,
0,

30,
35,
41,
43,
46,
0,

30,
35,
41,
43,
46,
0,

30,
35,
41,
43,
46,
0,

30,
35,
41,
43,
46,
0,

30,
35,
41,
43,
46,
0,

3,
0,

2,
0,

46,
0,

41,
0,

2,
41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
46,
0,

41,
0,

6,
0,

7,
0,

7,
0,

7,
0,

7,
0,

7,
0,

7,
0,

7,
0,

7,
0,

30,
0,

3,
31,
0,

30,
0,

13,
0,

24,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
30,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

30,
0,

30,
0,

14,
0,

29,
0,

29,
0,

29,
0,

29,
0,

35,
0,

35,
0,

2,
35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
46,
0,

43,
0,

2,
43,
0,

43,
0,

44,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
46,
0,

1,
0,

45,
0,

1,
0,

4,
0,

1,
41,
0,

41,
45,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

1,
41,
0,

4,
41,
0,

41,
0,

7,
0,

7,
0,

7,
0,

7,
0,

7,
0,

7,
0,

7,
0,

1,
30,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

1,
30,
0,

29,
0,

29,
0,

1,
35,
0,

35,
45,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

1,
35,
0,

4,
35,
0,

1,
43,
0,

42,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

1,
43,
0,

4,
43,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

7,
0,

7,
0,

7,
0,

7,
0,

7,
0,

7,
0,

7,
0,

7,
0,

29,
0,

29,
0,

18,
29,
0,

29,
0,

17,
29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

20,
29,
0,

29,
0,

29,
0,

29,
0,

19,
29,
0,

15,
29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

39,
0,

37,
0,

36,
0,

41,
0,

41,
0,

39,
41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

37,
41,
0,

36,
41,
0,

41,
0,

7,
0,

7,
39,
0,

7,
0,

7,
0,

7,
0,

7,
0,

7,
37,
0,

7,
36,
0,

29,
0,

29,
0,

29,
0,

29,
39,
0,

29,
0,

29,
0,

26,
29,
0,

29,
0,

28,
29,
0,

29,
0,

29,
0,

23,
29,
37,
0,

16,
29,
36,
0,

22,
29,
0,

21,
29,
0,

29,
37,
0,

29,
36,
0,

35,
0,

35,
0,

35,
39,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
37,
0,

35,
36,
0,

43,
0,

43,
0,

39,
43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

37,
43,
0,

36,
43,
0,

5,
0,

41,
0,

41,
0,

41,
0,

5,
41,
0,

41,
0,

41,
0,

41,
0,

7,
0,

7,
0,

5,
7,
0,

7,
0,

7,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

5,
29,
0,

29,
0,

29,
0,

35,
0,

35,
0,

35,
0,

5,
35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

43,
0,

43,
0,

43,
0,

5,
43,
0,

43,
0,

43,
0,

38,
0,

41,
0,

38,
41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

7,
0,

7,
0,

7,
0,

7,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

35,
0,

35,
38,
0,

35,
0,

35,
0,

35,
0,

35,
0,

34,
35,
0,

35,
0,

43,
0,

38,
43,
0,

43,
0,

43,
0,

43,
0,

10,
0,

8,
0,

11,
0,

10,
41,
0,

8,
41,
0,

41,
0,

11,
41,
0,

40,
41,
0,

7,
10,
0,

7,
8,
0,

7,
0,

7,
11,
0,

29,
0,

10,
29,
0,

12,
29,
0,

8,
29,
0,

29,
0,

29,
0,

11,
29,
0,

10,
35,
0,

8,
35,
0,

35,
0,

32,
35,
0,

35,
0,

11,
35,
0,

10,
43,
0,

8,
43,
0,

43,
0,

11,
43,
0,

9,
0,

9,
41,
0,

40,
0,

40,
41,
0,

7,
9,
0,

29,
0,

29,
0,

9,
29,
0,

9,
35,
0,

35,
0,

9,
43,
0,

40,
0,

25,
29,
0,

29,
0,

33,
35,
0,

29,
0,

29,
0,

27,
29,
0,
0};
# define PP1TYPE int
struct pp1work { PP1TYPE verify, advance; } pp1crank[] = {
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	17,117,	1,15,	
2,26,	1,16,	26,26,	27,127,	
6,26,	31,0,	32,129,	32,0,	
33,0,	35,0,	44,0,	58,149,	
0,0,	0,0,	38,0,	0,0,	
39,0,	0,0,	0,0,	0,0,	
36,0,	1,17,	37,0,	2,27,	
34,0,	26,26,	2,28,	6,27,	
26,28,	32,30,	6,28,	18,118,	
20,120,	40,0,	49,120,	29,29,	
1,18,	2,29,	64,120,	3,30,	
33,130,	6,29,	35,132,	0,0,	
35,30,	0,0,	44,44,	3,30,	
3,15,	0,0,	3,31,	43,43,	
43,0,	0,0,	0,0,	1,19,	
1,20,	0,0,	45,0,	0,0,	
0,0,	0,0,	1,21,	19,119,	
48,142,	0,0,	1,22,	21,121,	
1,23,	22,122,	3,32,	25,125,	
1,24,	1,25,	3,30,	23,123,	
4,41,	24,124,	3,30,	4,31,	
3,30,	3,30,	3,30,	25,126,	
3,30,	3,33,	3,30,	34,131,	
36,133,	38,135,	39,136,	37,134,	
41,41,	41,0,	40,137,	50,143,	
51,144,	52,145,	53,146,	4,42,	
65,152,	67,153,	4,43,	3,30,	
3,34,	3,35,	40,138,	43,140,	
3,30,	42,139,	42,0,	3,36,	
43,140,	4,44,	4,33,	3,37,	
54,147,	3,38,	41,43,	63,150,	
68,154,	3,39,	3,40,	5,15,	
71,160,	5,16,	45,141,	69,155,	
54,148,	72,161,	73,162,	63,151,	
42,41,	4,34,	4,35,	42,43,	
4,45,	69,156,	80,150,	82,163,	
4,36,	73,163,	102,0,	56,56,	
4,37,	5,17,	4,38,	74,164,	
70,157,	77,77,	4,39,	4,40,	
41,45,	5,46,	5,46,	83,169,	
104,186,	119,197,	70,158,	74,165,	
5,18,	3,30,	70,159,	3,30,	
81,158,	75,166,	56,56,	83,170,	
81,159,	42,45,	75,167,	120,198,	
77,77,	105,0,	102,0,	77,28,	
122,201,	110,0,	5,47,	5,48,	
5,49,	5,47,	5,47,	5,47,	
5,47,	5,47,	5,50,	5,47,	
5,47,	5,47,	5,51,	5,47,	
5,52,	5,47,	5,47,	5,47,	
5,53,	5,54,	5,47,	5,47,	
5,47,	5,47,	5,47,	5,47,	
56,56,	105,118,	123,202,	124,203,	
5,55,	110,0,	5,47,	5,47,	
5,47,	5,47,	5,47,	5,47,	
5,47,	5,47,	5,47,	5,47,	
5,47,	5,47,	5,47,	5,47,	
5,47,	5,47,	5,47,	5,47,	
5,47,	5,47,	5,47,	5,47,	
5,47,	5,47,	5,47,	5,47,	
5,46,	7,56,	7,57,	78,168,	
7,16,	60,61,	60,61,	60,61,	
60,61,	60,61,	60,61,	60,61,	
60,61,	60,61,	60,61,	125,204,	
110,191,	126,205,	116,0,	129,0,	
106,0,	56,56,	130,0,	56,56,	
7,58,	142,216,	78,77,	144,219,	
145,220,	78,28,	146,221,	147,222,	
7,59,	7,59,	121,199,	7,60,	
7,59,	7,60,	148,223,	7,18,	
7,61,	7,61,	7,61,	7,61,	
7,61,	7,61,	7,61,	7,61,	
7,61,	7,61,	116,0,	7,59,	
106,0,	107,0,	116,116,	151,226,	
121,200,	7,62,	7,63,	7,64,	
7,62,	7,65,	7,66,	7,67,	
7,62,	7,68,	7,62,	7,62,	
7,69,	7,70,	7,62,	7,71,	
7,62,	7,62,	7,72,	7,73,	
7,74,	7,62,	7,75,	7,62,	
7,62,	7,62,	7,62,	106,187,	
111,0,	107,0,	107,188,	7,76,	
107,101,	7,62,	7,62,	7,62,	
7,62,	7,62,	7,62,	7,62,	
7,62,	7,62,	7,62,	7,62,	
7,62,	7,62,	7,62,	7,62,	
7,62,	7,62,	7,62,	7,62,	
7,62,	7,62,	7,62,	7,62,	
7,62,	7,62,	7,62,	7,56,	
111,0,	7,56,	8,0,	8,0,	
8,0,	8,0,	8,0,	8,0,	
8,0,	8,0,	8,77,	8,57,	
8,0,	8,16,	8,0,	8,0,	
8,0,	8,0,	8,0,	8,0,	
8,0,	8,0,	8,0,	8,0,	
8,0,	8,0,	8,0,	8,0,	
8,0,	8,0,	8,0,	8,0,	
8,0,	8,78,	8,0,	8,0,	
8,28,	8,0,	8,0,	8,0,	
8,0,	8,59,	111,192,	8,0,	
8,60,	8,59,	134,0,	8,29,	
8,18,	8,61,	109,0,	137,0,	
141,0,	103,185,	103,0,	113,113,	
113,0,	138,0,	152,227,	8,0,	
153,228,	8,0,	8,0,	8,0,	
8,0,	8,0,	8,62,	8,63,	
8,64,	86,0,	8,65,	8,66,	
8,67,	132,0,	8,68,	155,231,	
103,101,	8,69,	8,70,	143,217,	
8,71,	113,115,	109,0,	8,72,	
8,73,	8,74,	103,0,	8,75,	
113,0,	114,195,	114,0,	154,229,	
8,0,	8,0,	8,0,	8,0,	
8,76,	8,0,	131,0,	86,0,	
86,0,	143,218,	136,0,	86,0,	
134,210,	156,232,	132,207,	135,0,	
132,30,	157,233,	141,215,	158,234,	
114,113,	154,230,	133,0,	114,115,	
159,235,	160,236,	86,0,	109,190,	
138,214,	161,237,	114,0,	137,213,	
8,56,	8,0,	8,56,	8,0,	
8,0,	9,0,	9,0,	9,0,	
9,0,	9,0,	9,0,	9,0,	
9,0,	9,56,	9,57,	9,0,	
9,16,	9,0,	9,0,	9,0,	
9,0,	9,0,	9,0,	9,0,	
9,0,	9,0,	9,0,	9,0,	
9,0,	9,0,	9,0,	9,0,	
9,0,	9,0,	9,0,	9,0,	
9,58,	9,0,	9,0,	9,0,	
9,0,	9,0,	9,0,	9,0,	
9,79,	162,238,	9,0,	9,60,	
9,79,	150,224,	9,0,	9,18,	
9,61,	133,208,	85,85,	85,0,	
163,239,	135,211,	164,240,	131,206,	
88,0,	165,241,	9,0,	136,212,	
9,0,	9,0,	9,0,	9,0,	
9,0,	9,62,	9,80,	9,64,	
90,0,	150,225,	9,66,	133,209,	
166,242,	9,68,	167,243,	169,244,	
9,69,	9,81,	170,245,	9,71,	
197,267,	85,0,	85,0,	9,82,	
9,83,	85,0,	88,0,	88,0,	
88,172,	168,77,	88,0,	9,0,	
9,0,	9,0,	9,0,	9,76,	
9,0,	198,268,	90,0,	90,0,	
85,0,	90,174,	90,0,	90,84,	
199,269,	88,0,	200,270,	201,271,	
202,272,	203,273,	204,274,	205,275,	
168,77,	206,0,	209,0,	168,28,	
216,286,	90,0,	212,0,	217,287,	
207,0,	85,94,	210,0,	9,56,	
9,0,	9,56,	9,0,	9,0,	
10,0,	10,0,	10,0,	10,0,	
10,0,	10,0,	10,0,	10,0,	
10,77,	91,0,	10,0,	10,16,	
10,0,	10,0,	10,0,	10,0,	
10,0,	10,0,	10,0,	10,0,	
10,0,	10,0,	10,0,	10,0,	
10,0,	10,0,	10,0,	10,0,	
10,0,	10,0,	10,0,	10,78,	
10,0,	10,0,	10,28,	10,0,	
10,0,	10,0,	10,0,	91,0,	
91,0,	10,0,	108,0,	91,0,	
218,288,	10,29,	10,18,	12,97,	
219,289,	185,0,	12,86,	206,276,	
209,279,	210,280,	139,41,	139,0,	
212,282,	10,0,	91,0,	10,0,	
10,0,	10,0,	10,0,	10,0,	
194,0,	10,80,	10,64,	187,0,	
207,277,	220,290,	12,98,	192,0,	
10,68,	12,99,	108,0,	10,69,	
10,81,	91,175,	10,71,	221,291,	
139,43,	185,0,	10,82,	10,83,	
12,100,	12,88,	222,292,	190,0,	
223,293,	11,84,	10,0,	10,0,	
10,0,	10,0,	10,76,	10,0,	
194,0,	11,85,	11,57,	187,0,	
11,86,	189,0,	211,0,	192,0,	
12,89,	12,90,	224,294,	188,0,	
225,295,	112,0,	108,189,	12,91,	
227,296,	89,0,	139,45,	12,92,	
191,0,	12,93,	12,94,	190,0,	
11,87,	12,95,	12,96,	10,0,	
11,84,	10,0,	10,0,	194,266,	
11,79,	92,0,	11,84,	11,84,	
11,79,	189,0,	11,84,	11,88,	
11,84,	215,0,	13,101,	188,0,	
188,259,	112,0,	188,101,	89,0,	
89,0,	190,262,	13,101,	89,0,	
191,0,	13,102,	229,297,	214,0,	
187,258,	11,84,	11,89,	11,90,	
192,264,	213,0,	11,84,	92,0,	
92,0,	11,91,	89,0,	92,0,	
189,260,	11,92,	208,0,	11,93,	
11,94,	13,103,	112,193,	11,95,	
11,96,	13,101,	87,171,	87,0,	
89,173,	13,101,	92,0,	13,104,	
13,101,	13,101,	112,194,	13,101,	
13,105,	13,101,	189,261,	211,281,	
230,298,	231,299,	191,263,	232,300,	
234,301,	235,302,	236,303,	93,0,	
239,304,	87,85,	92,176,	240,305,	
215,285,	241,306,	13,101,	13,106,	
13,107,	87,0,	87,0,	13,101,	
242,307,	87,0,	13,108,	11,84,	
214,284,	11,84,	13,109,	243,308,	
13,110,	94,0,	244,309,	245,310,	
13,111,	13,112,	14,101,	260,0,	
87,0,	93,0,	93,0,	213,283,	
267,332,	93,0,	14,113,	14,15,	
268,333,	14,102,	270,334,	271,335,	
272,336,	273,337,	276,0,	278,0,	
208,278,	96,0,	283,0,	284,0,	
93,0,	87,94,	172,0,	94,0,	
94,0,	262,0,	286,345,	94,0,	
266,0,	14,114,	288,346,	260,0,	
14,115,	14,101,	289,347,	28,28,	
13,101,	14,101,	13,101,	14,104,	
14,101,	14,101,	94,0,	14,116,	
14,105,	14,101,	93,177,	96,0,	
96,0,	195,113,	195,0,	96,0,	
172,0,	172,0,	290,348,	291,349,	
172,0,	262,0,	28,28,	294,350,	
266,0,	295,351,	14,101,	14,106,	
14,107,	94,178,	96,0,	14,101,	
94,179,	296,352,	14,108,	172,0,	
298,353,	260,325,	14,109,	195,115,	
14,110,	276,338,	96,181,	299,354,	
14,111,	14,112,	195,0,	301,355,	
262,327,	259,0,	263,0,	193,0,	
285,0,	266,331,	96,182,	28,128,	
28,128,	28,128,	28,128,	28,128,	
28,128,	28,128,	28,128,	28,128,	
28,128,	28,128,	28,128,	28,128,	
28,128,	28,128,	28,128,	28,128,	
28,128,	28,128,	28,128,	28,128,	
28,128,	28,128,	28,128,	28,128,	
28,128,	259,0,	263,0,	193,0,	
14,101,	95,0,	14,101,	28,128,	
28,128,	28,128,	28,128,	28,128,	
28,128,	28,128,	28,128,	28,128,	
28,128,	28,128,	28,128,	28,128,	
28,128,	28,128,	28,128,	28,128,	
28,128,	28,128,	28,128,	28,128,	
28,128,	28,128,	28,128,	28,128,	
28,128,	30,30,	258,0,	95,0,	
95,0,	261,0,	265,0,	95,0,	
285,344,	30,30,	30,0,	193,265,	
279,0,	259,324,	303,356,	282,0,	
115,115,	115,0,	304,357,	97,97,	
97,0,	325,0,	95,0,	263,328,	
332,373,	100,0,	264,0,	280,0,	
281,0,	333,374,	330,0,	331,0,	
323,0,	334,375,	258,0,	336,376,	
30,30,	261,0,	265,0,	337,377,	
30,30,	341,0,	30,30,	30,30,	
30,30,	97,99,	30,30,	95,180,	
30,30,	115,0,	97,0,	97,0,	
339,0,	325,0,	97,0,	100,0,	
100,0,	345,384,	264,0,	100,0,	
346,385,	100,100,	330,0,	331,0,	
323,0,	30,30,	348,386,	47,47,	
258,323,	97,0,	30,30,	261,326,	
115,196,	349,387,	100,0,	279,340,	
265,330,	115,196,	282,343,	47,47,	
47,47,	47,47,	47,47,	47,47,	
47,47,	47,47,	47,47,	47,47,	
47,47,	350,388,	97,94,	351,389,	
264,329,	280,341,	281,342,	323,367,	
47,47,	47,47,	47,47,	47,47,	
47,47,	47,47,	47,47,	47,47,	
47,47,	47,47,	47,47,	47,47,	
47,47,	47,47,	47,47,	47,47,	
47,47,	47,47,	47,47,	47,47,	
47,47,	47,47,	47,47,	47,47,	
47,47,	47,47,	352,390,	30,30,	
339,379,	30,30,	47,47,	353,391,	
47,47,	47,47,	47,47,	47,47,	
47,47,	47,47,	47,47,	47,47,	
47,47,	47,47,	47,47,	47,47,	
47,47,	47,47,	47,47,	47,47,	
47,47,	47,47,	47,47,	47,47,	
47,47,	47,47,	47,47,	47,47,	
47,47,	47,47,	55,47,	55,47,	
55,47,	55,47,	55,47,	55,47,	
55,47,	55,47,	55,47,	55,47,	
55,47,	55,47,	55,47,	55,47,	
55,47,	55,47,	55,47,	55,47,	
55,47,	55,47,	55,47,	55,47,	
55,47,	55,47,	55,47,	55,47,	
354,392,	356,393,	357,394,	373,408,	
375,409,	173,0,	55,47,	55,47,	
55,47,	55,47,	55,47,	55,47,	
55,47,	55,47,	55,47,	55,47,	
55,47,	55,47,	55,47,	55,47,	
55,47,	55,47,	55,47,	55,47,	
55,47,	55,47,	55,47,	55,47,	
55,47,	55,47,	55,47,	55,47,	
62,62,	376,410,	377,411,	173,0,	
173,0,	379,0,	384,417,	173,0,	
385,418,	386,419,	387,420,	388,421,	
62,62,	62,62,	62,62,	62,62,	
62,62,	62,62,	62,62,	62,62,	
62,62,	62,62,	173,0,	389,422,	
370,0,	390,423,	391,424,	392,425,	
393,426,	62,62,	62,62,	62,62,	
62,62,	62,62,	62,62,	62,62,	
62,62,	62,62,	62,62,	62,62,	
62,62,	62,62,	62,62,	62,62,	
62,62,	62,62,	62,62,	62,62,	
62,62,	62,62,	62,62,	62,62,	
62,62,	62,62,	62,62,	342,0,	
370,0,	394,427,	173,246,	62,62,	
410,438,	62,62,	62,62,	62,62,	
62,62,	62,62,	62,62,	62,62,	
62,62,	62,62,	62,62,	62,62,	
62,62,	62,62,	62,62,	62,62,	
62,62,	62,62,	62,62,	62,62,	
62,62,	62,62,	62,62,	62,62,	
62,62,	62,62,	62,62,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,56,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	342,381,	66,0,	
66,0,	66,0,	66,62,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,62,	404,0,	
412,0,	413,0,	415,0,	419,442,	
421,443,	425,444,	426,445,	434,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,62,	
439,0,	441,0,	443,450,	444,451,	
66,66,	451,453,	453,454,	454,455,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	404,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	338,0,	434,0,	
0,0,	66,0,	66,0,	66,0,	
66,0,	340,0,	66,0,	76,62,	
76,62,	76,62,	76,62,	76,62,	
76,62,	76,62,	76,62,	76,62,	
76,62,	76,62,	76,62,	76,62,	
76,62,	76,62,	76,62,	76,62,	
76,62,	76,62,	76,62,	76,62,	
76,62,	76,62,	76,62,	76,62,	
76,62,	66,56,	66,0,	66,56,	
66,0,	66,0,	176,0,	76,62,	
76,62,	76,62,	76,62,	76,62,	
76,62,	76,62,	76,62,	76,62,	
76,62,	76,62,	76,62,	76,62,	
76,62,	76,62,	76,62,	76,62,	
76,62,	76,62,	76,62,	76,62,	
76,62,	76,62,	76,62,	76,62,	
76,62,	84,84,	98,183,	98,0,	
176,0,	176,0,	326,0,	338,378,	
176,0,	84,84,	84,0,	343,0,	
344,0,	329,0,	340,380,	0,0,	
0,0,	378,0,	99,99,	99,0,	
0,0,	0,0,	371,0,	176,0,	
0,0,	98,97,	0,0,	0,0,	
98,99,	327,0,	328,0,	367,0,	
176,250,	98,0,	98,0,	380,0,	
84,84,	98,0,	326,0,	369,0,	
84,0,	84,0,	84,84,	84,84,	
84,0,	329,0,	84,84,	101,101,	
84,84,	99,0,	99,0,	381,0,	
98,0,	99,0,	371,0,	101,101,	
101,0,	382,0,	128,128,	84,0,	
0,0,	327,0,	328,0,	367,0,	
383,0,	84,84,	128,128,	128,0,	
99,0,	326,369,	84,84,	369,0,	
414,0,	98,94,	99,184,	344,383,	
329,372,	0,0,	435,0,	99,184,	
416,416,	416,440,	101,101,	177,0,	
343,382,	371,406,	101,101,	0,0,	
101,0,	101,101,	101,101,	378,412,	
101,101,	128,128,	101,101,	327,370,	
328,371,	128,128,	140,140,	128,128,	
128,128,	128,128,	368,0,	128,128,	
367,403,	128,128,	140,140,	140,0,	
0,0,	380,413,	435,0,	101,101,	
369,405,	177,0,	177,0,	372,0,	
101,101,	177,0,	171,85,	171,0,	
0,0,	174,0,	128,128,	84,84,	
381,414,	84,84,	0,0,	128,128,	
0,0,	175,0,	416,441,	382,415,	
177,0,	140,140,	368,0,	0,0,	
0,0,	140,140,	383,416,	140,140,	
140,140,	140,140,	178,0,	140,140,	
0,0,	140,140,	414,439,	372,0,	
0,0,	171,0,	171,0,	174,0,	
174,0,	171,0,	174,247,	174,0,	
174,84,	177,251,	403,0,	175,0,	
175,0,	0,0,	140,140,	175,0,	
0,0,	0,0,	180,0,	140,140,	
171,0,	101,101,	174,0,	101,101,	
178,0,	178,0,	368,404,	0,0,	
178,0,	0,0,	175,0,	179,0,	
128,128,	0,0,	128,128,	0,0,	
405,0,	0,0,	0,0,	181,0,	
372,407,	171,94,	403,0,	178,0,	
175,248,	182,0,	437,0,	0,0,	
180,0,	180,0,	184,184,	406,0,	
180,0,	0,0,	407,0,	0,0,	
0,0,	178,252,	184,184,	184,0,	
0,0,	179,0,	179,0,	178,253,	
0,0,	179,0,	175,249,	180,0,	
405,0,	181,0,	181,0,	247,0,	
140,140,	181,0,	140,140,	182,0,	
182,0,	0,0,	437,0,	182,0,	
179,0,	183,97,	183,0,	406,0,	
403,434,	184,184,	407,0,	179,254,	
181,0,	436,0,	196,196,	184,184,	
184,184,	0,0,	182,0,	184,184,	
246,0,	184,184,	196,196,	196,0,	
0,0,	247,0,	247,0,	180,255,	
0,0,	247,0,	448,0,	183,99,	
182,257,	248,0,	405,435,	181,256,	
183,0,	183,0,	184,184,	0,0,	
183,0,	0,0,	0,0,	184,184,	
247,0,	436,0,	0,0,	0,0,	
406,436,	196,196,	246,0,	246,0,	
407,437,	196,196,	246,0,	183,0,	
196,196,	196,196,	0,0,	196,196,	
249,0,	196,196,	448,0,	248,0,	
248,0,	0,0,	0,0,	248,0,	
0,0,	246,0,	250,0,	247,312,	
251,0,	0,0,	0,0,	0,0,	
183,94,	0,0,	196,196,	0,0,	
0,0,	0,0,	248,0,	196,196,	
252,0,	0,0,	246,311,	436,448,	
0,0,	0,0,	249,0,	249,0,	
0,0,	253,0,	249,0,	0,0,	
184,184,	0,0,	184,184,	0,0,	
250,0,	250,0,	251,0,	251,0,	
250,0,	0,0,	251,0,	248,313,	
0,0,	249,0,	254,0,	0,0,	
0,0,	0,0,	252,0,	252,0,	
255,0,	0,0,	252,0,	250,0,	
0,0,	251,0,	256,0,	253,0,	
253,0,	0,0,	249,314,	253,0,	
0,0,	250,315,	0,0,	0,0,	
257,0,	252,0,	0,0,	0,0,	
196,196,	0,0,	196,196,	0,0,	
254,0,	254,0,	253,0,	0,0,	
254,0,	0,0,	255,0,	255,0,	
0,0,	311,0,	255,0,	0,0,	
256,0,	256,0,	0,0,	0,0,	
256,0,	251,316,	0,0,	254,0,	
252,317,	277,30,	257,0,	257,0,	
0,0,	255,0,	257,0,	253,318,	
0,0,	277,30,	277,0,	256,0,	
440,440,	440,440,	0,0,	0,0,	
254,319,	0,0,	0,0,	311,0,	
311,0,	257,0,	255,320,	311,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
256,321,	257,322,	0,0,	440,440,	
277,30,	0,0,	311,0,	0,0,	
277,30,	0,0,	277,30,	277,30,	
277,30,	0,0,	277,30,	0,0,	
277,30,	0,0,	0,0,	0,0,	
311,358,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	440,449,	0,0,	
0,0,	277,339,	277,30,	277,30,	
277,30,	277,30,	277,30,	277,30,	
277,30,	277,30,	277,30,	277,30,	
277,30,	277,30,	277,30,	277,30,	
277,30,	277,30,	277,30,	277,30,	
277,30,	277,30,	277,30,	277,30,	
277,30,	277,30,	277,30,	0,0,	
0,0,	0,0,	0,0,	0,0,	
313,0,	277,30,	277,30,	277,30,	
277,30,	277,30,	277,30,	277,30,	
277,30,	277,30,	277,30,	277,30,	
277,30,	277,30,	277,30,	277,30,	
277,30,	277,30,	277,30,	277,30,	
277,30,	277,30,	277,30,	277,30,	
277,30,	277,30,	277,30,	277,30,	
312,84,	277,30,	313,0,	313,0,	
0,0,	0,0,	313,0,	0,0,	
312,84,	312,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	313,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	312,84,	
0,0,	0,0,	0,0,	312,0,	
312,0,	312,84,	312,84,	312,0,	
0,0,	312,84,	0,0,	312,84,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	312,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
312,359,	312,84,	312,84,	312,84,	
312,84,	312,84,	312,84,	312,84,	
312,84,	312,84,	312,84,	312,84,	
312,84,	312,84,	312,84,	312,84,	
312,84,	312,84,	312,84,	312,84,	
312,84,	312,84,	312,84,	312,84,	
312,84,	312,84,	0,0,	0,0,	
0,0,	0,0,	0,0,	314,0,	
312,84,	312,84,	312,84,	312,84,	
312,84,	312,84,	312,84,	312,84,	
312,84,	312,84,	312,84,	312,84,	
312,84,	312,84,	312,84,	312,84,	
312,84,	312,84,	312,84,	312,84,	
312,84,	312,84,	312,84,	312,84,	
312,84,	312,84,	312,84,	315,0,	
312,84,	314,0,	314,0,	0,0,	
0,0,	314,0,	316,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
317,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
314,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	315,0,	315,0,	0,0,	
0,0,	315,0,	314,360,	0,0,	
316,0,	316,0,	0,0,	0,0,	
316,0,	0,0,	317,0,	317,0,	
0,0,	0,0,	317,0,	0,0,	
315,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	316,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	317,0,	0,0,	0,0,	
0,0,	315,361,	0,0,	317,363,	
317,84,	317,84,	317,84,	317,84,	
316,362,	317,84,	317,84,	317,84,	
317,84,	317,84,	317,84,	317,84,	
317,84,	317,84,	317,84,	317,84,	
317,84,	317,84,	317,84,	317,84,	
317,84,	317,84,	317,84,	317,84,	
317,84,	0,0,	0,0,	318,0,	
0,0,	319,0,	0,0,	317,84,	
317,84,	317,84,	317,84,	317,84,	
317,84,	317,84,	317,84,	317,84,	
317,84,	317,84,	317,84,	317,84,	
317,84,	317,84,	317,84,	317,84,	
317,84,	317,84,	317,84,	317,84,	
317,84,	317,84,	317,84,	317,84,	
317,84,	318,0,	318,0,	319,0,	
319,0,	318,0,	0,0,	319,0,	
320,0,	0,0,	321,0,	0,0,	
0,0,	0,0,	0,0,	322,0,	
0,0,	0,0,	0,0,	0,0,	
318,0,	0,0,	319,0,	0,0,	
358,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	318,364,	359,0,	
0,0,	0,0,	0,0,	0,0,	
319,365,	0,0,	320,0,	320,0,	
321,0,	321,0,	320,0,	324,101,	
321,0,	322,0,	322,0,	0,0,	
0,0,	322,0,	0,0,	324,101,	
324,0,	0,0,	358,0,	358,0,	
0,0,	320,0,	358,0,	321,0,	
0,0,	359,0,	359,0,	0,0,	
322,0,	359,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	320,366,	
0,0,	358,0,	0,0,	0,0,	
0,0,	0,0,	324,101,	0,0,	
359,0,	0,0,	324,101,	0,0,	
324,0,	324,101,	324,101,	0,0,	
324,101,	0,0,	324,101,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	358,395,	0,0,	0,0,	
0,0,	0,0,	0,0,	359,396,	
0,0,	0,0,	0,0,	324,368,	
324,101,	324,101,	324,101,	324,101,	
324,101,	324,101,	324,101,	324,101,	
324,101,	324,101,	324,101,	324,101,	
324,101,	324,101,	324,101,	324,101,	
324,101,	324,101,	324,101,	324,101,	
324,101,	324,101,	324,101,	324,101,	
324,101,	0,0,	0,0,	0,0,	
0,0,	0,0,	360,0,	324,101,	
324,101,	324,101,	324,101,	324,101,	
324,101,	324,101,	324,101,	324,101,	
324,101,	324,101,	324,101,	324,101,	
324,101,	324,101,	324,101,	324,101,	
324,101,	324,101,	324,101,	324,101,	
324,101,	324,101,	324,101,	324,101,	
324,101,	324,101,	361,0,	324,101,	
360,0,	360,0,	0,0,	362,0,	
360,0,	363,0,	0,0,	0,0,	
0,0,	0,0,	364,0,	0,0,	
0,0,	0,0,	0,0,	365,0,	
0,0,	0,0,	0,0,	360,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	366,0,	0,0,	
361,0,	361,0,	0,0,	395,0,	
361,0,	362,0,	362,0,	363,0,	
363,0,	362,0,	0,0,	363,0,	
364,0,	364,0,	0,0,	360,397,	
364,0,	365,0,	365,0,	361,0,	
0,0,	365,0,	0,0,	396,0,	
362,0,	397,0,	363,0,	0,0,	
366,0,	366,0,	398,0,	364,0,	
366,0,	395,0,	395,0,	399,0,	
365,0,	395,0,	362,398,	364,400,	
0,0,	0,0,	0,0,	0,0,	
365,401,	0,0,	0,0,	366,0,	
0,0,	0,0,	0,0,	363,399,	
395,0,	396,0,	396,0,	397,0,	
397,0,	396,0,	400,0,	397,0,	
398,0,	398,0,	0,0,	0,0,	
398,0,	399,0,	399,0,	401,0,	
0,0,	399,0,	0,0,	366,402,	
396,0,	0,0,	397,0,	402,0,	
0,0,	395,428,	0,0,	398,0,	
428,0,	0,0,	0,0,	0,0,	
399,0,	0,0,	0,0,	429,0,	
400,0,	400,0,	0,0,	0,0,	
400,0,	0,0,	399,431,	0,0,	
430,0,	401,0,	401,0,	397,429,	
0,0,	401,0,	0,0,	398,430,	
431,0,	402,0,	402,0,	400,0,	
0,0,	402,0,	428,0,	428,0,	
432,0,	0,0,	428,0,	0,0,	
401,0,	429,0,	429,0,	0,0,	
433,0,	429,0,	0,0,	0,0,	
402,0,	446,0,	430,0,	430,0,	
0,0,	428,0,	430,0,	0,0,	
400,432,	447,0,	431,0,	431,0,	
429,0,	0,0,	431,0,	0,0,	
0,0,	0,0,	432,0,	432,0,	
0,0,	430,0,	432,0,	452,0,	
0,0,	402,433,	433,0,	433,0,	
0,0,	431,0,	433,0,	446,0,	
446,0,	0,0,	0,0,	446,0,	
0,0,	432,0,	0,0,	447,0,	
447,0,	0,0,	0,0,	447,0,	
0,0,	433,0,	430,446,	432,447,	
0,0,	0,0,	446,0,	0,0,	
0,0,	452,0,	452,0,	0,0,	
0,0,	452,0,	447,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	447,452,	
0,0,	0,0,	0,0,	0,0,	
452,0,	0,0,	0,0,	0,0,	
0,0};
struct pp1svf pp1svec[] = {
0,	0,	0,
pp1crank+1,	0,		pp1vstop+1,
pp1crank+3,	pp1svec+1,	pp1vstop+7,
pp1crank+-50,	0,		pp1vstop+13,
pp1crank+-79,	pp1svec+3,	pp1vstop+19,
pp1crank+125,	0,		pp1vstop+25,
pp1crank+7,	pp1svec+5,	pp1vstop+31,
pp1crank+240,	0,		pp1vstop+37,
pp1crank+-365,	0,		pp1vstop+43,
pp1crank+-492,	0,		pp1vstop+49,
pp1crank+-619,	pp1svec+9,	pp1vstop+55,
pp1crank+-708,	0,		pp1vstop+61,
pp1crank+-658,	pp1svec+11,	pp1vstop+67,
pp1crank+-757,	pp1svec+3,	pp1vstop+73,
pp1crank+-841,	0,		pp1vstop+79,
pp1crank+0,	0,		pp1vstop+85,
pp1crank+0,	0,		pp1vstop+87,
pp1crank+1,	0,		0,	
pp1crank+1,	0,		0,	
pp1crank+2,	0,		0,	
pp1crank+1,	0,		0,	
pp1crank+1,	0,		0,	
pp1crank+2,	0,		0,	
pp1crank+2,	0,		0,	
pp1crank+5,	0,		0,	
pp1crank+12,	0,		0,	
pp1crank+5,	0,		0,	
pp1crank+6,	pp1svec+26,	0,	
pp1crank+870,	0,		0,	
pp1crank+1,	0,		pp1vstop+89,
pp1crank+-992,	0,		pp1vstop+91,
pp1crank+-7,	pp1svec+30,	pp1vstop+93,
pp1crank+-9,	pp1svec+30,	pp1vstop+96,
pp1crank+-10,	pp1svec+30,	pp1vstop+98,
pp1crank+-26,	pp1svec+30,	pp1vstop+100,
pp1crank+-11,	pp1svec+30,	pp1vstop+102,
pp1crank+-22,	pp1svec+30,	pp1vstop+104,
pp1crank+-24,	pp1svec+30,	pp1vstop+106,
pp1crank+-16,	pp1svec+30,	pp1vstop+108,
pp1crank+-18,	pp1svec+30,	pp1vstop+110,
pp1crank+-35,	pp1svec+30,	pp1vstop+112,
pp1crank+-95,	pp1svec+30,	pp1vstop+114,
pp1crank+-112,	pp1svec+30,	pp1vstop+116,
pp1crank+-54,	pp1svec+30,	pp1vstop+118,
pp1crank+-12,	pp1svec+30,	pp1vstop+120,
pp1crank+-60,	pp1svec+30,	pp1vstop+123,
pp1crank+0,	0,		pp1vstop+125,
pp1crank+1023,	0,		pp1vstop+127,
pp1crank+3,	pp1svec+47,	pp1vstop+129,
pp1crank+3,	pp1svec+47,	pp1vstop+131,
pp1crank+29,	pp1svec+47,	pp1vstop+133,
pp1crank+29,	pp1svec+47,	pp1vstop+135,
pp1crank+24,	pp1svec+47,	pp1vstop+137,
pp1crank+26,	pp1svec+47,	pp1vstop+139,
pp1crank+57,	pp1svec+47,	pp1vstop+141,
pp1crank+1081,	0,		0,	
pp1crank+146,	0,		pp1vstop+143,
pp1crank+0,	0,		pp1vstop+145,
pp1crank+14,	pp1svec+56,	pp1vstop+148,
pp1crank+0,	0,		pp1vstop+150,
pp1crank+205,	0,		0,	
pp1crank+0,	pp1svec+60,	pp1vstop+152,
pp1crank+1168,	0,		pp1vstop+154,
pp1crank+58,	pp1svec+62,	pp1vstop+156,
pp1crank+7,	pp1svec+62,	pp1vstop+158,
pp1crank+34,	pp1svec+62,	pp1vstop+160,
pp1crank+-1290,	0,		pp1vstop+162,
pp1crank+31,	pp1svec+62,	pp1vstop+165,
pp1crank+54,	pp1svec+62,	pp1vstop+167,
pp1crank+66,	pp1svec+62,	pp1vstop+169,
pp1crank+91,	pp1svec+62,	pp1vstop+171,
pp1crank+51,	pp1svec+62,	pp1vstop+173,
pp1crank+72,	pp1svec+62,	pp1vstop+175,
pp1crank+69,	pp1svec+62,	pp1vstop+177,
pp1crank+88,	pp1svec+62,	pp1vstop+179,
pp1crank+111,	pp1svec+62,	pp1vstop+181,
pp1crank+1322,	0,		0,	
pp1crank+152,	pp1svec+56,	pp1vstop+183,
pp1crank+242,	pp1svec+56,	pp1vstop+185,
pp1crank+0,	0,		pp1vstop+187,
pp1crank+77,	pp1svec+62,	pp1vstop+189,
pp1crank+97,	pp1svec+62,	pp1vstop+191,
pp1crank+67,	pp1svec+62,	pp1vstop+193,
pp1crank+96,	pp1svec+62,	pp1vstop+195,
pp1crank+-1444,	0,		pp1vstop+197,
pp1crank+-533,	pp1svec+84,	pp1vstop+199,
pp1crank+-423,	pp1svec+84,	pp1vstop+201,
pp1crank+-785,	pp1svec+84,	pp1vstop+204,
pp1crank+-538,	pp1svec+84,	pp1vstop+206,
pp1crank+-723,	pp1svec+84,	pp1vstop+208,
pp1crank+-550,	pp1svec+84,	pp1vstop+210,
pp1crank+-619,	pp1svec+84,	pp1vstop+212,
pp1crank+-739,	pp1svec+84,	pp1vstop+214,
pp1crank+-805,	pp1svec+84,	pp1vstop+216,
pp1crank+-827,	pp1svec+84,	pp1vstop+218,
pp1crank+-955,	pp1svec+84,	pp1vstop+220,
pp1crank+-851,	pp1svec+84,	pp1vstop+222,
pp1crank+-1002,	pp1svec+84,	pp1vstop+224,
pp1crank+-1437,	pp1svec+84,	pp1vstop+226,
pp1crank+-1453,	pp1svec+84,	pp1vstop+228,
pp1crank+-1007,	pp1svec+84,	pp1vstop+230,
pp1crank+-1490,	0,		pp1vstop+233,
pp1crank+-144,	pp1svec+101,	pp1vstop+235,
pp1crank+-408,	pp1svec+101,	pp1vstop+238,
pp1crank+121,	0,		pp1vstop+240,
pp1crank+-175,	pp1svec+101,	pp1vstop+242,
pp1crank+-258,	pp1svec+101,	pp1vstop+244,
pp1crank+-291,	pp1svec+101,	pp1vstop+246,
pp1crank+-652,	pp1svec+101,	pp1vstop+248,
pp1crank+-404,	pp1svec+101,	pp1vstop+250,
pp1crank+-179,	pp1svec+101,	pp1vstop+252,
pp1crank+-322,	pp1svec+101,	pp1vstop+254,
pp1crank+-719,	pp1svec+101,	pp1vstop+256,
pp1crank+-410,	pp1svec+101,	pp1vstop+258,
pp1crank+-444,	pp1svec+101,	pp1vstop+260,
pp1crank+-999,	pp1svec+101,	pp1vstop+262,
pp1crank+-256,	pp1svec+101,	pp1vstop+264,
pp1crank+0,	0,		pp1vstop+267,
pp1crank+0,	0,		pp1vstop+269,
pp1crank+74,	0,		0,	
pp1crank+140,	0,		0,	
pp1crank+209,	0,		0,	
pp1crank+120,	0,		0,	
pp1crank+134,	0,		0,	
pp1crank+124,	0,		0,	
pp1crank+181,	0,		0,	
pp1crank+192,	0,		0,	
pp1crank+0,	pp1svec+26,	pp1vstop+271,
pp1crank+-1501,	0,		pp1vstop+273,
pp1crank+-257,	pp1svec+30,	pp1vstop+275,
pp1crank+-260,	pp1svec+30,	pp1vstop+278,
pp1crank+-452,	pp1svec+30,	pp1vstop+281,
pp1crank+-427,	pp1svec+30,	pp1vstop+283,
pp1crank+-468,	pp1svec+30,	pp1vstop+285,
pp1crank+-400,	pp1svec+30,	pp1vstop+287,
pp1crank+-461,	pp1svec+30,	pp1vstop+289,
pp1crank+-456,	pp1svec+30,	pp1vstop+291,
pp1crank+-405,	pp1svec+30,	pp1vstop+293,
pp1crank+-411,	pp1svec+30,	pp1vstop+295,
pp1crank+-665,	pp1svec+30,	pp1vstop+297,
pp1crank+-1541,	0,		pp1vstop+300,
pp1crank+-406,	pp1svec+30,	pp1vstop+303,
pp1crank+178,	pp1svec+47,	pp1vstop+305,
pp1crank+370,	pp1svec+47,	pp1vstop+307,
pp1crank+207,	pp1svec+47,	pp1vstop+309,
pp1crank+192,	pp1svec+47,	pp1vstop+311,
pp1crank+183,	pp1svec+47,	pp1vstop+313,
pp1crank+197,	pp1svec+47,	pp1vstop+315,
pp1crank+213,	pp1svec+47,	pp1vstop+317,
pp1crank+0,	pp1svec+56,	pp1vstop+319,
pp1crank+466,	pp1svec+62,	pp1vstop+322,
pp1crank+220,	pp1svec+62,	pp1vstop+324,
pp1crank+354,	pp1svec+62,	pp1vstop+326,
pp1crank+344,	pp1svec+62,	pp1vstop+328,
pp1crank+382,	pp1svec+62,	pp1vstop+330,
pp1crank+355,	pp1svec+62,	pp1vstop+332,
pp1crank+403,	pp1svec+62,	pp1vstop+334,
pp1crank+396,	pp1svec+62,	pp1vstop+336,
pp1crank+407,	pp1svec+62,	pp1vstop+338,
pp1crank+414,	pp1svec+62,	pp1vstop+340,
pp1crank+397,	pp1svec+62,	pp1vstop+342,
pp1crank+414,	pp1svec+62,	pp1vstop+344,
pp1crank+462,	pp1svec+62,	pp1vstop+346,
pp1crank+449,	pp1svec+62,	pp1vstop+348,
pp1crank+464,	pp1svec+62,	pp1vstop+350,
pp1crank+476,	pp1svec+62,	pp1vstop+352,
pp1crank+479,	pp1svec+62,	pp1vstop+354,
pp1crank+484,	pp1svec+62,	pp1vstop+356,
pp1crank+572,	pp1svec+56,	pp1vstop+358,
pp1crank+485,	pp1svec+62,	pp1vstop+361,
pp1crank+497,	pp1svec+62,	pp1vstop+363,
pp1crank+-1553,	pp1svec+84,	pp1vstop+365,
pp1crank+-856,	pp1svec+84,	pp1vstop+368,
pp1crank+-1167,	pp1svec+84,	pp1vstop+371,
pp1crank+-1555,	pp1svec+84,	pp1vstop+373,
pp1crank+-1563,	pp1svec+84,	pp1vstop+375,
pp1crank+-1408,	pp1svec+84,	pp1vstop+377,
pp1crank+-1517,	pp1svec+84,	pp1vstop+379,
pp1crank+-1576,	pp1svec+84,	pp1vstop+381,
pp1crank+-1613,	pp1svec+84,	pp1vstop+383,
pp1crank+-1600,	pp1svec+84,	pp1vstop+385,
pp1crank+-1621,	pp1svec+84,	pp1vstop+387,
pp1crank+-1627,	pp1svec+84,	pp1vstop+389,
pp1crank+-1664,	pp1svec+84,	pp1vstop+391,
pp1crank+-1641,	pp1svec+128,	pp1vstop+394,
pp1crank+-659,	pp1svec+101,	pp1vstop+397,
pp1crank+0,	0,		pp1vstop+400,
pp1crank+-677,	pp1svec+101,	pp1vstop+402,
pp1crank+-717,	pp1svec+101,	pp1vstop+404,
pp1crank+-711,	pp1svec+101,	pp1vstop+406,
pp1crank+-697,	pp1svec+101,	pp1vstop+408,
pp1crank+-726,	pp1svec+101,	pp1vstop+410,
pp1crank+-681,	pp1svec+101,	pp1vstop+412,
pp1crank+-921,	pp1svec+101,	pp1vstop+414,
pp1crank+-674,	pp1svec+101,	pp1vstop+416,
pp1crank+-884,	pp1svec+101,	pp1vstop+418,
pp1crank+-1681,	pp1svec+128,	pp1vstop+421,
pp1crank+496,	0,		0,	
pp1crank+503,	0,		0,	
pp1crank+512,	0,		0,	
pp1crank+522,	0,		0,	
pp1crank+530,	0,		0,	
pp1crank+505,	0,		0,	
pp1crank+525,	0,		0,	
pp1crank+522,	0,		0,	
pp1crank+532,	0,		0,	
pp1crank+-595,	pp1svec+30,	pp1vstop+424,
pp1crank+-602,	pp1svec+30,	pp1vstop+426,
pp1crank+-776,	pp1svec+30,	pp1vstop+428,
pp1crank+-596,	pp1svec+30,	pp1vstop+430,
pp1crank+-604,	pp1svec+30,	pp1vstop+432,
pp1crank+-712,	pp1svec+30,	pp1vstop+434,
pp1crank+-600,	pp1svec+30,	pp1vstop+436,
pp1crank+-767,	pp1svec+30,	pp1vstop+438,
pp1crank+-761,	pp1svec+30,	pp1vstop+440,
pp1crank+-747,	pp1svec+30,	pp1vstop+442,
pp1crank+532,	pp1svec+47,	pp1vstop+444,
pp1crank+527,	pp1svec+47,	pp1vstop+446,
pp1crank+588,	pp1svec+47,	pp1vstop+448,
pp1crank+599,	pp1svec+47,	pp1vstop+450,
pp1crank+594,	pp1svec+47,	pp1vstop+452,
pp1crank+623,	pp1svec+47,	pp1vstop+454,
pp1crank+626,	pp1svec+47,	pp1vstop+456,
pp1crank+637,	pp1svec+47,	pp1vstop+458,
pp1crank+657,	pp1svec+62,	pp1vstop+460,
pp1crank+652,	pp1svec+62,	pp1vstop+462,
pp1crank+0,	pp1svec+62,	pp1vstop+464,
pp1crank+656,	pp1svec+62,	pp1vstop+467,
pp1crank+0,	pp1svec+62,	pp1vstop+469,
pp1crank+686,	pp1svec+62,	pp1vstop+472,
pp1crank+732,	pp1svec+62,	pp1vstop+474,
pp1crank+725,	pp1svec+62,	pp1vstop+476,
pp1crank+763,	pp1svec+62,	pp1vstop+478,
pp1crank+0,	pp1svec+62,	pp1vstop+480,
pp1crank+743,	pp1svec+62,	pp1vstop+483,
pp1crank+765,	pp1svec+62,	pp1vstop+485,
pp1crank+719,	pp1svec+62,	pp1vstop+487,
pp1crank+0,	pp1svec+62,	pp1vstop+489,
pp1crank+0,	pp1svec+62,	pp1vstop+492,
pp1crank+740,	pp1svec+62,	pp1vstop+495,
pp1crank+739,	pp1svec+62,	pp1vstop+497,
pp1crank+750,	pp1svec+62,	pp1vstop+499,
pp1crank+745,	pp1svec+62,	pp1vstop+501,
pp1crank+755,	pp1svec+62,	pp1vstop+503,
pp1crank+758,	pp1svec+62,	pp1vstop+505,
pp1crank+768,	pp1svec+62,	pp1vstop+507,
pp1crank+-1678,	pp1svec+84,	pp1vstop+509,
pp1crank+-1653,	pp1svec+84,	pp1vstop+511,
pp1crank+-1691,	pp1svec+84,	pp1vstop+513,
pp1crank+-1718,	pp1svec+84,	pp1vstop+515,
pp1crank+-1728,	pp1svec+84,	pp1vstop+517,
pp1crank+-1730,	pp1svec+84,	pp1vstop+519,
pp1crank+-1742,	pp1svec+84,	pp1vstop+521,
pp1crank+-1751,	pp1svec+84,	pp1vstop+523,
pp1crank+-1768,	pp1svec+84,	pp1vstop+525,
pp1crank+-1774,	pp1svec+84,	pp1vstop+527,
pp1crank+-1780,	pp1svec+84,	pp1vstop+529,
pp1crank+-1790,	pp1svec+84,	pp1vstop+531,
pp1crank+-984,	pp1svec+101,	pp1vstop+533,
pp1crank+-919,	pp1svec+101,	pp1vstop+535,
pp1crank+-833,	pp1svec+101,	pp1vstop+537,
pp1crank+-987,	pp1svec+101,	pp1vstop+539,
pp1crank+-859,	pp1svec+101,	pp1vstop+541,
pp1crank+-920,	pp1svec+101,	pp1vstop+543,
pp1crank+-1008,	pp1svec+101,	pp1vstop+545,
pp1crank+-988,	pp1svec+101,	pp1vstop+547,
pp1crank+-862,	pp1svec+101,	pp1vstop+549,
pp1crank+775,	0,		0,	
pp1crank+787,	0,		0,	
pp1crank+0,	0,		pp1vstop+551,
pp1crank+781,	0,		0,	
pp1crank+779,	0,		0,	
pp1crank+780,	0,		0,	
pp1crank+784,	0,		0,	
pp1crank+0,	0,		pp1vstop+553,
pp1crank+0,	0,		pp1vstop+555,
pp1crank+-848,	pp1svec+30,	pp1vstop+557,
pp1crank+-1828,	0,		pp1vstop+559,
pp1crank+-849,	pp1svec+30,	pp1vstop+561,
pp1crank+-994,	pp1svec+30,	pp1vstop+564,
pp1crank+-1009,	pp1svec+30,	pp1vstop+566,
pp1crank+-1010,	pp1svec+30,	pp1vstop+568,
pp1crank+-997,	pp1svec+30,	pp1vstop+570,
pp1crank+-852,	pp1svec+30,	pp1vstop+572,
pp1crank+-853,	pp1svec+30,	pp1vstop+575,
pp1crank+-922,	pp1svec+30,	pp1vstop+578,
pp1crank+797,	pp1svec+47,	pp1vstop+580,
pp1crank+0,	pp1svec+47,	pp1vstop+582,
pp1crank+801,	pp1svec+47,	pp1vstop+585,
pp1crank+802,	pp1svec+47,	pp1vstop+587,
pp1crank+822,	pp1svec+47,	pp1vstop+589,
pp1crank+826,	pp1svec+47,	pp1vstop+591,
pp1crank+0,	pp1svec+47,	pp1vstop+593,
pp1crank+0,	pp1svec+47,	pp1vstop+596,
pp1crank+825,	pp1svec+62,	pp1vstop+599,
pp1crank+832,	pp1svec+62,	pp1vstop+601,
pp1crank+840,	pp1svec+62,	pp1vstop+603,
pp1crank+0,	pp1svec+62,	pp1vstop+605,
pp1crank+843,	pp1svec+62,	pp1vstop+608,
pp1crank+847,	pp1svec+62,	pp1vstop+610,
pp1crank+0,	pp1svec+62,	pp1vstop+612,
pp1crank+851,	pp1svec+62,	pp1vstop+615,
pp1crank+0,	pp1svec+62,	pp1vstop+617,
pp1crank+930,	pp1svec+62,	pp1vstop+620,
pp1crank+937,	pp1svec+62,	pp1vstop+622,
pp1crank+0,	pp1svec+62,	pp1vstop+624,
pp1crank+0,	pp1svec+62,	pp1vstop+628,
pp1crank+0,	pp1svec+62,	pp1vstop+632,
pp1crank+0,	pp1svec+62,	pp1vstop+635,
pp1crank+0,	pp1svec+62,	pp1vstop+638,
pp1crank+0,	pp1svec+62,	pp1vstop+641,
pp1crank+-1807,	pp1svec+84,	pp1vstop+644,
pp1crank+-1951,	0,		pp1vstop+646,
pp1crank+-1914,	pp1svec+84,	pp1vstop+648,
pp1crank+-2037,	pp1svec+84,	pp1vstop+651,
pp1crank+-2065,	pp1svec+84,	pp1vstop+653,
pp1crank+-2072,	pp1svec+84,	pp1vstop+655,
pp1crank+-2078,	pp1svec+312,	pp1vstop+657,
pp1crank+-2161,	pp1svec+84,	pp1vstop+659,
pp1crank+-2163,	pp1svec+84,	pp1vstop+661,
pp1crank+-2198,	pp1svec+84,	pp1vstop+663,
pp1crank+-2200,	pp1svec+84,	pp1vstop+665,
pp1crank+-2205,	pp1svec+84,	pp1vstop+668,
pp1crank+-1014,	pp1svec+101,	pp1vstop+671,
pp1crank+-2242,	0,		pp1vstop+673,
pp1crank+-1003,	pp1svec+101,	pp1vstop+675,
pp1crank+-1440,	pp1svec+101,	pp1vstop+678,
pp1crank+-1463,	pp1svec+101,	pp1vstop+680,
pp1crank+-1464,	pp1svec+101,	pp1vstop+682,
pp1crank+-1447,	pp1svec+101,	pp1vstop+684,
pp1crank+-1012,	pp1svec+101,	pp1vstop+686,
pp1crank+-1013,	pp1svec+101,	pp1vstop+689,
pp1crank+933,	0,		0,	
pp1crank+939,	0,		0,	
pp1crank+942,	0,		0,	
pp1crank+0,	0,		pp1vstop+692,
pp1crank+954,	0,		0,	
pp1crank+948,	0,		0,	
pp1crank+-1368,	pp1svec+30,	pp1vstop+694,
pp1crank+-1034,	pp1svec+30,	pp1vstop+696,
pp1crank+-1375,	pp1svec+30,	pp1vstop+698,
pp1crank+-1023,	pp1svec+30,	pp1vstop+700,
pp1crank+-1249,	pp1svec+30,	pp1vstop+703,
pp1crank+-1445,	pp1svec+30,	pp1vstop+705,
pp1crank+-1446,	pp1svec+30,	pp1vstop+707,
pp1crank+966,	pp1svec+47,	pp1vstop+709,
pp1crank+969,	pp1svec+47,	pp1vstop+711,
pp1crank+0,	pp1svec+47,	pp1vstop+713,
pp1crank+985,	pp1svec+47,	pp1vstop+716,
pp1crank+982,	pp1svec+47,	pp1vstop+718,
pp1crank+1013,	pp1svec+62,	pp1vstop+720,
pp1crank+1000,	pp1svec+62,	pp1vstop+722,
pp1crank+1031,	pp1svec+62,	pp1vstop+724,
pp1crank+1036,	pp1svec+62,	pp1vstop+726,
pp1crank+1103,	pp1svec+62,	pp1vstop+728,
pp1crank+0,	pp1svec+62,	pp1vstop+730,
pp1crank+1100,	pp1svec+62,	pp1vstop+733,
pp1crank+1091,	pp1svec+62,	pp1vstop+735,
pp1crank+-2214,	pp1svec+84,	pp1vstop+737,
pp1crank+-2221,	pp1svec+84,	pp1vstop+739,
pp1crank+-2328,	pp1svec+84,	pp1vstop+741,
pp1crank+-2356,	pp1svec+84,	pp1vstop+743,
pp1crank+-2361,	pp1svec+84,	pp1vstop+746,
pp1crank+-2363,	pp1svec+84,	pp1vstop+748,
pp1crank+-2368,	pp1svec+84,	pp1vstop+750,
pp1crank+-2373,	pp1svec+84,	pp1vstop+752,
pp1crank+-2384,	pp1svec+84,	pp1vstop+754,
pp1crank+-1465,	pp1svec+101,	pp1vstop+756,
pp1crank+-1536,	pp1svec+101,	pp1vstop+758,
pp1crank+-1473,	pp1svec+101,	pp1vstop+760,
pp1crank+-1218,	pp1svec+101,	pp1vstop+762,
pp1crank+-1456,	pp1svec+101,	pp1vstop+765,
pp1crank+-1549,	pp1svec+101,	pp1vstop+767,
pp1crank+1091,	0,		0,	
pp1crank+0,	0,		pp1vstop+769,
pp1crank+1092,	0,		0,	
pp1crank+1122,	0,		0,	
pp1crank+1122,	0,		0,	
pp1crank+-1451,	pp1svec+30,	pp1vstop+771,
pp1crank+-1199,	pp1svec+30,	pp1vstop+773,
pp1crank+-1469,	pp1svec+30,	pp1vstop+776,
pp1crank+-1485,	pp1svec+30,	pp1vstop+778,
pp1crank+-1491,	pp1svec+30,	pp1vstop+780,
pp1crank+-1498,	pp1svec+30,	pp1vstop+782,
pp1crank+1126,	pp1svec+47,	pp1vstop+784,
pp1crank+1128,	pp1svec+47,	pp1vstop+786,
pp1crank+1130,	pp1svec+47,	pp1vstop+788,
pp1crank+1130,	pp1svec+47,	pp1vstop+790,
pp1crank+1142,	pp1svec+62,	pp1vstop+792,
pp1crank+1143,	pp1svec+62,	pp1vstop+794,
pp1crank+1145,	pp1svec+62,	pp1vstop+796,
pp1crank+1146,	pp1svec+62,	pp1vstop+798,
pp1crank+1162,	pp1svec+62,	pp1vstop+800,
pp1crank+1149,	pp1svec+62,	pp1vstop+802,
pp1crank+1177,	pp1svec+62,	pp1vstop+804,
pp1crank+-2389,	pp1svec+84,	pp1vstop+806,
pp1crank+-2409,	pp1svec+84,	pp1vstop+808,
pp1crank+-2411,	pp1svec+84,	pp1vstop+811,
pp1crank+-2416,	pp1svec+84,	pp1vstop+813,
pp1crank+-2421,	pp1svec+84,	pp1vstop+815,
pp1crank+-2444,	pp1svec+84,	pp1vstop+817,
pp1crank+-2453,	pp1svec+84,	pp1vstop+819,
pp1crank+-2461,	pp1svec+84,	pp1vstop+822,
pp1crank+-1592,	pp1svec+101,	pp1vstop+824,
pp1crank+-1329,	pp1svec+101,	pp1vstop+826,
pp1crank+-1618,	pp1svec+101,	pp1vstop+829,
pp1crank+-1633,	pp1svec+101,	pp1vstop+831,
pp1crank+-1636,	pp1svec+101,	pp1vstop+833,
pp1crank+0,	0,		pp1vstop+835,
pp1crank+0,	0,		pp1vstop+837,
pp1crank+1180,	0,		0,	
pp1crank+0,	0,		pp1vstop+839,
pp1crank+-1330,	pp1svec+30,	pp1vstop+841,
pp1crank+-1331,	pp1svec+30,	pp1vstop+844,
pp1crank+-1506,	pp1svec+30,	pp1vstop+847,
pp1crank+-1332,	pp1svec+30,	pp1vstop+849,
pp1crank+-1515,	pp1svec+30,	pp1vstop+852,
pp1crank+0,	pp1svec+47,	pp1vstop+855,
pp1crank+0,	pp1svec+47,	pp1vstop+858,
pp1crank+1259,	pp1svec+47,	pp1vstop+861,
pp1crank+0,	pp1svec+47,	pp1vstop+863,
pp1crank+1279,	pp1svec+62,	pp1vstop+866,
pp1crank+0,	pp1svec+62,	pp1vstop+868,
pp1crank+0,	pp1svec+62,	pp1vstop+871,
pp1crank+0,	pp1svec+62,	pp1vstop+874,
pp1crank+1267,	pp1svec+62,	pp1vstop+877,
pp1crank+1262,	pp1svec+62,	pp1vstop+879,
pp1crank+0,	pp1svec+62,	pp1vstop+881,
pp1crank+-2466,	pp1svec+84,	pp1vstop+884,
pp1crank+-2473,	pp1svec+84,	pp1vstop+887,
pp1crank+-2482,	pp1svec+84,	pp1vstop+890,
pp1crank+-2490,	pp1svec+84,	pp1vstop+892,
pp1crank+-2498,	pp1svec+84,	pp1vstop+895,
pp1crank+-2506,	pp1svec+84,	pp1vstop+897,
pp1crank+-1337,	pp1svec+101,	pp1vstop+900,
pp1crank+-1512,	pp1svec+101,	pp1vstop+903,
pp1crank+-1671,	pp1svec+101,	pp1vstop+906,
pp1crank+-1628,	pp1svec+101,	pp1vstop+908,
pp1crank+0,	0,		pp1vstop+911,
pp1crank+-1346,	pp1svec+30,	pp1vstop+913,
pp1crank+1831,	0,		pp1vstop+916,
pp1crank+-1347,	pp1svec+30,	pp1vstop+918,
pp1crank+0,	pp1svec+47,	pp1vstop+921,
pp1crank+1280,	pp1svec+62,	pp1vstop+924,
pp1crank+1291,	pp1svec+62,	pp1vstop+926,
pp1crank+0,	pp1svec+62,	pp1vstop+928,
pp1crank+-2511,	pp1svec+84,	pp1vstop+931,
pp1crank+-2519,	pp1svec+84,	pp1vstop+934,
pp1crank+-1688,	pp1svec+101,	pp1vstop+936,
pp1crank+0,	0,		pp1vstop+939,
pp1crank+0,	pp1svec+62,	pp1vstop+941,
pp1crank+1288,	pp1svec+62,	pp1vstop+944,
pp1crank+-2533,	pp1svec+84,	pp1vstop+946,
pp1crank+1297,	pp1svec+62,	pp1vstop+949,
pp1crank+1285,	pp1svec+62,	pp1vstop+951,
pp1crank+0,	pp1svec+62,	pp1vstop+953,
0,	0,	0};
struct pp1work *pp1top = pp1crank+2592;
struct pp1svf *pp1bgin = pp1svec+1;
char pp1match[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,01  ,01  ,'$' ,01  ,01  ,01  ,
'(' ,'(' ,'*' ,'+' ,',' ,'+' ,'.' ,01  ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,01  ,',' ,01  ,01  ,01  ,01  ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'F' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,01  ,01  ,01  ,'$' ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'{' ,01  ,'}' ,01  ,01  ,
0};
char pp1extra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int pp1lineno =1;
# define PP1U(x) x
# define NLSTATE pp1previous=PP1NEWLINE
char pp1text[PP1LMAX];
struct pp1svf *pp1lstate [PP1LMAX], **pp1lsp, **pp1olsp;
char pp1sbuf[PP1LMAX];
char *pp1sptr = pp1sbuf;
int *pp1fnd;
extern struct pp1svf *pp1estate;
int pp1previous = PP1NEWLINE;
pp1look(){
	register struct pp1svf *pp1state, **lsp;
	register struct pp1work *pp1t;
	struct pp1svf *pp1z;
	int pp1ch, pp1first;
	struct pp1work *pp1r;
# ifdef LEXDEBUG
	int debug;
# endif
	char *pp1lastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	pp1first=1;
	if (!pp1morfg)
		pp1lastch = pp1text;
	else {
		pp1morfg=0;
		pp1lastch = pp1text+pp1leng;
		}
	for(;;){
		lsp = pp1lstate;
		pp1estate = pp1state = pp1bgin;
		if (pp1previous==PP1NEWLINE) pp1state++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(pp1out,"state %d\n",pp1state-pp1svec-1);
# endif
			pp1t = pp1state->pp1stoff;
			if(pp1t == pp1crank && !pp1first){  /* may not be any transitions */
				pp1z = pp1state->pp1other;
				if(pp1z == 0)break;
				if(pp1z->pp1stoff == pp1crank)break;
				}
			*pp1lastch++ = pp1ch = input();
			pp1first=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(pp1out,"char ");
				allprint(pp1ch);
				putchar('\n');
				}
# endif
			pp1r = pp1t;
			if ( (int)pp1t > (int)pp1crank){
				pp1t = pp1r + pp1ch;
				if (pp1t <= pp1top && pp1t->verify+pp1svec == pp1state){
					if(pp1t->advance+pp1svec == PP1LERR)	/* error transitions */
						{unput(*--pp1lastch);break;}
					*lsp++ = pp1state = pp1t->advance+pp1svec;
					goto contin;
					}
				}
# ifdef PP1OPTIM
			else if((int)pp1t < (int)pp1crank) {		/* r < pp1crank */
				pp1t = pp1r = pp1crank+(pp1crank-pp1t);
# ifdef LEXDEBUG
				if(debug)fprintf(pp1out,"compressed state\n");
# endif
				pp1t = pp1t + pp1ch;
				if(pp1t <= pp1top && pp1t->verify+pp1svec == pp1state){
					if(pp1t->advance+pp1svec == PP1LERR)	/* error transitions */
						{unput(*--pp1lastch);break;}
					*lsp++ = pp1state = pp1t->advance+pp1svec;
					goto contin;
					}
				pp1t = pp1r + PP1U(pp1match[pp1ch]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(pp1out,"try fall back character ");
					allprint(PP1U(pp1match[pp1ch]));
					putchar('\n');
					}
# endif
				if(pp1t <= pp1top && pp1t->verify+pp1svec == pp1state){
					if(pp1t->advance+pp1svec == PP1LERR)	/* error transition */
						{unput(*--pp1lastch);break;}
					*lsp++ = pp1state = pp1t->advance+pp1svec;
					goto contin;
					}
				}
			if ((pp1state = pp1state->pp1other) && (pp1t= pp1state->pp1stoff) != pp1crank){
# ifdef LEXDEBUG
				if(debug)fprintf(pp1out,"fall back to state %d\n",pp1state-pp1svec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--pp1lastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(pp1out,"state %d char ",pp1state-pp1svec-1);
				allprint(pp1ch);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(pp1out,"stopped at %d with ",*(lsp-1)-pp1svec-1);
			allprint(pp1ch);
			putchar('\n');
			}
# endif
		while (lsp-- > pp1lstate){
			*pp1lastch-- = 0;
			if (*lsp != 0 && (pp1fnd= (*lsp)->pp1stops) && *pp1fnd > 0){
				pp1olsp = lsp;
				if(pp1extra[*pp1fnd]){		/* must backup */
					while(pp1back((*lsp)->pp1stops,-*pp1fnd) != 1 && lsp > pp1lstate){
						lsp--;
						unput(*pp1lastch--);
						}
					}
				pp1previous = PP1U(*pp1lastch);
				pp1lsp = lsp;
				pp1leng = pp1lastch-pp1text+1;
				pp1text[pp1leng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(pp1out,"\nmatch ");
					sprint(pp1text);
					fprintf(pp1out," action %d\n",*pp1fnd);
					}
# endif
				return(*pp1fnd++);
				}
			unput(*pp1lastch);
			}
		if (pp1text[0] == 0  /* && feof(pp1in) */)
			{
			pp1sptr=pp1sbuf;
			return(0);
			}
		pp1previous = pp1text[0] = input();
		if (pp1previous>0)
			output(pp1previous);
		pp1lastch=pp1text;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
pp1back(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
pp1input(){
	return(input());
	}
pp1output(c)
  int c; {
	output(c);
	}
pp1unput(c)
   int c; {
	unput(c);
	}
