/**************************************************************************
 * Version identification:
 * @(#)main.c	2.6	7/16/92
 *
 *  Copyright (c) 1990,1991 The Regents of the University of California.
 *                        All Rights Reserved.
 *
 *  Programmer:  Anders Wass
 *  Date of creation: 11/02/91
 *  Modification:  03/06/91 -- S Lee,  to recognize .chdl files as well.
 *		   04/25/91 -- A Wass, to check env. PEPPCPP.
 *		   04/29/91 -- A Wass, introduced the strings ClassName,
 *				       ModelName
 *		   05/14/91 -- A Wass, version upgrade due to capability
 *				       to generate descriptor from first
 *				       comment in model file, plus minor
 *				       changes the created C++ code.
 *
 *  Description:
 *
 * This program translates Thor C-model file (unpreprocessed) to C++ pThor
 * model files. The translation is done in two passes. The first pass
 * reorginaze the incomming C-Thor code to C++-pThor code. The second pass
 * does the macro expansions (a[], a[] =, a[n:m], a[n:m] =) to the calls of
 * functions fpack/funpck. The second pass can optional be omitted.
 *
 *	-- Anders Wass  1990/11/02
 *
 ****************************************************************************/


static char identification[] = "@(#)main.c (pepp)\t2.6\t7/16/92  (c) UC Berkeley";

char *version = "version 2.6";


#ifndef NOCOMPINFO
extern char comp_info[];
#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <signal.h>
#include "comdefs.h"

#ifndef size_t
#define size_t int
#endif

extern int errno, sys_nerr;
extern char *sys_errlist[], *getenv();

char lsbuf_[BUFSIZ];		/* working char buffer */

/* These pointers to files and their names are made global  */
/* within this file because it's more convenient when using */
/* a clean-up/exit function as done in this small program.  */

static char *tmpfname=NULL, *ofnamep1=NULL, *tmpin=NULL;
static FILE *tmpfp=NULL, *ofpp1=NULL, *tmpinfp=NULL;

/* Global flags for verbose mode and debug mode. */
int verbflg=0, debug=0;

/* The help and usage message ... */

static char *helpstrs[] = {
    "[-vcmrn] [-d[#]] [-l[name]] [-model|-monitor|-generator]\n\t\t[-o file|-s] [file]",
    "  -v:\tturn on verbose mode.",
    "  -c:\trun model data thru the cpp first.",
    "  -m:\tdon't expand vector macros.",
    "  -r:\tinsert line/file references to model file that is parsed.",
    "  -n:\tdon't insert C++ comments. (Line refs overridden by -r).",
    "  -d[#]:\n\tturn on(off) debug mode. # is an optional integer in range 0-9.",
    "\tDefault is no debug (=-d0). -d (=-d1) gives very vebose",
    "\tinformation. (It alos turns on options `-vl'). -d2 does the same",
    "\texcept it prevents unlinking of files created by the program.",
    "\t-d3 will print messages from the vector macro expander.",
    "  -l[name]:\n\twrite messages to a logfile also. If name is specifyed,",
    "\tthat will be the logfile name. Default is pepp.log.",
    "\tNo whitespace is allowed between -l and the name.",
    "  -model:\n\tgenerated pThor star should respond as a model.",
    "  -monitor:\n\tgenerated pThor star should respond as a monitor.",
    "  -generator:\n\tgenerated pThor star should respond as a generator.",
    "\n\tThe three options above can't be combined. They should only be used",
    "\twhen the program fails to determine the correct model type.\n",
    "  -o file:\n\twrite final output to file `file'.",
    "  -s:\twrite final output to standard out. This option overrides `-o'.",
    "  file: take input from `file'. If not specifyed, read standard in.",
    NULL
    };

extern char *Cppcmd;		/* found in cc-strings.c. This is the
				   optional C++-preprocessor command.
				   Used if not user specified from PEPPCPP. */

void sorti(rval)		/* The cleaning up and exit function. */
    int rval;
{
    if (debug==1)
	dbgmsg(__FILE__, __LINE__, "Closing open files ...\n\n");
    if (tmpinfp && debug<2) {
	fclose(tmpinfp);
	unlink(tmpin);
    }
    if (tmpfp && debug<2) {
	fclose(tmpfp);
	unlink(tmpfname);
    }
    if (ofpp1 && debug<2) {
	fclose(ofpp1);
	unlink(ofnamep1);
    }
    exit(rval);
}

int sig_sorti(sig)		/* function to execute when a soft   */
{				/* signal (1,2, or 3) is caught due  */
    switch (sig) {		/* to some error in one of the other */
    case 1:			/* modules. (pass1 or pass2.)	     */
	sorti(-1);
	break;
    case  2:
	sorti(-2);
	break;
    case 3:
    default:
	sorti(-3);
	break;
    }
    return EOF;
}

int cpF2toF1(fp1,fp2)		/* function to copy the contents */
    FILE *fp1, *fp2;		/* of file fp2 into file fp1.	 */
{
    int c, count;
    size_t csize = sizeof(char);
    errno=0;
    if (debug)
	dbgmsg(__FILE__, __LINE__, "Copying from filedes %d to filedes %d.\n",
	       fileno(fp2), fileno(fp1));

    for (c=getc(fp2); c != EOF && putc(c,fp1) != EOF; c=getc(fp2));

    if (c != EOF) {
	errmsg("f","During file copy, %s\n", sys_errlist[errno]);
	return -1;
    }
    if (debug)
	dbgmsg(__FILE__, __LINE__, "Copying done.\n");
    return 0;
}

void Usage()			/* Prints the usage and help */
{				/* NO exit or sorti.	     */
    register char **hptr=helpstrs;
    fprintf(stderr,"usage: %s %s\n\n",pgm_name,*hptr++);
    while (*hptr)
	fprintf(stderr,"%s\n",*hptr++);
    fprintf(stderr,"\n");
}


	/********************/
	/*	MAIN	    */
	/********************/

main(argc,argv)
    int argc;
    char **argv;
{
    char *s=NULL, *ifname=NULL, *ofname=NULL, *logfname=NULL;
    char *cppstr=NULL;
    int argind=1, mypid=getpid(), errflg=0, i, kindOfModel=ITIS_UNDETERM;
    int noP2flg=0, rmlogflg=1, doCppflg=0, stdoutflg=0, warnflg=0;
    FILE *ifp=NULL, *ofp=NULL;
    NAMETABLE *VectorTable=NULL;

    errno=0;
    if (s=strrchr(argv[0],'/'))	/* hide the program path. */
	pgm_name = s+1;
    else
	pgm_name = argv[0];

    ssignal(1,sig_sorti);	/* Some software signals to abort the */
    ssignal(2,sig_sorti);	/* session in a nice and clean way. */
    ssignal(3,sig_sorti);

    while (argind<argc) {	/* command line parsing */
	register char *argp=argv[argind];
	register char *optarg;
	if (*argp == '-') {
	    for (argp++; *argp;)
		switch (*argp) {
		case 'v':	/* set verbose mode ... */
		    argp++;
		    verbflg=1;
		    break;
		case 'r':	/* insert cpp line/file references ... */
		    argp++;
		    cppLine=1;
		    break;
		case 'n':	/* don't make any C++ comments ... */
		    argp++;
		    beQuiet=1;
		    break;
		case 'd':	/* set debug ... */
		    switch (*++argp) { /* determine the level ... */
		    case '0':
			debug = 0;
			argp++;
			break;
		    case '1':
		    case '2':
		    case '3':
		    case '4':
		    case '5':
		    case '6':
		    case '7':
		    case '8':
		    case '9':
			verbflg=1; /* set verbose in debug mode also */
			rmlogflg=0;
			debug = *argp - '0';
			argp++;
			break;
		    case 0:
		    default:
			debug=1;
			verbflg=1;
			rmlogflg=0;
			break;
		    }
		    break;
		case 'c':	/* run the preprocessor first */
		    argp++;
		    doCppflg=1;
		    break;
		case 'm':
		    if (!strncmp(argp,"monitor",7)) {
			kindOfModel = ITIS_MONITOR;
			argp += 7;
		    }
		    else if (!strncmp(argp,"model",5)) {
			kindOfModel = ITIS_MODEL;
			argp += 5;
		    }
		    else {
			argp++;	/* don't do any macro expansion */
			noP2flg=1;
		    }
		    break;
		case 'g':
		    if (!strncmp(argp,"generator",9)) {
			kindOfModel = ITIS_GENERATOR;
			argp += 9;
		    }
		    else
			goto illegal;
		    break;
		case 'l':	/* save the log file ... */
		    rmlogflg=0;
		    if (*++argp) { /* and rename it (, maybe) ? */
			if (logfname) {
			    errmsg("o","Sorry, you tryed to override previous logfilename.\n");
			    break;
			}
			logfname = savestr(argp);
			for (; *argp; argp++);
		    }
		    break;
		case 's':	/* write to standard out instead of file */
		    argp++;
		    stdoutflg=1;
		    break;
		case 'o':	/* rename out file (the C++ file) */
		    if (*++argp) {
			optarg = argp;
			for (; *argp; argp++);
		    }
		    else {
			if (argind < argc - 1) {
			    optarg = argv[++argind];
			    if (*optarg == '-') {
				errmsg("o","missing argument to option `-o'.\n");
				Usage();
				sorti(2);
			    }
			}
			else {
			    errmsg("o","missing argument to option `-o'.\n");
			    Usage();
			    sorti(2);
			}
		    }
		    if (ofname) {
			errmsg("o","Sorry, you tryed to override previous name.\n");
			break;
		    }
		    else 
			ofname = optarg;
		    break;
		default:
		illegal:
		    errmsg("o","Illegal option `-%c'.\n", *argp);
		case 'h':	/* print the help message without any */
		    Usage();	/* complaints ... */
		    exit(1);
		}
	}
	else {			/* This must be the model file ... */
	    if (!ifname)
		ifname = argp;
	}
	argind++;
    }				/* end command line parsing. */

    /* If verbose, Salute ... */

    if (verbflg)
	fprintf(stderr,"\n\t\tWelcome to %s %s\n\n",pgm_name,version);

    /* Initialize logfile ... */

    if (debug)
	dbgmsg(__FILE__, __LINE__, "Initialize logfile ...\n");
    if (!logfname) {
	logfname = (char *) malloc(strlen(pgm_name) + 5);
	sprintf(logfname,"%s.log",pgm_name);
    }
    if ((logfileptr = fopen(logfname,"w"))) {
	register int i;
	fprintf(logfileptr,"\n\t\tLogfile to program %s %s.\n\n", pgm_name, version);
#ifndef NOCOMPINFO
	fprintf(logfileptr,"\n  (%s)\n\n", comp_info);
#endif
	fprintf(logfileptr,"\nInvoking command:");
	for (i=0; i<argc; i++)
	    fprintf(logfileptr," %s", argv[i]);
	fprintf(logfileptr,"\n\n");
    }
    if (debug)
	dbgmsg(__FILE__, __LINE__,
	       "Logfile \"%s\" is ready to use (filedes=%d)...\n",
	       logfname, fileno(logfileptr));

    /* eval ifname and try to open its file ... */

    if (debug)
	dbgmsg(__FILE__, __LINE__, "Determine input stream ...\n");

    if (!ifname) {

	/* input from standar in ... */

	errmsg(verbflg ? "o" : "O","Reading from standard in ...\n");
	if (!doCppflg)
	    ifp=stdin;
	else {			/* Preprocess preparation... */
	    if (debug)
		dbgmsg(__FILE__, __LINE__, "Preparing for cpp ...\n");
	    sprintf(lsbuf_,"stdin_%d",mypid);
	    tmpin = savestr(lsbuf_);
	    if ((tmpinfp=fopen(tmpin,"w"))) {
		errflg |= cpF2toF1(tmpinfp,stdin);
		fclose(tmpinfp);
	    }
	    else {
		errmsg("f","%s. Unable to generater input file to ccp. Can't continue.\n%s",
		       "\t(Try to use a file as input instead.)\n",
		       sys_errlist[errno]);
		errflg = EOF;
	    }
	}
    }
    else {

	/* input from file `ifname' ... */

	if (debug)
	    dbgmsg(__FILE__, __LINE__, "Reading from file \"%s\" ...\n", ifname);
	if (!doCppflg) {
	    if (!(ifp=fopen(ifname,"r"))) {
		errmsg("o","\"%s\", %s. Can't continue.\n",
		       ifname, sys_errlist[errno]);
		errflg = EOF;
	    }
	}
	else {			/* Preprocess ... preparation*/
	    if (debug)
		dbgmsg(__FILE__, __LINE__, "Preparing for cpp ...\n");
	    if (access(ifname,4)) {
		errmsg("o","\"%s\", %s. Can't continue.\n",
		       ifname, sys_errlist[errno]);
		errflg = EOF;
	    }
	}
    }

    if (errflg)
	sorti(2);		/* Failed */

    if (debug)
	dbgmsg(__FILE__, __LINE__, "Input stream is setup (filedes = %d).\n",
	       ifp ? fileno(ifp) : -1);

    sprintf(lsbuf_,"pepp_%d",mypid); /* generate tmpfilename ... */
    tmpfname = savestr(lsbuf_);
    if (!(tmpfp=fopen(tmpfname,"w+"))) {
	errmsg("o","\"%s\", %s. Can't continue.\n",
	       tmpfname, sys_errlist[errno]);
	sorti(2);
    }
    if (debug)
	dbgmsg(__FILE__, __LINE__, "tmpfile name is \"%s\" (filedes = %d).\n",
	       tmpfname, fileno(tmpfp));


    sprintf(lsbuf_,"Pass1_%d",mypid);   /* generate filename to resulting */
    ofnamep1 = savestr(lsbuf_);		/* file from pass 1. */
    if (!(ofpp1=fopen(ofnamep1,"w+"))) {
	errmsg("o","\"%s\", %s. Can't continue.\n",
	       ofnamep1, sys_errlist[errno]);
	sorti(2);
    }
    if (debug)
	dbgmsg(__FILE__, __LINE__,
	       "Pass1 output to file \"%s\" (filedes = %d).\n",
	       ofnamep1, fileno(ofpp1));
    

    if (doCppflg) {		/* Preprocess ... */
	char *cmd = getenv(PEPPCPPENV);
	sprintf(lsbuf_,"%s %s", cmd ? cmd : Cppcmd, ifname ? ifname : tmpin);
	cppstr = savestr(lsbuf_);
	if (debug)
	    dbgmsg(__FILE__, __LINE__,
		   "Starting cpp (popen(\"%s\",\"r\");).\n", cppstr);
	if (!(ifp=popen(cppstr,"r"))) {
	    errmsg("f","Can't run cpp. (Aborted)\n");
	    sorti(2);
	}
	if (debug)
	    dbgmsg(__FILE__, __LINE__, "Reading from filedes %d.\n",
		   fileno(ifp));
    }

    if (debug)
	dbgmsg(__FILE__, __LINE__,
	       "Initializing pass1 output file (\"%s\").\n", ofnamep1);

    initCCfile(ofpp1,ifname);		/* Print headers etc. ... */

			/*****************************/
			/* READY TO DO PASS1 NOW ... */
			/*****************************/

    errmsg(verbflg?"o":"O","Starting ThorStar conversion pass. (pass 1, < \"%s\")\n",
	   ifname ? ifname : "(stdin)");
    switch (i=pass1(ifp,ifname,ofpp1,tmpfp,kindOfModel,&VectorTable)) {
    case 0:
	errmsg(verbflg ? "o" : "O","Conversion successfully done.\n");
	fflush(ofpp1);
	rewind(ofpp1);
	break;
    case 1:			/* `No model' message ... */
	rmlogflg=0;		/* so don't remove logfile */
	warnflg=1;
	fflush(ofpp1);
	rewind(ofpp1);
	break;
    case 2:			/* Parse error ... */
	if (ifname)
	    errmsg("s","\tA syntax error was found in \"%s\". %s\n",
		   ifname, "Can't continue.");
	else
	    errmsg("s","\tA syntax error was found. Can't continue.\n");
	errflg=1;
	break;
    case 3:			/* No infile ptr ... */
    case 4:			/* No outfile ptr ... */
    case 5:			/* No tmpfile ptr ... */
	errmsg("o","This should never happend. %s%s",
	       "You've found a program bug.\n",
	       "(Doing cleanup and then aborting ...)\n");
	sorti(1);
	break;
    default:			/* Bugs !!! ??? */
	errmsg("f","Unexpected return value from pass1 (%d). %s%s", i,
	       "You must have found a bug here !!!\n",
	       "(Doing cleanup and then aborting ...)\n");
	sorti(2);
    }
    if (doCppflg)
	pclose(ifp);
    else
	fclose(ifp);
    if (errflg) sorti(errflg);


			/***************/
			/* PASS1 DONE. */
			/***************/


			/***********************/
			/* Prepare outfile ... */
			/***********************/

    if (stdoutflg) {		/* print to standard out ... */
	ofp=stdout;
	if (debug)
	    dbgmsg(__FILE__, __LINE__, "Data will be placed on standard out ...\n");
    }
    else {			/* get the filename to file to write to ... */
	if (ofname) {
	    if (ifname && !strcmp(ofname,ifname)) {
		if (debug)
		    dbgmsg(__FILE__, __LINE__, "%s\n\t%s \"%s\".\n",
			   "Infile name and outfile name are the same.",
			   "Appending suffix `.cc' to", ofname);
		strcpy(lsbuf_,ofname);
		strcat(lsbuf_,".cc");
		ofname = savestr(lsbuf_);
	    }
	}
	else {			/* Have to make a filename ... */
	    if (ifname) {	/* from infile ... */
		ofname = savestr(ifname);
		if (s=strrchr(ofname,'.'))
		    if (!strcmp(s,".c") || !strcmp(s,".chdl"))
			*s = NULL;
		strcpy(lsbuf_,ofname);
		strcat(lsbuf_,".cc");
		free(ofname);
	    }
	    else {		/* from model name ... */
		strcpy(lsbuf_, ClassName ? ClassName : "stdin");
		strcat(lsbuf_,".cc");
		if (!ClassName)
		    errmsg("o","Output is written to file \"stdin.cc\".\n");
	    }
	    ofname = savestr(lsbuf_);
	}
    }

    if (noP2flg) {		/* Don't do vector macro expansion */
	errmsg(verbflg?"o":"O","Vector macros will not be expanded.\n");
	if (stdoutflg) {
	    if (debug)
		dbgmsg(__FILE__, __LINE__, "Writing data to filedes %d ...\n",
		       fileno(ofp));
	    cpF2toF1(ofp,ofpp1);
	}
	else
	    rename(ofnamep1,ofname);
	fclose(logfileptr);
	if (rmlogflg)
	    unlink(logfname);
	sorti(0);
    }
    if (!ofp) {
	if (!(ofp=fopen(ofname,"w"))) {
	    errmsg("f","\"%s\", %s. Can't continue.\n",
		   ofname, sys_errlist[errno]);
	    sorti(2);
	}
	if (debug)
	    dbgmsg(__FILE__, __LINE__, "\n\t%s \"%s\" (filedes=%d) ...\n",
		   "Data will be placed in", ofname, fileno(ofp));
    }



			/*****************************/
			/* READY TO DO PASS2 NOW ... */
			/*****************************/


    if (ofp == stdout)
	errmsg(verbflg?"o":"O","Starting vector macro expansion pass. (pass 2)\n");
    else
	errmsg(verbflg?"o":"O","Starting vector macro expansion pass. (%s\"%s\")\n",
	       "pass 2, > ", ofname);
    switch (i=pass2(ofpp1,ofp,ofname,ifname,VectorTable)) {
    case 0:
	errmsg(verbflg ? "o" : "O","Vector macro expansion pass successfully done.\n");
	break;
    case 1:			/* No expansion done ... */
	errmsg(verbflg ? "o" : "O", "No vector macro expansion was done.\n");
	break;
    case 2:			/* expansion/translation error ... */
	if (ofp != stdout) fclose(ofp);
	errmsg("o","Vector macro expansion failed. Please rewrite your model\n\t%s",
	       "file or edit the file generated by the command:\n");
	errmsg("s","\t%s -m", pgm_name);
	for (i=1; i<argc; i++)
	    errmsg("s"," %s",argv[i]);
	errmsg("s","\n\n");
	sorti(1);
	break;
    case 3:			/* No infile ptr ... */
    case 4:			/* No outfile ptr ... */
	if (ofp != stdout) fclose(ofp);
	if (ofname && !debug)
	    unlink(ofname);
	sorti(2);
	break;
    default:			/* BUGS !!!! ???? */
	errmsg("f","Bad return value from `pass2' (%d). Shouldn't occur.\n",i);
	if (ofp != stdout) fclose(ofp);
	if (ofname && !debug)
	    unlink(ofname);
	sorti(2);
	break;
    }
    if (ofp != stdout) fclose(ofp);

			/************************/
			/* PASS2 DONE, ALL DONE */
			/************************/


    VectorTable = freenametbl(VectorTable); /* release memory ... */
    errmsg(verbflg ? "o" : "O","All done.\n\n"); /* be nice ... */
    fclose(logfileptr);			    /* close logfile ... */
    if (rmlogflg) unlink(logfname);	    /* and maybe remove ... */
    sorti(warnflg ? 1:0);		    /* and good bye. */
}
/* <EOF> */
