/**************************************************************************
 * Version identification:
 * @(#)errmsg.c	1.2	5/20/91
 *
 *  Copyright (c) 1990,1991 The Regents of the University of California.
 *			    All Rights Reserved.
 *
 *  Programmer:  Anders Wass
 *  Date of creation: 10/22/90
 *  Description:
 *	This file contains the function used to communicate with the user,
 *	like error messages, warning or plain information. The kind of
 *	message is determined by the first character argument which should
 *	be one of f,F, o,O, s,S, or l,L, where if the capital is used, the
 *	message will go only to the logfile. Otherwise message is sent to
 *	both logfile and stderr. Stdout is not used to avoid conflict it
 *	data will go to stdout. f means a fatal error and the format string
 *	will be prepended with "pepp: Fata error: ". o means other message
 *	and the format string will be prepended with "pepp: ". s means
 *	syntax error and the format string will not be prepended at this
 *	case. l means write to logfile only and the format string will be
 *	prepended with "pepp: ". (pepp in this example is if the pgm_name is
 *	set to the value "pepp" by the calling program.
 **************************************************************************/

static char identification[] = "@(#)errmsg.c	1.2\t5/20/91  (c) UC Berkeley";

#include <stdio.h>
#include <ctype.h>
#include <varargs.h>

char *pgm_name = NULL;		/* These variables are supposed to be    */
FILE *logfileptr = NULL;	/* set by main program that uses errmsg. */

static char mbuff_[BUFSIZ];

void errmsg(va_alist)
    /* errmsg(char* action, char* format, arglist ...); */
    va_dcl
{
    va_list aptr;
    char *action, *format;
    va_start (aptr);
    action = va_arg(aptr, char *);
    format = va_arg(aptr, char *);
    mbuff_[0] = NULL;
    vsprintf(mbuff_,format,aptr);
    va_end(aptr);
    switch (*action) {
    case 'f':			/* Fatal error: */
	if (pgm_name)
	    fprintf(stderr,"%s: Fatal error: %s",pgm_name,mbuff_);
	else
	    fprintf(stderr,"Fatal error: %s",mbuff_);
    case 'F':			/* Write this to logfile only */
	if (logfileptr) {
	    if (pgm_name)
		fprintf(logfileptr,"%s: Fatal error: %s",pgm_name,mbuff_);
	    else
		fprintf(logfileptr,"Fatal error: %s",mbuff_);
	}
	break;
    case 'o':			/* Other message */
	if (pgm_name)
	    fprintf(stderr,"%s: %s",pgm_name,mbuff_);
	else
	    fprintf(stderr,"%s",mbuff_);
    case 'O':			/* Write this to logfile only */
	if (logfileptr) {
	    if (pgm_name)
		fprintf(logfileptr,"%s: %s",pgm_name,mbuff_);
	    else
		fprintf(logfileptr,"%s",mbuff_);
	}
	break;
    case 's':			/* Syntax error message (no pgm_name) */
	fprintf(stderr,"%s",mbuff_);
    case 'S':			/*       -- " " --    To logfile only */
	if (logfileptr)
	    fprintf(logfileptr,"%s",mbuff_);
	break;
    case 'L':			/* Write to logfile only */
    case 'l':
	if (logfileptr) {
	    if (pgm_name)
		fprintf(logfileptr,"%s: %s",pgm_name,mbuff_);
	    else
		fprintf(logfileptr,"%s",mbuff_);
	}
	break;
    default:
	fprintf(stderr,"** Program error ! Bad switch in function `errmsg'.\n");
	fprintf(stderr,"   (switch value = %d (`%c'))\n", (int) *action,
		isprint(*action) ? *action : ' ');
    }
}
