/**************************************************************************
 * Version identification:
 * @(#)comdefs.h	1.4	6/13/91
 *
 *  Copyright (c) 1990,1991 The Regents of the University of California.
 *                        All Rights Reserved.
 *
 *  Programmer:  Anders Wass
 *  Date of creation: 11/02/90
 *  Modifications:
 *	4/29/91: A Wass: Introduced the string ClassName and made ModelName
 *			 a substring of ClassName.
 *	6/6/91:  A Wass: Added some new structures (VARSTRUCT,
 *			 VARLISTSTRUCT, and (GENSTRUCT)) and functions
 *			 working on these.
 *	6/10/91: A Wass: Added function fillbuf.
 *  Description:
 *	Defines some common data structures and common variables for the
 *	pepp program.
 **************************************************************************/

#ifndef COMDEFS_H_
#define COMDEFS_H_ 1

#define ITIS_UNDETERM 0
#define ITIS_GENERATOR 1
#define ITIS_MONITOR 2
#define ITIS_MODEL 3
#define BIG_END 1
#define LIT_END 2

#ifndef PEPPCPPENV
#define PEPPCPPENV "PEPPCPP"
#endif

typedef struct icl {
    struct icl *next;
    char *line;
    int lineno;
} ICL;

typedef struct sigstruct {
    struct sigstruct *next;
    char *name,
	 *size;
    int   token,
	  endian,
	  lineno;
} SIGSTRUCT;

typedef struct decstruct {
    struct decstruct *next;
    int token,
	strtline,
	endline;
    SIGSTRUCT *list;
} DECSTRUCT;

typedef struct varstruct {
    struct varstruct *next;
    char *type,
	 *action;
    int   lineno;
} VARSTRUCT;

typedef struct varliststruct {
    VARSTRUCT *private,
	      *protected,
	      *public;
} VARLISTSTRUCT;

typedef struct nametable {
    struct nametable *next;
    char *name;
    char *size;
    int   type,
	  lineno;
} NAMETABLE;

typedef struct genstruct {
    struct genstruct *next;
} GENSTRUCT;

SIGSTRUCT *newsig(/* char *name, int token, char* size, int endian, int lineno*/),
	  *freeSigList(/* SIGSTRUCT *ptr */);
DECSTRUCT *newdeclist(/* DECSTRUCT *list, int token, int strtline, int endline */),
	  *freeDecList(/* DECSTRUCT *ptr */);
VARSTRUCT *newvar(/* char *type, *action, int lineno */),
	  *freeVarList(/* VARSTRUCT *ptr */);
NAMETABLE *insertname(/* char *name, char *size, int type, NAMETABLE *table, int lineno */);
NAMETABLE *getvecinfo(/* char *name, NAMETABLE *table */);
NAMETABLE *freenametbl(/* NAMETABLE *table */);

GENSTRUCT *append_struct(/* GENSTRUCT *elem, GENSTRUCT *list */);
#define append_sigs(e,l) (SIGSTRUCT*) append_struct((GENSTRUCT*)e,(GENSTRUCT*)l)
#define append_vars(e,l) (VARSTRUCT*) append_struct((GENSTRUCT*)e,(GENSTRUCT*)l)
#define app_declists(e,l) (DECSTRUCT*) append_struct((GENSTRUCT*)e,(GENSTRUCT*)l)

ICL *saveInitCode(/* char *line, int lineno, ICL *listhead */),
    *freeIclList(/* ICL *ptr */);
void initCCfile(/* FILE *fp, char *mfilename */);
void makeClass(/* DECSTRUCT *ports, SIGSTRUCT* tmps, VARLISTSTRUCT *varlist,
		  FILE *fp, int TypeOfModel */);
void makeConstruct(/* DECSTRUCT *list, FILE *fp */);
void printInitCode(/* ICL *listhead, FILE *file */);
void make_startfcn(/* ICL *lhead, FILE *file */);
void printHeader(/* DECSTRUCT *declist, SIGSTRUCT *tmplist,
		    VARLISTSTRUCT *varlist, ICL *icllist, 
		    FILE *fp, int TypeOfModel */);
void make_Gofcn(/* FILE *from, FILE *to */);
void makeVarDecl(/* FILE *fp, VARSTRUCT *var */);

char *savestr(/* char *str */);
int fillbuf(/* char *buf, int len, FILE *stream */);
void errmsg(/* char *action, char *format, ... */);
void dbgmsg(/* char *file, int line, char *format, ... */);
extern int cppLine, beQuiet;
extern void whereIam(/* FILE *fp, int line, char *fn */);
extern char *pgm_name;
extern FILE *logfileptr;

extern int pass1(/* FILE *infile, char *infilename, FILE *outfile,
		 /* FILE *tnpfp, int TypeOfModel, NAMETABLE **nametbl */);
extern int pass2(/* FILE *infp, FILE *outfp, char *outfname,
		 /* char *modelfname, NAMETABLE *nametbl */);
extern char *ModelName, *ClassName, *FileIParse;
extern int verbflg, debug;
extern char *version;

char *getdescriptor(), *getdescline(/* char* */);
void printSigList(/* SIGSTRUCT *list */);
void printDecList(/* DECSTRUCT *list */);
void printNameTbl(/* NAMETABLE *tbl */);
void printVarList(/* VARLISTSTRUCT *list */);
void printVarStruct(/* VARSTRUCT *ptr */);

#endif
