/**************************************************************************
 * Version identification:
 * @(#)codefncs.c	1.11	11/24/92
 *
 *  Copyright (c) 1990,1991 The Regents of the University of California.
 *                        All Rights Reserved.
 *
 *  Programmer:  Anders Wass
 *  Date of creation: 12/03/90
 *  Modified:  Seungjun Lee  3/6/91
 *	       Anders Wass   4/29/91  Introduced the string variables
 *				      ClassName and ModelName
 *  Modified:  Anders Wass   5/14/91  Added string vector GlobCpps.
 *				      Also added new descriptor handling.
 *  Modified:  Anders Wass   6/7/91   Added string StatErrHdlr and string
 *                                  vector ErrHdlrDecl.
 *  Modified:  Anders Wass   6/10/91  Changed the way code is appended in
 *                                  the make_Gofcn.
 *  Description:
 *	This file contains the functions that generates the C++ code from
 *	the information gathered by the two passes of the model file.
 *************************************************************************/

static char identification[] = "@(#)codefncs.c	1.11\t11/24/92  (c) UC Berkeley";

#include <stdio.h>
#include <string.h>
#include <time.h>
#include "comdefs.h"
#include "pass1Syn.h"
#include "cc-strings.h"

char *FileIParse = NULL;

static char *wdays[] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
static char *months[] = {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
    };

int cppLine = 0;
int beQuiet = 0;

void whereIam(fp,line,fn) FILE *fp; int line; char *fn;
{
    if (!beQuiet || cppLine)
	fprintf(fp,"%s line %d \"%s\"\n",cppLine ? "#" : "//", line, fn);
}

ICL *saveInitCode(line,lineno,listhead) /* allocates an ICL element,  */
    char *line;			/* and saves the string pointed out   */
    int lineno;			/* by line in it, and finally appends */
    ICL *listhead;		/* the element to the list pointed    */
{				/* out by listhead.		      */
    ICL *ip;
    ICL *icl = (ICL *) malloc(sizeof(ICL));
    if (!icl) {
	errmsg("o","(saveInitCode:) Can't allocate more memory.\n");
	exit(1);
    }
    icl->line = savestr(line);
    icl->lineno = lineno;
    icl->next = NULL;
    if (!listhead) return icl;
    for (ip = listhead; ip->next; ip = ip->next);
    ip->next = icl;
    return listhead;
}

void printInitCode(listhead,file) /* writes the contents of `listhead' */
    ICL *listhead;		/* on the open file `file'. */
    FILE *file;
{
    char **sptr;
    if (!listhead) return;
    for (sptr = ErrHdlrDecl; *sptr; sptr++)
	fputs(*sptr,file);
    whereIam(file,listhead->lineno,FileIParse);
    for (; listhead; listhead = listhead->next)
	fprintf(file,"%s\n",listhead->line);
}

ICL *freeIclList(ptr)		/* recurively free the initcode list. */
    ICL *ptr;
{
    if (!ptr) return NULL;
    if (ptr->next) ptr->next = freeIclList(ptr->next);
    free(ptr->line); ptr->line = NULL; ptr->lineno = 0;
    free(ptr);
    return NULL;
}

void initCCfile(fp,mfilename)	/* writes the contents of the vectors	*/
    FILE *fp;			/* `FirstLines' and `Includes' to file	*/
    char *mfilename;		/* fp. (Variables are defined in	*/
{				/* cc-strings.c and declared in		*/
    long clock;			/* cc-strings.h.			*/
    struct tm *tmbuf;
    char **sptr = FirstLines;

    fprintf (fp, "static const char file_id[] = \"%s\";\n",
	     mfilename ? mfilename : "<stdin>");
    while (*sptr) fputs(*sptr++,fp);
    fputs("\n",fp);
    time(&clock);
    tmbuf = localtime(&clock);
    fprintf(fp,"//  Conversion done %d/%02d/%02d, %2d:%02d:%02d by %s %s.\n",
	    tmbuf->tm_year + 1900, tmbuf->tm_mon+1, tmbuf->tm_mday,
	    tmbuf->tm_hour, tmbuf->tm_min, tmbuf->tm_sec, pgm_name, version);
    fprintf(fp,"//  Input is coming from %s\"%s\".\n\n",
	    mfilename ? "file " : "", mfilename ? mfilename : "(stdin)");
    sptr = Includes;
    while (*sptr)
	fprintf(fp,"#include %s\n",*sptr++);
    fputs("\n",fp);
    fputs(StatErrHdlr,fp);
    fputs("\n",fp);
    sptr = GlobCpps;
    while (*sptr)
	fputs(*sptr++,fp);
    fputs("\n",fp);
}

void makeVarDecl(fp,varlist)
    FILE *fp;
    VARSTRUCT *varlist;
{
    char *format = beQuiet ? "    %s%s%s;\n" : "    %s%s%s;\t// line %3d\n";
    for (;varlist; varlist = varlist->next)
	fprintf(fp,format, varlist->type,
		(strlen(varlist->type) < 12 ? "\t\t" : "\t"),
		varlist->action, varlist->lineno);
}

void makeClass(list,tmp,cvars,fp,ModType) /* writes the C++ class definition   */
    DECSTRUCT *list;		/* using information extracted from model file */
    SIGSTRUCT *tmp;
    VARLISTSTRUCT *cvars;
    FILE *fp;
    int ModType;
{
    int kindofmod = 0;
    fprintf(fp,PullIn,ClassName,ClassName); /* generate PullIn string */
    fprintf(fp,Class,ClassName); /* `Class' is a format string !!! */
    fputs("private:\n",fp);
    if (tmp && !beQuiet)
	fputs("//\t    Temporary signal list:\n",fp);
    for (;tmp; tmp = tmp->next) {
	int tkn;
	switch (tkn = tmp->token) {
	case TSIG:
	    fprintf(fp,TSigDecl,tmp->name);
	    break;
	case TGRP:
	    fprintf(fp,TGrpDecl,tmp->name,tmp->size);
	    break;
	case SIG:
	case GRP:
	case VGRP:
	    errmsg("f","(makeClass:) SIG, GRP or VGRP.\n\t%s\n\t%s\n",
		   "Shouldn't occur here in tmp sig list.",
		   "Beware !! Data base seems to be corrupted.");
	    break;
	default:
	    errmsg("f","(makeClass:) Illegal token # = %d\n", tkn);
	    break;
	}
    }

    for (; list; list = list->next) { /* make the ThorPort declaraions ... */

	SIGSTRUCT *sigprop;
	int tkn;
	char *porttype, *sport, *mport;

	switch (list->token) {
	case IN_LIST:
	    porttype = "//\t    Inport list:";
	    sport = SingleIn;
	    mport = MultiIn;
	    kindofmod |= 2;
	    break;
	case OUT_LIST:
	    porttype = "//\t    Outport list:";
	    sport = SingleOut;
	    mport = MultiOut;
	    kindofmod |= 1;
	    break;
	case BI_LIST:
	    porttype = "//\t    Biport list:";
	    sport = SingleBi;
	    mport = MultiBi;
	    kindofmod |= 3;
	    break;
	case ST_LIST:
	    porttype = "//\t    State list:";
	    sport = SingleSt;
	    mport = MultiSt;
	    break;
	default:
	    porttype = "//\t    (Unknown port type !!!)";
	    sport = mport = "// *** Unknown port type";
	}
	if (!beQuiet)
	    fprintf(fp,"\n%s (between lines %d and %d)\n", porttype,
		    list->strtline, list->endline);

	for (sigprop=list->list; sigprop; sigprop = sigprop->next)
	    switch (tkn = sigprop->token) {
	    case SIG:
		if (list->token == ST_LIST) {
		    fprintf(fp,SStateDecl, sigprop->name);
		    fprintf(fp,HidSStateD, sport, sigprop->name);
		}
		else
		    fprintf(fp,SPortDecl, sport, sigprop->name);
		break;
	    case GRP:
	    case VGRP:
		fprintf(fp,MPortDecl,mport, sigprop->name);
		break;
	    case TSIG:
	    case TGRP:
		errmsg("f","(makeClass:) TSIG or TGRP.\n\t%s\n",
		       "Shouldn't occur here in port list.");
		break;
	    default:
		errmsg("f","(makeClass:) Illegal token # = %d\n", tkn);
		break;
	    }
    }

    /* Declare additional pThor functions ... */
    /* (Code specific char pointers defined in cc-strings.c(h).) */

    if (cvars->private)
	makeVarDecl(fp,cvars->private);
    if (cvars->protected) {
	fputs("\nprotected:\n",fp);
	makeVarDecl(fp,cvars->protected);
    }
    fputs("\npublic:\n",fp);
    if (cvars->public)
	makeVarDecl(fp,cvars->public);

    fprintf(fp,"    int\t\t\t%s() { return TRUE; }\n",
	    ThorStarType[ModType ? ModType : kindofmod]);
    fprintf(fp,"    %s();", ClassName);
    fputs(beQuiet ? "\n" : "\t\t// Constructor\n", fp);
    fprintf(fp,"    %s\t\t%s();\n    %s\t\t%s();\n",
	      GoType, Go, StartType, Start);
    fprintf(fp, Clone, ClassName);
    fputs("\n};\n\n",fp);
}

static char strbuf[512];

void makeConstruct(list,fp)	/* writes the C++ constructor code for	*/
    DECSTRUCT *list;		/* this new class using information	*/
    FILE *fp;			/* extracted from the model file.	*/
{
    char *iports="", *oports="", *bports="", *sports="", *plus="";
    char *desc = NULL, *descline = NULL;

    fprintf(fp,"%s :: %s ()",ClassName,ClassName);
    fputs(beQuiet ? "\n{\n" : "\t// Constructor\n{\n",fp);
    fprintf(fp,Descriptor[DESC_START]);
    fprintf(fp,Descriptor[DESC_INFO], pgm_name, version);
    if (desc = getdescriptor()) {
	fputs("\"\\n\"\n",fp);
	for (descline = getdescline(desc); descline; descline = getdescline(NULL))
	    fprintf(fp,Descriptor[HAVE_DESC],descline);
    }
    else
	fprintf(fp,Descriptor[NO_DESC],ModelName);
    fputs(Descriptor[DESC_END],fp);
    if (!beQuiet) fputs("\n//\tPorts:\n",fp);

    for (; list; list = list->next) {
				/* initialize the ports ... */
	SIGSTRUCT *sigprop;
	char *addport, *addArray;
	int tkn, portcntr=0;

	strbuf[0] = NULL; plus = "";
	switch (list->token) {
	case IN_LIST:
	case OUT_LIST:
	case BI_LIST:
	    addport = AddPort;
	    break;
	case ST_LIST:
	    if (!beQuiet) fputs("\n//\tStates:\n",fp);
	    break;
	default:
	    addport = "// *** Unknown port type to port \"%s\".\n";
	}
	fputs("\n",fp);

	for (sigprop=list->list; sigprop; sigprop = sigprop->next) {

	    char *name = sigprop->name, *size = NULL; int print = 1;

	    switch (tkn = sigprop->token) {
	    case TGRP:
	    case TSIG:
		print = 0;
		break;
	    case SIG:
		if (list->token == ST_LIST)
		    addport = AddSState;
		size = DefSSSize;
		break;
	    case GRP:
		if (list->token == ST_LIST)
		    addport = AddMState;
		size = sigprop->size;
		break;
	    case VGRP:
		if (list->token == ST_LIST)
		    addport = AddMState;
		size = DefMSSize; /* only used by MutltiThorState::setState() */
		break;
	    default:
		errmsg("F","(printHeader:) Illegal token # = %d\n",tkn);
		print = 0;
		break;
	    }
	    if (print) {
		fprintf(fp,addport,name,name,size,name);
		if (tkn != VGRP) { /* Don't add size of VGRP at
				      initializition time ... */
		    strcat(strbuf,plus);
		    if (tkn == GRP) strcat(strbuf,"(");
		    strcat(strbuf,sigprop->size);
		    if (tkn == GRP) strcat(strbuf,")");
		    plus = " + ";
		}
	    }
	}
	switch (list->token) {
	case IN_LIST:	iports = savestr(strbuf); break;
	case OUT_LIST:	oports = savestr(strbuf); break;
	case BI_LIST:	bports = savestr(strbuf); break;
	case ST_LIST:	sports = savestr(strbuf); break;
	default: break;
	}
    }


    /* initialize the portcounter for each kind of port ... */
/*
    fprintf(fp,"\n    %s(%s);\n    %s(%s);\n    %s(%s);\n",
	    SetIn, *iports ? iports : "0",
	    SetOut, *oports ? oports : "0",
	    SetBi, *bports ? bports : "0");
*/
/*
    fprintf(fp,"    %s(%s)l\n", SetSt, *sports ? sports ? "0");
*/
    fputs("}\n\n",fp);
    free(iports); free(oports); free(bports); free(sports);
}

void make_startfcn(lhead,ccfptr) /* writes the `start()' function ... */
    ICL *lhead;
    FILE *ccfptr;
{
    fprintf(ccfptr,"\n%s %s :: %s()\n{\n", StartType, ClassName, Start);
    printInitCode(lhead,ccfptr);
    fputs("}\n\n",ccfptr);
}

void printHeader(dec_list,tmp_list,varlist,icl_list,outfile,TypeOfMod)
    DECSTRUCT *dec_list;	/* writes the class, constructor, */
    SIGSTRUCT *tmp_list;	/* start, and proto stuff ... */
    VARLISTSTRUCT *varlist;
    ICL *icl_list;
    FILE *outfile;
    int TypeOfMod;
{
    if (!outfile) {
	errmsg("o","(printHeader:) No file to write C++ code to !!!\n");
	return;
    }
    makeClass(dec_list,tmp_list,varlist,outfile,TypeOfMod);
    makeConstruct(dec_list,outfile);
    make_startfcn(icl_list,outfile);
    fprintf(outfile, Proto, ClassName);
    fprintf(outfile, Entry, ModelName);
}

static char cpbuf[BUFSIZ];

void make_Gofcn(from,to)	/* writes the `go()' function declaration */
    FILE *from, *to;		/* and then copies the `from'-file to the */
{				/* `to'-file. */
    int isblank, wasblank;
    char **sptr;

    fflush(from); rewind(from);	/* just in case ... */
    fprintf(to,"\n%s %s :: %s()\n{\n", GoType, ClassName, Go);

/* Added by S.Lee, 3/6/1991 */
    sptr = Defines;
    while (*sptr)
        fprintf(to,"#define %s\n",*sptr++);
    fputs("\n",to);
/* up to here */

    for (sptr=ErrHdlrDecl; *sptr; sptr++)
	fputs(*sptr,to);

    cpbuf[0] = NULL;
    wasblank=0;
    do {
	isblank = fillbuf(cpbuf,BUFSIZ,from);
	if (!isblank || !wasblank)
	    if (cpbuf[0]) fputs(cpbuf,to);
	wasblank = isblank;
    } while (!feof(from));
    putc('\n',to);
}
