/* 
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
*/
/*	@(#)thor_ipc.c	1.3 11/25/92 	*/
#if !defined(lint) && !defined(SABER)
static	char	sccsid[] = "@(#)thor_ipc.c	1.2	2/27/91";
static	char	copyright[] =
"Copyright 1989 Regents of the University of California.  All rights reserved.";
#endif /* not lint and not saber */

/*
 * thor side of IPC communications for Frigg
 */

#include <stdio.h>


/* perform communications:
 * i.e., take pin_vals array passed from Thor56k.c, and send out over
 * IPC connection; then fill the array with values received over the
 * IPC connection and return.
 */ 
server_talk(sock, pin_vals, num_pins)
	int	sock;
	char	*pin_vals;
	int	num_pins;
{
	int	n_read, n_written;
	int	i;
	char	buffer;
/*
	fprintf(stderr,
	"\nthor_ipc_server: server_talk: sending pin values for socket: %d\n",
		sock);
	for (i = 0; i < num_pins; i++)
		fprintf(stderr,"%d", (int) pin_vals[i]);
	printf(stderr,"\n");
	printf(stderr,"\n");
*/
/* DEBUG */


	n_written = write(sock, pin_vals, num_pins);
	if (n_written == -1) {
		perror("\nthor_ipc_server: server_talk: ERROR: write");
		exit(-1);
	}
	if (n_written != num_pins) {
		fprintf(stderr,
	"\nthor_ipc_server: server_talk: ERROR: short write (%d not %d)\n",
		n_written, num_pins);
		exit(-1);
	}
/*	fprintf(stderr,"\nthor_ipc_server: server_talk: write OK.\n"); */
/* DEBUG */

	i = 0;
	while (i < num_pins) {
		/* XXX should do full reads */
/*		printf("before read statement\n"); */
		n_read = read(sock, &buffer, 1);
/*	printf("after reading value from socket:\t%d\t%d\n",i,buffer); */
		if (n_read == -1) {
			perror("\nthor_ipc_server: server_talk: ERROR: read");
			exit(1);
		}
		if (n_read == 0) {
			fprintf(stderr,
	"\nthor_ipc_server: server_talk: connection closed by remote end.\n");
			exit(1);	/* XXX? */
		}
		pin_vals[i++] = buffer; 
	}

/*
fprintf(stderr,"\nthor_ipc_server: server_talk: read OK; socket = %d\n", sock);
	fprintf(stderr, "thor_ipc_server: server_talk: received pin values:\n");
*/
/* for debuggin we may pass i pins and opins too.. 
	fprintf(stderr,"\n");
	for (i = 0; i < 26; i++)
		fprintf(stderr,"%d", (int) pin_vals[i]);
	fprintf(stderr,"  "); 
	for (i = 26; i < num_pins; i++)
		fprintf(stderr,"%d", (int) pin_vals[i]);
	fprintf(stderr,"\n"); 
*/
/*	fprintf(stderr,"\n"); 
	for (i = 0; i < num_pins; i++)
		fprintf(stderr,"%d", (int) pin_vals[i]);
	fprintf(stderr,"\n"); 
*/
/* DEBUG */
}
