static const char file_id[] = "sperror.cc";
/**************************************************************************
 * Version identification:
 * @(#)sperror.cc	1.6	11/25/92
 *
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
 *
 * Programmer:		Anders Wass
 * Date of creation:	2/11/91
 * Modification:	6/12/91, A Wass: remove message for errno==0.
 *					 Added function clrErrNo.
 *
 * Description:
 *	Formats a error message that contains a system error (if exists)
 *	and returns the result as a string. The first argument will appear
 *	before the system message. The second and third will appear at the
 *	end of the string.
 *
 **************************************************************************/

// This may look like C code, but it is really -*- C++ -*-

// sperror.cc  -- return a pointer to a string containg standard error
// report like the perror(string) style. It is specially designed to give
// error strings that could be passed to the proper error handler in
// pThor (pTolemy). NOTE: The returned string is NOT ended with a NewLine.
// If a NewLine is needed, it should occur in the second or third argument.

#include <stdio.h>
#include <errno.h>

const char* sperror(const char* s1 =0, const char* s2 =0, const char* s3 =0)
{
    static char msgbuf[20];
    if (errno == 0) return "";
    if (errno < sys_nerr) return sys_errlist[errno];
    sprintf (msgbuf, "Error %d", errno);
    return msgbuf;
}

void clrErrNo() { errno = 0; }
