/* 
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
*/
#if !defined(lint) && !defined(SABER)
static	char	sccsid[] = "@(#)rpc.c	1.4 11/25/92";
#endif /* not lint and not saber */

/*
From: Rick L. Spickelmier <ricks@shambhala.berkeley.edu>
Date: Wed, 07 Dec 88 10:22:50 -0800
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/times.h>
#include <netinet/in.h>
#include <signal.h>
#include <errno.h>
#include <netdb.h>


/*
 * create a passive socket
 *  returns a socket if okay, else RPC_ERROR (-1)
 */
RPCSetUpSocket(protocol, port)
char *protocol;
int *port;
{
    int s;			/* socket */

    if (strcmp(protocol, "inet") == 0) {

	if ((s = RPCinet_createAndBindSocket(port)) < 0) {
	    fprintf(stderr,"RPC Error: socket create and bind failed\n");
	    return(-1);
	}
		
#ifdef DNET
    } else if (strcmp(protocol, "decnet") == 0) {

	if ((s = RPCdnet_createAndBindSocket(port)) < 0) {
	    fprintf(stderr, "RPC Error: socket create and bind failed\n");
	    return(-1);
	}
#endif DNET
	
    } else {
	fprintf(stderr, "RPC Error: unsupported protocol: %s\n", protocol);
	return(-1);
    }
    
    /* make the socket passive */
    if (listen(s, 10) < 0) {
	fprintf(stderr, "RPC Error: listen fails\n");
	perror("listen");
	return(-1);
    }

    return(s);
}



/*
From: Rick L. Spickelmier <ricks@shambhala.berkeley.edu>
Date: Wed, 07 Dec 88 10:17:00 -0800
*/

int
RPCinet_createAndBindSocket(port)
int *port;
/*
 * create an internet socket and bind it
 */
{
    int s;			/* socket */
    struct sockaddr_in sin;	/* internet binding address */
    int retry;			/* number of times to retry the bind */
    int length;
    retry = 20;

/*    fprintf(stderr, "RPC Server: inet protocol\n"); */
    
    sin.sin_port = 0;
    sin.sin_family = AF_INET;		/* family - internet */
    sin.sin_addr.s_addr = INADDR_ANY;	/* allow connect from any where */
    
    if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	fprintf(stderr,"RPC Error: inet socket fails\n");
	perror("socket inet");
	return(-1);
    }

    while (retry > 0) {
	if (bind(s, (struct sockaddr *) &sin, sizeof(sin)) < 0) {
	    fprintf(stderr,"RPC Error: retrying bind\n");
	    retry--;
	    continue;
	}
	break;
    }
    
    if (retry == 0) {
	fprintf(stderr,"RPC Error: can't find a port\n");
	return(-1);
    }

    length = sizeof(sin);
    
    /* XXX should be (struct sockaddr *) */
    if (getsockname(s, (char *) &sin, &length) < 0) {
	fprintf(stderr,"RPC Error: getsockname failed\n");
	return(-1);
    }
    
    *port = sin.sin_port;

    return(s);
}




