/**************************************************************************
Version identification:
@(#)ipc.c	1.2	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Anders Wass
 Date of creation: 2/11/91
 Description:
**************************************************************************/

#ifndef lint
static char rcsid[] = "$Header: ipc.c,v 1.1 86/11/30 03:57:30 salz Exp $";
#endif

/*
 * Inter-Process Communication procedures
 */

#include "ipc.h"

static  Message  message;		/* communication buffer */

/*
 * Read a message from channel into data, return data size in len
 */
MsgType ipc_Receive( channel, data, len )
  int   channel;
  char  **data;
  int   *len;
  {
    if( read( channel, &message, sizeof( Header ), 0 ) != sizeof( Header ) )
	return( IPC_ERR );
    *len = 0;
    if( message.header.length )
      {
	*len = read( channel, message.data, message.header.length );
	if( *len != message.header.length )
	    return( IPC_ERR );
      }
    *data = message.data;
    return( message.header.type );
  }



/*
 * Send len bytes of data through channel.  Only return values are IPC_OK
 * or IPC_ERR in case of an error.
 */
MsgType ipc_Send( channel, data, len, msgType )
  int	   channel;
  char	   *data;
  int	   len;
  MsgType  msgType;
  {
    int  size;
    
    message.header.type = msgType;
    message.header.length = len;
    bcopy( data, message.data, len );
    size = sizeof( Header ) + len;

    if( write( channel, &message, size ) != size ) 
	return( IPC_ERR );
    else
	return( IPC_OK );
  }


/*
 * Return a ptr. to the data buffer.
 */
GetLastHist( ptr )
  char **ptr;
  {
    *ptr = message.data;
  }
