/**************************************************************************
Version identification:
@(#)history.h	1.2	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Anders Wass
 Date of creation: 2/11/91
 Description:
**************************************************************************/

#ifndef HIST_H

#define HIST_H
#define historyRCSID "$Header: history.h,v 1.1 86/12/07 15:25:52 salz Exp $";

#define MAXINPUTS	4000

typedef int   TimeType;
typedef char  *Levels;			/* signal levels are kept as chars */

typedef struct HistEnt
  {
    TimeType	    time;		/* Simulation time of transition */
    Levels	    levels;		/* Levels of the signals */
    struct HistEnt  *next;		/* Next entry in time */
    struct HistEnt  *prev;		/* Previous entry in time */
  } HistEnt, *HistRef;



typedef struct		/* History entry for communication */
  {
    TimeType	    time;		/* Simulation time of transition */
    char	    levels[ MAXINPUTS];		/* Levels of the signals */
  } CommHist;


extern int        AddHist( );
extern HistRef    GetHist( );

#endif
