static const char file_id[] = "fprval.cc";
/**************************************************************************
Version identification:
@(#)fprval.cc	1.6	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Seungjun Lee
 Date of creation: 2/11/91
 Description: C++ version of thor library routines

**************************************************************************/
/*
*	Prints the requested data values in a bus.
*	The postions being printed along with their values are printed.
*	No checks are made for valid data. However fckmsize
*	is performed.
*
*/

#include	"uarp.h"
#include	"lib.h"
#include <stdio.h>
#include "libarp.h"

int fprval(
int *arr, int msb, int lsb)
{

int dir,i,j,error;
int lines,size;
int prindex(int, int, int);

error = fckmsize(msb,lsb);
if (error > FAILED)
{
	dir = DIR(lsb,msb);
	size = abs(msb-lsb) + 1;
	lines = size/MAXBUSLEN_ + 1;
	printf("msb\n");
	prindex(msb,lsb,dir);
	j = msb;
	i = msb;
	while (i != lsb)
	{
		if (++j > MAXBUSLEN_)
		{
			printf("\n");
			prindex(j,lsb,dir);
		}
		else
		{
			printf("%1d  ",arr[i]);
		}
		i += dir;
	}
	printf("%1d  ",arr[i]);
}
printf("\n");
return error;
}

int
prindex(int s, int e, int d)
{
int i,j;
i = s;
j = 1;
while (i != e && j <= MAXBUSLEN_)
{
	printf("%-2d ",i);
	j++;
	i += d;
}
if (j <= MAXBUSLEN_)
	printf("%-2d ",i);
printf("\n");
return 0;
}

#ifdef DEBUG
#define SIZE 8
main(int argc, char *argv[])
{
static int arin1[MAXBUSLEN_] = {0,1,2,0,1,2,0,1,2};
int 	msb1	=7,
	lsb1	=0
	;
int i;
int iflag;

iflag = (argc > 1) ? TRUE:FALSE;

if (iflag)
{
	printf("Enter msb: ");scanf("%d",&msb1);
	printf("Enter lsb: ");scanf("%d",&lsb1);
	fgetval(arin1,msb1,lsb1);
}

fprval(arin1,msb1,lsb1);

printf("\n\nEND of TEST\n");
/* end of test */
}
#endif

