static const char file_id[] = "fpack.cc";
/**************************************************************************
Version identification:
@(#)fpack.cc	1.6	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Seungjun Lee
 Date of creation: 2/11/91
 Description: C++ version of thor library routines

**************************************************************************/
/* fpack(arin,msb,lsb)
 *
 * Packs an array into a 32 bit integer.
 *
 * Procedure :
 *	Packs(converts) specified bits of array arin to an integer.
 *	The packing is done assuming unsigned (positive) numbers.
 *	(i.e. no sign is assumed in the msb position).
 *
 * Return Value:
 *	Integer value after conversion
 *	PASSED - no errors
 *	FAILED - any error detected
 *	UNDEFERROR - UNDEF value detected
 *	FLOATERROR -   value of FLOAT dectected
 */

#include "lib.h"
#include <stdio.h>
#include "uarp.h"
#include "libarp.h"

int fpack(

 int	*arin,		/* ptr to input array	*/
 int	msb,		/* array index of MSB	*/
 int	lsb)		/* array index of LSB	*/
{

	int error,number=0;
	int dir;
	int	m1,l1;	/* used by FDUMP */

	m1 = msb; l1 = lsb;

	error = PASSED;
	error |= fckmsize(msb,lsb);
	error |= fckbin(arin,msb,lsb);

	if (error == PASSED)
	{	
		number = 0;
		dir = DIR(msb,lsb);

		while ( (lsb != msb) && (error >= PASSED) )
		{
		    switch ( arin[msb] )
		    {
			case ZERO:
				number <<= 1;
				/* number += 0;*/
				break;

			case ONE:
				number <<= 1;
				number += 1;
				break;

			case UNDEF:
				error |= UNDEFERROR;
				break;

			case FLOAT:
				error |= FLOATERROR;
				break;

			default:
				error |= FAILED;
				break;
		    } 
		    msb -= dir;
		}
					/* now the case: (msb==lsb) */
		if (error == PASSED)
		{
		    switch ( arin[msb] )
		    {
			case ZERO:
				number <<= 1;
				/* number += 0;*/
				break;

			case ONE:
				number <<= 1;
				number += 1;
				break;

			case UNDEF:
				error |= UNDEFERROR;
				break;

			case FLOAT:
				error |= FLOATERROR;
				break;

			default:
				error |= FAILED;
				break;
		    } 
		}
	}/*end if (error == PASSED ) */

	if (error < PASSED)
	{
		ferr(error,"FPACK: Array not packed due to:");
	}

/*	put call sequence here as a reminder
int fpack(arin,msb,lsb)
*/


if (FDUMP_)
{
	fprintf(stdout,"FDUMP ***** START *****\n\n");
	fprintf(stdout,"FPACK: call sequence:\n%s\n",
		"out = fpack(grpin,msb,lsb)");
	fprintf(stdout,"FPACK: input group grpin:\n");
	fprval(arin,m1,l1);
	fprintf(stdout,"FPACK: out: %d\n",error);
	fprintf(stdout,"\nFDUMP ***** END *****\n\n");
}
	return(number);

} /* end fpack() */

/* DEBUG**********DEBUG**********DEBUG**********DEBUG */
#ifdef DEBUG
#define SIZE 8
main(int argc, char *argv[])
{
/* {lsb,,,...msb} */
static int arin1[] = {1,0,1,1,0,0,0,0};
int number = 0x0;
int 	msb1	= 3,
		lsb1	= 0
	;
int rval = 1;
int i,pvaro;
int	iflag = TRUE;
char c;
int	answ = 13;

FDUMPOFF;
while (iflag == TRUE)
{
	if (argc > 1)
	{
		/* interactive session */
		printf("Packing group1 \n");
		printf("Enter msb, lsb for group1:");
		scanf("%d,%d",&msb1,&lsb1);
		fgetval(arin1,msb1,lsb1);
	} else
		iflag = FALSE;

	pvaro = fpack(arin1, msb1, lsb1);
	
	printf("group1\n");
	fprval(arin1,msb1,lsb1);
	printf("Value returned by fpack: %d\n",pvaro);
	if (iflag == FALSE)
	{
		if (pvaro != answ)
		{
			rval = 1;
			printf("\nFAILED: Expected result: %d\n",answ);
		} else
			rval = 0;
		printf("\n\nEND of TEST\n");
	}
	/* end of test */
	if (argc > 1)
	{
		rval = 0;
		printf("Continue with test (y or n)? ");
		getchar();
		if ((c=getchar()) == 'y' || c == 'Y')
			iflag = TRUE;
		else
			iflag = FALSE;
	}
}
exit(rval);
}
#endif

