static const char file_id[] = "ferr.cc";
/**************************************************************************
Version identification:
@(#)ferr.cc	1.7	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Seungjun Lee
 Date of creation: 2/11/91
 Description: C++ version of thor library routines

**************************************************************************/
#ifdef COMMENT
/*
 *	this routine tests to see what error has occurred
 *	and then prints a message about the result

 *	The following errors are defined:
 */

#define PASS      0
#define PASSED    0
#define VALUEERROR MINUS|8	/*#3  bit value not in the set {0,1,2,3} */
#define RANGEERROR MINUS|16	/*#4 msb-lsb do not match for two arrays */
#define MSIZEERROR MINUS|32	/*#5 abs(msb-lsb) > MAXBUSLEN_		*/
#define BINERROR   MINUS|64	/* bit value not in the set {0,1}	*/
#define FAIL      MINUS|128	/*#7 general failure */
#define FAILED    MINUS|128
#define UNDEFERROR MINUS|256	/*#8 UNDEF found when not expected	*/
#define FLOATERROR MINUS|512	/*#9 FLOAT found when not expected	*/
#endif

#include <stdio.h>
#include "uarp.h"
#include "libarp.h"


int ferr(int error, const char *s)
{

    int i,err;

    fprintf(stderr, "Error in model %s:\n", mname()); 

    if (s && *s)
	fprintf(stderr,"%s",s);
    i = 0;
    while (MINUS != 1<<i)
    {
	err = error&(MINUS|(1<<i++));
	switch (err)
	{
	case FAILED:
		fprintf(stderr,"\nFAILED: general failure\n");
		error ^= MINUS^FAILED;
		break;
	case UNDEFERROR:
		fprintf(stderr,
			"\nUNDEFERROR: unexpected UNDEF value found.\n");
		error ^= MINUS^UNDEFERROR;
		break;
	case FLOATERROR:
		fprintf(stderr,
			"\nFLOATERROR: unexpected FLOAT value found.\n");
		error ^= MINUS^FLOATERROR;
		break;
 	case VALUEERROR:
		fprintf(stderr,
		    "\nVALUEERROR: bit value not in the set {0,1,2,3}.\n");
		error ^= MINUS^VALUEERROR;
		break;
 	case RANGEERROR:
		fprintf(stderr,
		    "\nRANGEERROR:msb-lsb do not match for input arrays.\n");
		error ^= MINUS^RANGEERROR;
		break;
 	case MSIZEERROR:
		fprintf(stderr,
		    "\nMSIZEERROR:size of group too large (MAXSIZE = %d.)\n",
		    MAXBUSLEN_);
		error ^= MINUS^MSIZEERROR;
		break;
	case BINERROR:
		fprintf(stderr,
		    "\nBINERROR:bit value not in the set {0,1}.\n");
		error ^= MINUS^BINERROR;
		break;
	default:
		break;
	}
    }
    if (error == 0)
	fprintf(stderr,"PASSED: No error detected\n");
    else
    if (error != MINUS)
	fprintf(stderr,"\nferr: %x is an unknown error type.\n",error);

    return(PASSED);
}
/* TEST**********TEST**********TEST**********TEST */
#ifdef TEST
#define	TRUE 1
#define	FALSE 0
main(int argc, char *argv[])
{
int number = 0x0;
int i,pvaro;
int	iflag = TRUE;
char c;

FDUMPOFF;
while (iflag == TRUE)
{
	if (argc > 1)
	{
		/* interactive session */
		printf("Enter error code(hex): ");
		scanf("%x",&number);
		printf("error code (hex) = %x\n",number);
		ferr(number,"TEST");
	} else
		iflag = FALSE;

	
	i = 0;
	if (argc <= 1)
	{
		i |= VALUEERROR;
		i |= RANGEERROR;
		i |= MSIZEERROR;
		ferr(i,"TEST of multiple errors\n");
		ferr(VALUEERROR,"TEST of VALUEERROR\n");
		ferr(FLOATERROR,"TEST of FLOATERROR\n");
		ferr(UNDEFERROR,"TEST of UNDEFERROR\n");
		ferr(FAILED,"TEST of FAILED\n");
		ferr(PASSED,"TEST of PASSED\n");
		ferr(RANGEERROR,"TEST of RANGEERROR\n");
		ferr(MSIZEERROR,"TEST of MSIZEERROR\n");
		ferr(BINERROR,"TEST of BINERROR\n");
		ferr(6,"TEST of illegal error code\n");
		printf("\nEnd of Test\n");
	}
	/* end of test */
	if (argc > 1)
	{
		printf("Continue with test (y or n)? ");
		getchar();
		if ((c=getchar()) == 'y' || c == 'Y')
			iflag = TRUE;
		else
			iflag = FALSE;
	}
}
}
#endif
