static const char file_id[] = "fckbin.cc";
/**************************************************************************
Version identification:
@(#)fckbin.cc	1.5	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Seungjun Lee
 Date of creation: 2/11/91
 Description: C++ version of thor library routines

**************************************************************************/
/* fckbin(arin1,msb1,lsb1)
 *
 * Checks that all "bit" values are in the set: {ZERO, ONE}
 *
 * Procedure :
 *	Tests to see that all values of the specified array
 *	are in the set {ZERO, ONE}.
 *	That is the values of all the "bits" are "known".
 *
 * Return value:
 *	The return value is:
 *		PASSED   - all values are in the set {ZERO, ONE}
 *		BINERROR - at least one value is not in the set {ZERO, ONE}
 */

#include "lib.h"
#include <stdio.h>
#include "uarp.h"
#include "libarp.h"

int
fckbin(

register int	*array,		/* Ptr to array of "bits".	*/
register int	msb,		/* Array index of MSB.		*/
register int	lsb)		/* Array index of LSB.		*/

{


	register int	dir;
	register int	retval;

	retval = PASSED;

	dir = DIR(msb,lsb);

	while ( msb != lsb )
	{
	    switch( array[lsb] )
	    {
		case ZERO:
		case ONE:
			break;

		case UNDEF:
		case FLOAT:
		default:
			/*
			fprintf(stderr,
"WARNING: Bit #%d has the value `%d'. (Not in the set {0,1}.)\n",
				lsb, array[lsb]);
			*/
			retval = BINERROR;
			break;
	    }
	    lsb += dir;
	}/* end while() */

	switch ( array[lsb] )		/* now (lsb == msb ) */
	{
		case ZERO:
		case ONE:
			break;

		case UNDEF:
		case FLOAT:
		default:
/*
			fprintf(stderr,
"WARNING: Bit #%d has the value `%d'. (Not in the set {0,1}.)\n",
				 lsb, array[lsb]);
*/
			retval = BINERROR;
			break;
	}

	return( retval );
}
/* TEST**********TEST**********TEST**********TEST */
#ifdef TEST
#define SIZE 8
main(int argc, char *argv[])
{
int arout[SIZE];
/* {lsb,,,,,msb} */
static int arin1[] = {1,1,1,1,0,0,0,0};
static int answ[]  = {0,0,0,1,1,1,1,0};
int number = 0x0;
int 	msb1	= 7,
		lsb1	= 0
	;
int rval = 0;
int i,pvaro;
int	iflag = TRUE;
char c;
int fckbin();

FDUMPOFF;
while (iflag == TRUE)
{
	if (argc > 1)
	{
		/* interactive session */
		printf("Checking binary value of group1 \n");
		printf("Enter msb, lsb for group1:");
		scanf("%d,%d",&msb1,&lsb1);
		fgetval(arin1,msb1,lsb1);
	} else
		iflag = FALSE;

	pvaro = fckbin(arin1,msb1,lsb1);
	
	printf("errorcode = %d\n",pvaro);
	if (pvaro == BINERROR)
		printf("BINERROR was returned.\n");

	ferr(pvaro," TEST");
	printf("group1\n");
	fprval(arin1,msb1,lsb1);
	if (iflag == FALSE)
	{
		printf("\n\nEND of TEST\n");
	}
	/* end of test */
	if (argc > 1)
	{
		rval = 0;
		printf("Continue with test (y or n)? ");
		getchar();
		if ((c=getchar()) == 'y' || c == 'Y')
		{
			bzero(arout,sizeof(arout));
			iflag = TRUE;
		}
		else
			iflag = FALSE;
	}
}
exit(rval);
}
#endif


/* Overloaded definition for Ptolemy interface */

int
fckbin(

MultiThorPort  &array,		/* Ptr to array of "bits".	*/
register int	msb,		/* Array index of MSB.		*/
register int	lsb)		/* Array index of LSB.		*/

{


	register int	dir;
	register int	retval;

	retval = PASSED;

	dir = DIR(msb,lsb);

	while ( msb != lsb )
	{
	    switch((int)array[lsb])
	    {
		case ZERO:
		case ONE:
			break;

		case UNDEF:
		case FLOAT:
		default:
			/*
			fprintf(stderr,
"WARNING: Bit #%d has the value `%d'. (Not in the set {0,1}.)\n",
				lsb, array[lsb]);
			*/
			retval = BINERROR;
			break;
	    }
	    lsb += dir;
	}/* end while() */

	switch ((int)array[lsb])		/* now (lsb == msb ) */
	{
		case ZERO:
		case ONE:
			break;

		case UNDEF:
		case FLOAT:
		default:
/*
			fprintf(stderr,
"WARNING: Bit #%d has the value `%d'. (Not in the set {0,1}.)\n",
				 lsb, array[lsb]);
*/
			retval = BINERROR;
			break;
	}

	return( retval );
}
