static const char file_id[] = "csimenv.cc";
/**************************************************************************
Version identification:
@(#)csimenv.cc	1.5	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Anders Wass
 Date of creation: 2/11/91
 Description:
**************************************************************************/

/*
 * csimenv.cc - define csim environment for C++ code
 *
 * usage:
 *	extern void csimenv(char*&,char*&,char*&);
 *	char *lib, *bin, *inc;
 *	csimenv(lib, bin, inc);
 *
 * Returns to the caller by reference strings defining directories in which
 * csim library, binary, and include files can be found, by interrogating
 * environment variables defined in the header file.
 * 
 * If an environment variable is defined, its argument is set to that value.
 * If it is not defined, and environment variable CSIM is defined, the
 * argument is set to the concatenation of the root and an appropriate suffix.
 * If CSIM is not defined, the variables are set to the defaults contained
 * in #defines.
 *
 * With the current defines, the results would be:
 * `getenv CSIMLIB` or `getenv CSIM`/lib or /projects/cad/lib/csim.
 * `getenv CSIMBIN` or `getenv CSIM`/bin or /projects/cad/bin.
 * `getenv CSIMINCLUDE` or `getenv CSIM`/include
 *                      or /projects/cad/lib/csim/include.
 */
#include <string.h>
//#include "/usr/tools/lager/common/cad/src/thor/include/csimenv.h"
#include "csimenv.h"
#include "logNew.h"

#define MXLEN	256


/*
 * stralloc() - make a copy of string s and return a pointer to the copy
 */
static char *stralloc(char* s)
{
    if (s == 0) return 0;

    LOG_NEW; char* t = new char [strlen(s) + 1];
    strcpy(t,s);
    return(t);
}

/*
 * strab() - return a pointer to the concatenation of strings a and b
 */
static char *strab(char* a, char* b)
{
    char s[MXLEN];

    strcpy(s,a);
    strcat(s,b);
    return(stralloc(s));
}

extern "C" char* getenv(const char*);

/*
 * myget() - build a string from the environment
 */
static char *myget(char* env, char* root, char* sub, char* def)
{

    char* s = getenv(env);
    return((s) ? s : (root ? strab(root, sub) : def));
}


void csimenv(char* &lib, char* &bin, char* &inc) 
{
    char* c = getenv(GROUP_ENV);

    lib = myget(LIB_ENV, c, "/lib", LIB_DEF);
    bin = myget(BIN_ENV, c, "/bin", BIN_DEF);
    inc = myget(INC_ENV, c, "/include", INC_DEF);
}


#ifdef DEBUG
#include <ostream.h>
main()
{
    char *lib, *bin, *inc;

    cout << "\ncsimenv will use and return the contents "
	 << "of environment variables like this:\n\n";
    cout << form("  bin:     $%s || $%s/bin || %s\n",
		 BIN_ENV, GROUP_ENV, BIN_DEF);
    cout << form("  lib:     $%s || $%s/lib || %s\n",
		 LIB_ENV, GROUP_ENV, LIB_DEF);
    cout << form("  include: $%s || $%s/include || %s\n\n",
		 INC_ENV, GROUP_ENV, INC_DEF);
    csimenv(lib,bin,inc);
    cout << form("return of csimenv (present settings):\n\n");
    cout << form("  bin: %s\n  lib: %s\n  inc: %s\n\n",
		 bin, lib, inc);
}
#endif
