/* 
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef _ThorWormhole_h
#define _ThorWormhole_h 1
#ifdef __GNUG__
#pragma interface
#endif

///////////////////////////////////////////////////////////////////////////
//
// Version identification:
// @(#)ThorWormhole.h	1.12 3/16/93
//
// Copyright  (c) 1990	The Regents of the University of California,
//				All Rights Reserved.
//
// Programmer:	Seungjun Lee
// Created:	12/03/90
// Revisions:	
//
// Description:
// ------------
//	This file is adopted from the file DEWormhole.h v1.7 written by
//	Soonhoi Ha. It is modified to deal with Thor domain.
//
///////////////////////////////////////////////////////////////////////////

// hack to take care of conflicting use of "FLOAT" by Thor
#undef FLOAT
#include "Wormhole.h"
#include "EventHorizon.h"
#include "ThorPortHole.h"
#define FLOAT 3
#include "ThorStar.h"
#include "Target.h"

	//////////////////////////////
	// ThorWormhole
	//////////////////////////////

class ThorWormhole : public Wormhole, public ThorStar {

public:

     void setup() { Wormhole :: setup(); }
     void go();
     void wrapup() { target->wrapup(); }

     // constructor
     ThorWormhole(Galaxy &g,Target* t = 0) : Wormhole(*this,g,t)
         { buildEventHorizons (); }

     // destructor
     ~ThorWormhole() { freeContents();}

     // print method
     StringList print(int verbose) const { return Wormhole::print(verbose);}

     // clone -- allows interpreter to make copies
     Block* clone() const;
     Block* makeNew() const;

     // return my scheduler
     Scheduler* scheduler() const { return target->scheduler();}

     // identify myself as a wormhole
     int isItWormhole() const { return TRUE;}

     // use statelist for inner galaxy for stateWithName
     State* stateWithName (const char* name) {
                return gal.stateWithName(name);
     }

     // state initialize
     void initState() { gal.initState() ;}

protected:
     // redefine getStopTime();
     double getStopTime() { return (double) getCurTime(); }

     // redefine sumUp()
     void sumUp();
};


        //////////////////////////////////////////
        // class ThortoUniversal
        //////////////////////////////////////////


// Input Boundary of ??inThor_Wormholes.
class ThortoUniversal : public ToEventHorizon, public InThorPort
{
public:
	// constructor
	ThortoUniversal(): ToEventHorizon(this) {}

	void receiveData(); 
	void initialize();

	int isItInput() const;
	int isItOutput() const;

	// as Eventhorizon
	EventHorizon* asEH();
};

        //////////////////////////////////////////
        // class ThorfromUniversal
        //////////////////////////////////////////

// Output Boundary of ??inThor_Wormholes.
class ThorfromUniversal : public FromEventHorizon, public OutThorPort
{
public:
	// constructor
	ThorfromUniversal(): FromEventHorizon(this) {}
	
	void sendData();
	
	void initialize();
	
	int isItInput() const;
	int isItOutput() const;
	
	// as Eventhorizon
	EventHorizon* asEH();
};

#endif
