/* 
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
*/
static const char file_id[] = "ThorVec.cc";
///////////////////////////////////////////////////////////////////////////
//
// Version identification:
// @(#)ThorVec.cc	1.3 11/25/92
//
// Programmer: Seungjun Lee
// Created:    2/18/91
// Revision:
//
// Def'ns of TABLE LOOK-UP arrays for simple logic operations	*/
//	tables are set up for 4-state logic {0,1,U,Z}		*/
//	where:	0==0, 1==1, U==2, Z==3				*/
//
///////////////////////////////////////////////////////////////////////////



#define	RCSID "$Header: vec.c,v 1.1 86/10/15 13:13:11 burr Exp $"

int ThorVfall[4][4] =		/* edge-detection array	*/
{	/* new ck */
/* old ck */	{ 0, 0, 0, 0},	/*  0 = no fall	(i.e. falls  or no change) */
		{ 1, 0,-1,-1},	/*  1 = fall	*/
		{-1, 0,-1,-1},	/* -1 = potential fall	*/
		{-1, 0,-1,-1}
};

int ThorVrise[4][4] =		/* edge-detection array	*/
{	/* new ck */
/* old ck */	{0, 1,-1,-1},	/*  0 = no rise	(i.e. rises  or no change) */
		{0, 0, 0, 0},	/*  1 = rise	*/
		{0,-1,-1,-1},	/* -1 = potential rise	*/
		{0,-1,-1,-1}
};

int ThorVinv[4] = {1,0,2,2};		/* 2-input INV gate	*/

int ThorVmap[4] = {0,1,2,2};		/* maps HI_Z to UNKNOWN	*/

int ThorVand[4][4] =		/* 2-input AND gate	*/
{
	{0,0,0,0},
	{0,1,2,2},
	{0,2,2,2},
	{0,2,2,2}
};
int ThorVnand[4][4] =		/* 2-input NAND gate	*/
{
	{1,1,1,1},
	{1,0,2,2},
	{1,2,2,2},
	{1,2,2,2}
};
int ThorVor[4][4] =			/* 2-input OR gate	*/
{
	{0,1,2,2},
	{1,1,1,1},
	{2,1,2,2},
	{2,1,2,2}
};
int ThorVnor[4][4] =		/* 2-input NOR gate	*/
{
	{1,0,2,2},
	{0,0,0,0},
	{2,0,2,2},
	{2,0,2,2}
};
int ThorVxor[4][4] =		/* 2-input EXCLUSIVE-OR gate	*/
{
	{0,1,2,2},
	{1,0,2,2},
	{2,2,2,2},
	{2,2,2,2}
};
int ThorVxnor[4][4] =		/* 2-input EXCLUSIVE-NOR gate	*/
{
	{1,0,2,2},
	{0,1,2,2},
	{2,2,2,2},
	{2,2,2,2}
};
int ThorVtbuf[4][4] =		/* tristate non-inverting buffer */
{	/* tri-input */			/* vtbuf[en][dat]	*/
/* tri enable*/	{3, 3, 3, 3},
		{0, 1, 2, 2},
		{2, 2, 2, 2},
		{2, 2, 2, 2}
};
int ThorVtbufi[4][4] =		/* tristate inverting buffer */
{	/* tri-input */
/* tri enable*/	{3, 3, 3, 3},
		{1, 0, 2, 2},
		{2, 2, 2, 2},
		{2, 2, 2, 2}
};
int ThorVtgate[4][4] =	/* CMOS "transmission" gate w/ complementary enables   */
{	/* enable */
/*  enable^*/	{1, 1, 1, 1},
		{0, 1, 2, 2},
		{2, 1, 2, 2},
		{2, 1, 2, 2}
};
