/* 
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
*/
#ifndef _ThorState_h
#define _ThorState_h 1
#ifdef __GNUG__
#pragma interface
#endif

#include "IntState.h"
#include "IntArrayState.h"


///////////////////////////////////////////////////////////////////////////
//
// Version identification:
// @(#)ThorState.h	1.6 11/25/92
//
// Programmer: Seungjun Lee
// Created:    10/30/90
// Revision:
//
// Definitions of States in Thor Domain
//
///////////////////////////////////////////////////////////////////////////


class ThorState : public IntState {
public:
	// constructor
	ThorState() { thorVal = NULL; }

	// parse initValue to set value
	void initialize();

	// method setting internal data in the state
	State& setThorState(const char* stateName, Block* parent, 
			const char* ivalue, int* value);

private:
	// pointer to integer state in Thor
	int* thorVal;
};

class MultiThorState : public IntArrayState {
public:
	State& setThorState ( const char* stateName, Block* parent, int width);
	operator int*() { return val; }
};

#endif
