/* 
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
*/
static const char file_id[] = "ThorState.cc";
///////////////////////////////////////////////////////////////////////////
//
// Version identification:
// @(#)ThorState.cc	1.5 11/25/92
//
// Programmer: Seungjun Lee
// Created:    11/2/90
// Revision:
//
// Functions for States in Thor Domain
//
///////////////////////////////////////////////////////////////////////////

#ifdef __GNUG__
#pragma implementation
#endif

#include "ThorState.h"

///////////////////////////////////////////////////////////////////////////
//
//   Class ThorState
//
///////////////////////////////////////////////////////////////////////////

void ThorState :: initialize() {
	IntState::initialize();
	*thorVal = int(*this);
}

State& 
ThorState :: setThorState(const char* stateName, Block* parent, 
			const char* ivalue, int* value){
	thorVal = value;
	return setState(stateName, parent, ivalue);
}



///////////////////////////////////////////////////////////////////////////
//
//   Class MultiThorState
//
///////////////////////////////////////////////////////////////////////////

State& 
MultiThorState :: setThorState ( const char* stateName, Block* parent, int width){
	LOG_NEW; char* ival = new char[width*2];
	char* ch = ival;
	for (int i = 0; i < width; i++){
		*ch++ = '0';
		*ch++ = ' ';
	}
	*(--ch) = '\0';
	return setState(stateName, parent, ival);
}

