/* 
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef _ThorStar_h
#define _ThorStar_h 1
#ifdef __GNUG__
#pragma interface
#endif

///////////////////////////////////////////////////////////////////////////
//
// Version identification:
// @(#)ThorStar.h	1.11 11/25/92
//
// Copyright  (c) 1990	The Regents of the University of California,
//				All Rights Reserved.
//
// Programmer:	Anders Wass
// Created:	06/14/90
// Revisions:	Seungjun Lee
//		07/17/90  - deleted all GenT**Stars so
//			    every star is derived from ThorStar.
//              12/03/90  - add flag to avoid multiple scheduling
//			    refine member functions
//
// Description:
// ------------
//	Contains the definitions of basic stars in a the `Thor' Universe.
//
///////////////////////////////////////////////////////////////////////////

#include "ThorPortHole.h"
#include "Star.h"
#include "Thor.h"

// The following is defined in ThorSchedule.cc -- this forces that module
// to be included if any Thor star is linked in.
extern const char ThordomainName[];

class  TimeWheel;

class ThorStar : public Star {
private:
   TimeType*	currentTime;
   int		numOfInputs;
   int		numOfOutputs;
   int		numOfBiputs;
   int		numOfStates;
   int          scheduled;

public:
   // initialize domain-specific members
   void prepareForScheduling(); // {}

   TimeWheel   *timeWheel;

   int isA(const char*) const;
   const char*	domain() const;
   Block&	setBlock (const char* starName, Block* parent = 0);

   virtual int	isItModel (); // { return FALSE; }
   virtual int	isItGenerator (); // { return FALSE; }
   virtual int	isItMonitor (); // { return FALSE; }

   void		setCurTime(TimeType& time) { currentTime = &time; }
   TimeType	getCurTime() { return *currentTime; }
   int		getInCount() { return numOfInputs; }
   int		getOutCount() { return numOfOutputs; }
   int		getBiCount() { return numOfBiputs; }
   int		getStCount() { return numOfStates; }
   void		setInCount(int i) { numOfInputs = i; }
   void		setOutCount(int i) { numOfOutputs = i; }
   void		setBiCount(int i) { numOfBiputs = i; }
   void		setStCount(int i) { numOfStates = i; }
   void		incInCount() { ++numOfInputs; }
   void		incOutCount() { ++numOfOutputs; }
   void		incBiCount() { ++numOfBiputs; }
   void		incStCount() { ++numOfStates; }
   int		decInCount() { return --numOfInputs; }
   int		decOutCount() { return --numOfOutputs; }
   int		decBiCount() { return --numOfBiputs; }
   int		decStCount() { return --numOfStates; }
   void         setScheduled() { scheduled = TRUE; }
   void         resetScheduled() { scheduled = FALSE; }
   int          isStarScheduled() { return scheduled; }
   
};	// class ThorStar

#endif
