/* 
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
*/
static const char file_id[] = "ThorStar.cc";
// This may look like C code, but it is really -*- C++ -*-

///////////////////////////////////////////////////////////////////////////
//
// Version identification:
// @(#)ThorStar.cc	1.11 11/25/92
//
// Copyright  (c) 1990	The Regents of the University of California,
//				All Rights Reserved.
//
// Programmer:	Anders Wass
// Created:	06/22/90
// Revisions:	07/17/90  - Moved operator!=() from here to NodeStar.cc
//
// Description:
// ------------
//	Contains implementations of functions defined in ThorStar.h
//	and the comparison rule for logic values between the element
//	star outputs and the current value of the corresponding node stars.
//
///////////////////////////////////////////////////////////////////////////

#ifdef __GNUG__
#pragma implementation
#endif
#include "ThorStar.h"

// Small virtual functions
void ThorStar :: prepareForScheduling () {}
int ThorStar :: isItModel () { return FALSE; }
int ThorStar :: isItGenerator () { return FALSE; }
int ThorStar :: isItMonitor () { return FALSE; }

// For Analyzer interface
//extern int Force_anaLink();  // declare analyzer entry.
//extern int Force_banaLink(); // declare banalyzer entry.
//static int fal__ = Force_anaLink();  // Force analyzer to be linked in ...
//static int fbl__ = Force_banaLink(); // Force banalyzer to be linked in ...


// Redefine method setting internal data in the Block
// so that various Thor-specific initilizations can be performed.
// If the parent pointer is not provied, it defaults to NULL
Block& ThorStar :: setBlock(const char* s, Block* parent) {
   // First invoke the generic setBlock
   Block::setBlock(s,parent);

   numOfInputs = 0;
   numOfOutputs = 0;
   numOfBiputs = 0;
   numOfStates = 0;
   scheduled = FALSE;

   return *this;
}

// identify my domain
const char*
ThorStar :: domain() const {return ThordomainName;}

// identify my inheritance hierarchy
ISA_FUNC(ThorStar,Star);
