/****************************************************************************
 * SCCS Version identification :
 * @(#)ThorPrint.h	1.5 11/25/92
 *
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
 *
 * Programmer: Anders Wass
 * Date of creation:	5/13/91
 * Modification:	6/7/91	Anders Wass
 *				Added a string buffer that holds the
 *				messages for stderr that comes from a star.
 *				This buffer is accessable by the
 *				ThorErrHandler methods.
 *
 * This header file defines the interface for error reporting inside the Thor
 * models. It is using the Error class to generate errors
 * and find the appropriate streams to use for the output messages.
 *
 *****************************************************************************/
#ifndef _ThorError_h
#define _ThorPrint_h 1

#include "Error.h"

class ThorPrint {
private:
    static char errMsgBuf[BUFSIZ];
public:
		 ThorPrint() { errMsgBuf[0] = '\0'; }
		 ~ThorPrint() { }
    static char* getErrMsgBuf() { return errMsgBuf; }
    
    // these methods captures some function calls for printing to standard
    // io.
    static void Thor_fprintf(FILE*,const char*,...);
    static void Thor_printf(const char*,...);
    static void Thor_fputs(const char* str, FILE* fp);
};

#endif
