/* 
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef _ThorPortHole_h
#define _ThorPortHole_h 1
#ifdef __GNUG__
#pragma interface
#endif

///////////////////////////////////////////////////////////////////////////
//
// Version identification:
// @(#)ThorPortHole.h	1.18	11/25/92
//
// Copyright  (c) 1990	The Regents of the University of California,
//				All Rights Reserved.
//
// Programmer:	Anders Wass
// Created:	06/13/90
// Revisions:	Seungjun Lee
// Date:	08/01/90
//		Overload connect mothod to support new Node structure
//		08/15/90
//		Provide ThorMultiPort a random access
//
// Description:
// ------------
//	This file contains the structure types that connects the different
//	ThorStars. The types here are all inherited from the basic types
//	used in pTolemy for connecting stars. All members in these new
//	classes becomes public if they are inherited into a derived class.
//	This is made by using `protected' rather then `private'. However,
//	direct access outside the class scope will still act like they were
//	`private'. The classes defined in this file looks much like the
//	classes in the DEPortHole.h, but since there are some differences in
//	how signals are processed classes that were indenpendent were
//	preferred.
//
///////////////////////////////////////////////////////////////////////////

#include "PortHole.h"		// include all basic pTolemy definitions
#include "Particle.h"

typedef int TimeType;		// Should this be int or double ???

class ThorNode;
class CircularBuffer;

//////////////////////////////////
//	class ThorPortHole
//////////////////////////////////

class ThorPortHole : public PortHole {
   friend class ThorNode;
public:
   TimeType 	timeStamp;
   TimeType     delay;          // User specified output delay

   // `setPort' is redefined to initialize ThorPortHole members as well.
   PortHole&	setPort (const char* portname,
			 Block* parent,
			 DataType type = INT
			 );

   // Override GenericPort::connect
   void         connect(GenericPort& destination,int outDelay);

   // modify the geodesic
   void setNode(ThorNode* node); // { myGeodesic = node;}

   // For input porthole, get a particle from the node
   Particle&	getNodeParticle();
   // For output porthole, get a particle from the buffer
   Particle&	getBuffParticle();

   void         putParticle() { PortHole::putParticle(); }

   // Operator overloading for direct interface with CHDL
   virtual operator int(); 
   int operator = (const int value) {
	   getBuffParticle() << value; return value;
   }

   // return myGeodesic as a ThorNode
   ThorNode* node() { return (ThorNode*)myGeodesic;}

   friend int	notEqual(PortHole& ph, ThorNode& node);
   friend int	equal(PortHole& ph, ThorNode& node);
};	// class ThorPortHole


//////////////////////////////////
//	class InThorPort
//////////////////////////////////

class InThorPort : public ThorPortHole {
public:
   int		isItInput () const; // { return TRUE; }
};	// class InThorPort


//////////////////////////////////
//	class OutThorPort
//////////////////////////////////

class OutThorPort : public ThorPortHole {
public:
   int		isItOutput () const; // { return TRUE; }

   // Operator overloading for direct interface with CHDL
   virtual operator int(); 
   int operator = (const int value) {
	   getBuffParticle() << value; return value;
   }
};	// class OutThorPort


//////////////////////////////////
//	class BiThorPort
//////////////////////////////////

class BiThorPort : public ThorPortHole {
public:
   int		isItInput () const; // { return TRUE; }
   int		isItOutput () const; // { return TRUE; }

   // Operator overloading for direct interface with CHDL
   int operator = (const int value) { getBuffParticle() << value; return value; }
};	// class BiThorPort


//////////////////////////////////
//	class MultiThorPort
//////////////////////////////////

class MultiThorPort : public MultiPortHole
{
public:
   MultiPortHole&	setPort(const char* portName,
				Block* parent,
				DataType type = INT) { 
      return MultiPortHole::setPort(portName, parent, type);  }

   // initialize pointer array for random access
   void initialize();

   // Override GenericPort::connect
   void         connect(GenericPort& destination,int =1);

   // Overload MultiPortHole::newConnection();
   virtual PortHole& newConnection();

   // overload index operator to access corresponding PortHole
   ThorPortHole& operator [] (int index){
      return (ThorPortHole&)*array[index];
   }
   // overload operator to interface with library functions
   operator int*();

private:
   ThorPortHole **array;
   int*           intArray;   
};	// class MultiThorPort


//////////////////////////////////
//	class MultiInThorPort
//////////////////////////////////

class MultiInThorPort : public MultiThorPort
{
public:
   int		isItInput () const; // { return TRUE; }

   // add a new physical port to the MultiPortHole ...
   PortHole&	newPort ();
};	// class MultiInThorPort


//////////////////////////////////
//	class MultiOutThorPort
//////////////////////////////////

class MultiOutThorPort : public MultiThorPort
{
public:
   int		isItOutput () const; // { return TRUE; }

   // add a new physical port to the MultiPortHole ...
   PortHole&	newPort ();
};	// class MultiOutThorPort


//////////////////////////////////
//	class MultiBiThorPort
//////////////////////////////////

class MultiBiThorPort : public MultiThorPort
{
public:
   int		isItInput () const; // { return TRUE; }
   int		isItOutput () const; // { return TRUE; }

   // add a new physical port to the MultiPortHole ...
   PortHole&	newPort ();
};	// class MultiBiThorPort

#endif
