/* 
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
*/
static const char file_id[] = "ThorPortHole.cc";
///////////////////////////////////////////////////////////////////////////
//
// Version identification:
// @(#)ThorPortHole.cc	1.16	11/25/92
//
// Copyright  (c) 1990	The Regents of the University of California,
//				All Rights Reserved.
//
// Programmer:	Anders Wass
// Created:	06/18/90
// Revisions:	Seungjun Lee
// Date:	08/01/90
//		connect() is overridden to simplyfy message passing.
//		Plasma is removed and Geodesic is replaced by ThorNode
//              08/17/90
//	 	MultiPortHole allows random access
//
// Description:
// ------------
//	Contains functions used by classes in ThorPortHole.h. At this moment
//	the functions are almost identical to the functions in DEPortHole.cc
//	(DEPortHole.{h,cc} are written by Soonhoi Ha.)
///////////////////////////////////////////////////////////////////////////

#ifdef __GNUG__
#pragma implementation
#endif

#include "CircularBuffer.h"
#include "ThorPortHole.h"
#include "ThorStar.h"
#include "ThorNode.h"

/////////////////////////////////////////////
//	members of class ThorPortHole
/////////////////////////////////////////////

// Modify geodesic to point to a new node
void ThorPortHole :: setNode(ThorNode* n)
{
   myGeodesic = n;
}

// The overridden connect method

#define SOURCE  1
#define DEST    2

void ThorPortHole :: connect(GenericPort& destination,int numberDelays)
{
   // Resolve any aliases and MultiPortHole stuff;
   // newConnection is a virtual function that does the right
   // thing for all types of PortHoles
   ThorPortHole& realSource = (ThorPortHole&) newConnection();
   ThorPortHole& realDest = (ThorPortHole&) destination.newConnection();

   // See if either port is connected to a node
   ThorNode* n = realSource.node();
   int flag;

   if (n)
      flag = SOURCE;
   else{
      n = realDest.node();
      if (n)
         flag = DEST;
      else{
         LOG_NEW; n = new ThorNode(type());
         flag = 0;
      }
   }

   if (flag != SOURCE){
      realSource.myGeodesic = n;

      // Append port to portlist of ThorNode
      // Biput port is added to both input list and output list
      if (realSource.isItInput())
         n->outputs.put(&realSource);
      if (realSource.isItOutput())
         n->inputs.put(&realSource);
   }

   if (flag != DEST){
      realDest.myGeodesic = n;

      if (realDest.isItInput())
         n->outputs.put(&realDest);
      if (realDest.isItOutput())
         n->inputs.put(&realDest);
   }
   
   // Set the farSidePort pointers in both blocks
   // Doesn't have much meaning in Thor domain
   realSource.farSidePort = &realDest;
   realDest.farSidePort = &realSource;

   // Set the output delay
   realSource.delay = numberDelays;
   return;
}

Particle& ThorPortHole :: getNodeParticle()
{ 
     return *node()->getParticle();
}

Particle& ThorPortHole :: getBuffParticle()
{ 
     return *((Particle*) *(myBuffer->here()));
}

ThorPortHole :: operator int()
{			     
   // Return the value from the node...
   return (int) getNodeParticle();
}


PortHole& ThorPortHole ::
setPort (const char* portname, Block* parent, DataType type)
{
   // initialize the port hole
   PortHole::setPort(portname, parent, type);

   // initialize my own members
   timeStamp = 0;
   delay = 0;

   return *this;
}


/////////////////////////////////////////////
//	members of class InThorPort
/////////////////////////////////////////////

int InThorPort :: isItInput () const { return TRUE; }

/////////////////////////////////////////////
//	members of class OutThorPort
/////////////////////////////////////////////

int OutThorPort :: isItOutput () const { return TRUE; }

// Overload the int() operator for output porthole
OutThorPort :: operator int()
{
   // Return the value from the buffer...
      return (int) getBuffParticle();
}

/////////////////////////////////////////////
//	members of class BiThorPort
/////////////////////////////////////////////

// short virtual functions

int BiThorPort :: isItInput () const { return TRUE; }
int BiThorPort :: isItOutput () const { return TRUE; }

/////////////////////////////////////////////
//	members of class MultiThorPort
/////////////////////////////////////////////

void MultiThorPort :: initialize()
{
   MultiPortHole::initialize();
   int size = numberPorts();
   LOG_NEW; array = new ThorPortHole*[size];
   LOG_NEW; intArray = new int[size];

   MPHIter nexti(*this);
   for (int i = 0; i < size; i++)
      array[i] = (ThorPortHole*) nexti++; 
}

void MultiThorPort :: connect(GenericPort& destination,int numberDelays)
{
   ThorPortHole& realSource = (ThorPortHole&) newConnection();
   realSource.connect(destination, numberDelays);
}

// Return a PortHole for a new connection. Don't check for 
// unconnected PortHole.  Always make a new one.

PortHole& MultiThorPort :: newConnection() {
        // resolve aliases
        if (alias()) return realPort().newConnection();

        // find an unconnected porthole
        //ports.reset();
        //for (int i = ports.size(); i > 0; i--) {
        //        PortHole& p = ports++;
        //        if (p.far() == NULL) return p;
        //}

        // no disconnected ports, make a new one.
        return newPort();
}


MultiThorPort :: operator int*()
{
   for (int size=numberPorts(); size>0; size--)
      intArray[size-1] = int(*array[size-1]);

   return intArray;
}

/////////////////////////////////////////////
//	members of class MultiInThorPort
/////////////////////////////////////////////

int MultiInThorPort :: isItInput () const { return TRUE; }

PortHole& MultiInThorPort :: newPort ()
{
   LOG_NEW; return installPort(*new InThorPort);
}

/////////////////////////////////////////////
//	members of class MultiOutThorPort
/////////////////////////////////////////////

int MultiOutThorPort :: isItOutput () const { return TRUE; }

PortHole& MultiOutThorPort :: newPort ()
{
   LOG_NEW; return installPort(*new OutThorPort);
}

/////////////////////////////////////////////
//	members of class MultiBiThorPort
/////////////////////////////////////////////

int MultiBiThorPort :: isItInput () const { return TRUE; }
int MultiBiThorPort :: isItOutput () const { return TRUE; }

PortHole& MultiBiThorPort :: newPort ()
{
   LOG_NEW; return installPort(*new BiThorPort);
}

//	<EOF:ThorPortHole.cc>
