/* 
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
*/
#ifndef _ThorNode_h
#define _ThorNode_h 1
#ifdef __GNUG__
#pragma interface
#endif

///////////////////////////////////////////////////////////////////////////
//
// Version identification:
// @(#)ThorNode.h	1.14 11/25/92
//
// Copyright  (c) 1990	The Regents of the University of California,
//				All Rights Reserved.
//
// Programmer:	Seungjun Lee
// Created:	08/03/90
// Revisions:	11/13/90
//		modified to support netlist connection
//
// Description:
// ------------
//	ThorNode is a structure corresponding to a net.
//	It evaluates the incomming particles from the element stars
//	and reschedule the elements until this node has stabilisized.
//	It is implemented as an intelligent geodesic which has multiple 
//	inputs and multiple outputs, and value resolving methode in it.  
//	It keeps the record of changes on the net so that stars 
//	connected to the net can examine its input changes in its 
//	go() function.
//
///////////////////////////////////////////////////////////////////////////

#include "Geodesic.h"

class ThorNode : public Geodesic {
private:
   Particle	*nodeValue;
   int		hasChanged;
   int          scheduled;

public:
   // overloaded to provide multi-in, multi-out geodesic
   PortHole* setSourcePort (GenericPort &, int delay = 0);
   PortHole* setDestPort (GenericPort &);

   // list of input portholes and output portholes.
   // biput portholes are included in inputs and outputs
   SequentialList inputs, outputs;

   ThorNode (DataType typ=INT);	// Constructor
   ~ThorNode();                     // Destructor

   // TRUE means it is a netlist connection
   int isItPersistent() const;

   // initialize the value of the node
   void		initialize();

   int		getNodeValue () { return (int)*nodeValue; }
   void		setNodeValue (int val) { *nodeValue << val; }
   Particle*	getParticle () { return nodeValue; }
   int		nodeHasChanged () { return hasChanged; }
   void		setNodeHasChanged () { hasChanged = 1; }
   void		clrNodeHasChanged () { hasChanged = 0; }
   int          isNodeScheduled() { return scheduled; }
   void         setScheduled() { scheduled = TRUE; }
   void         resetScheduled() { scheduled = FALSE; }

   friend int	notEqual(PortHole& ph, ThorNode& node);
   friend int	equal(PortHole& ph, ThorNode& node);

   void		resolve ();	// resolve the value of the node
   void		wrapup () {}	// collect node statistics if any

};	// class ThorNode

#endif
