/* 
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
*/
#ifndef _Thor_h
#define _Thor_h 1


///////////////////////////////////////////////////////////////////////////
//
// Version identification:
// @(#)Thor.h	1.10 11/25/92
//	
// Programmer: Seungjun Lee
// Created:    6/18/90
// This file is modified by Anders Wass (awa) 07/16/90.
//
// Common user information for THOR.
// This file is the integration of "model.h", "vec.h", and "esimerror.h"
//
///////////////////////////////////////////////////////////////////////////


/* table look-up arrays */
extern int ThorVfall[][4];
extern int ThorVrise[][4];
extern int ThorVand[][4];
extern int ThorVinv[];
extern int ThorVmap[];
extern int ThorVnand[][4];
extern int ThorVnor[][4];
extern int ThorVor[][4];
extern int ThorVxnor[][4];
extern int ThorVxor[][4];
extern int ThorVtbuf[][4];
extern int ThorVtbufi[][4];

#define vfall  ThorVfall
#define vrise  ThorVrise
#define vand   ThorVand
#define vinv   ThorVinv
#define vmap   ThorVmap
#define vnand  ThorVnand
#define vnor   ThorVnor
#define vor    ThorVor
#define vxnor  ThorVxnor
#define vxor   ThorVxor
#define vtbuf  ThorVtbuf
#define vtbufi ThorVtbufi

/* values */
#define ZERO 0
#define ONE 1
#define UNDEF 2
#define FLOAT 3

/* self schedule priorities */
#define SELF0	0
#define SELF1	1

/* returns name of input,output,biput */
// defined as a member function of analyzer
//char *iobname(int, int);
#define CINPUT 1
#define COUTPUT 2
#define CBIPUT 3

/*
error code definitons for models and group stuff.
*/

/* group error codes */

#define	MINUS	0x80000000	/* sets msb to 1. assumes 32 bit */
#define PASS      0
#define PASSED    0
#define VALUEERROR (MINUS|8)	/*#3  bit value not in the set {0,1,2,3}*/ 
#define RANGEERROR (MINUS|16)	/*#4 msb-lsb do not match for two arrays*/ 
#define MSIZEERROR (MINUS|32)	/*#5 abs(msb-lsb) > MAXBUSLEN_		*/
#define BINERROR   (MINUS|64)	/* bit value not in the set {0,1}	*/
#define FAIL      (MINUS|128)	/*#7 general failure */
#define FAILED    (MINUS|128)
#define UNDEFERROR (MINUS|256)	/*#8 UNDEF found when not expected	*/
#define FLOATERROR (MINUS|512)	/*#9 FLOAT found when not expected	*/


#define EXITMOD(x) return

/* Added macro to support Ptolemy */
class ThorStar;
void schedStar(TimeType, int, ThorStar*);
void selfSched(TimeType, int, ThorStar*);
void selfUnsched(TimeType, ThorStar*);
void schedOut(TimeType, int, ThorPortHole*);

#define OUT_COUNT getOutCount()
#define IN_COUNT getInCount()
#define BI_COUNT getBiCount()
#define ST_COUNT getStCount()
#define self_sched(x,y) selfSched(x,y,this)
#define self_unsched(x) selfUnsched(x,this)

#define current_time (getCurrentTime())
TimeType getCurrentTime();

/* returns username of model */
const char* mname();

/* Macro added due to the compiler bug */
#ifdef __GNUG__
#ifndef switch
#define switch(x) switch(int(x))
#endif
#endif

#endif
