static const char file_id[] = "StrBuf.cc";
/************************************************************************
 * SCCS Version identification :
 * @(#)StrBuf.cc	1.5 11/25/92
 *
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
 *
 * Programmer: Anders Wass
 * Date of creation:    6/11/91
 *
 * Description:
 *	This file defines the methods of the class defined in
 *	file StrBuf.h
 *
 ************************************************************************/

#include "StrBuf.h"
#include "logNew.h"
#include <string.h>
#include <ctype.h>

StrBuf :: StrBuf()
{
    smbuf_size = 64;
    LOG_NEW; smbuf = new char[64];
    start = string = 0;
    smbuf[0] = 0;
}

StrBuf :: StrBuf(const char* s)
{
    smbuf_size = 64;
    LOG_NEW; smbuf = new char[64];
    LOG_NEW; string = new char[strlen(s) + 1];
    strcpy(string,s);
    start = string;
    smbuf[0] = 0;
}

StrBuf :: ~StrBuf ()
{
    LOG_DEL; delete smbuf;
    LOG_DEL; delete string;
}

const char* StrBuf :: getword()
{
    if (!string) return 0;
    if (start && *start) { // there is a word
	while (isspace(*start)) start++;
	char* stop = start;
	for (; *stop && !isspace(*stop); stop++);
	int len = stop - start;
	if (len) {
	    if (!smbuf_size) {
		smbuf_size = ((len > 64 ? len : 64) + 7) & ~7;
		LOG_NEW; smbuf = new char[smbuf_size];
	    }
	    else if (len > smbuf_size) {
		smbuf_size = (len + 7) & ~7;
		LOG_DEL; delete smbuf;
		LOG_NEW; smbuf = new char[smbuf_size];
	    }
	    strncpy(smbuf,start,len);
	    smbuf[len] = 0;
	    for (; *stop && isspace(*stop); stop++);
	    start = stop;
	    return smbuf;
	}
	else
	    return 0;
    }
    else
	return 0;
}

const char* StrBuf :: operator = (const char* nstr)
{
    LOG_DEL; delete string;
    LOG_NEW; string = new char[strlen(nstr) + 1];
    strcpy(string,nstr);
    start = string;
    return nstr;
}
