
/*
 *
 * Version identification:
 * @(#)readwrite.c	1.2 11/23/92
 *
 */

#ifndef lint
static char rcsid[] = "$Header: readwrite.c,v 1.1 86/11/30 03:57:41 salz Exp $";
#endif

/*
 * Routines for writing and Reading trace files.
 */

#include <stdio.h>
#include <sys/file.h>
#include <string.h>
#include "defs.h"
#include "readwrite.h"

static char  readErr[] = "Error in reading file (abort)\n";


void CmdRead( narg, args )
  int   narg;
  char  *args[];
  {
    RdWrData  head;
    int       fd;
    char      *str;
    int       n, i;
    CommHist  levBuff;
    TrigEnt  *g, *next;

    if( windowState.simulStatus != DEAD )
      {
	PRINT( "Can't do that, simulation is still running\n" );
	return;
      }
    if( narg == 0 )
      {
	PRINT( "No filename specified\n" );
	return;
      }
    fd = open( args[0], O_RDONLY, 0 );
    if( fd < 0 )
      {
	PRINT( "Can't open file: " );
	PRINT( args[0] );
	PUTC( '\n' );
	return;
      }
    PRINT( "Reading file ..." );
    FLUSH();
    if( read( fd, (char*)&head, sizeof( head ) ) < 0 )
      {
	PRINT( readErr );
	close( fd );
	return;
      }

    if( (head.magicNum != MAGIC_NUM) || (head.magic2 != ~ MAGIC_NUM) )
      {
	PRINT( args[0] );
	PRINT( " was not created by analyzer (abort)\n" );
	close( fd );
	return;
      }

    PUTC( '.' );
    FLUSH();

	/* Read in strings */

    str = Malloc( head.strSize );
    if( str == NULL )
      {
	PRINT( "sorry: not enough memory for input signals\n" );
	close( fd );
	return;
      }

    if( read( fd, str, head.strSize ) != head.strSize )
      {
	PRINT( readErr );
	close( fd );
	Mfree( str, head.strSize );
	return;
      }

		/* Read the traces specifications */
    if( read( fd, (char*)traces.traces, head.ntraces * sizeof( TraceEnt ) ) < 0 )
      {
	PRINT( readErr );
	close( fd );
	Mfree( str, head.strSize );
	traces.numTraces = traces.dispTraces = 0;  /* avoid strange results */
	return;
      }

	/* Now Initialize pointers into the strings read */

      {
	register char  *s;
	char          **t;

	for( i = 0, t = inputs.names; i < inputs.numInputs; i++, t++ )
	  {
	    Mfree( *t, strlen( *t )+1 );	/* free current names */
	  }
	Mfree( names.model, strlen( names.model ) + 1 );
	Mfree( names.source, strlen( names.model ) + 1 );

	s = str;
	names.source = s;
	while( *s++ != '\0' );
	while( *s == '\0' ) s++;
	names.model = s;
	while( *s++ != '\0' );
	while( *s == '\0' ) s++;
	
	for( i = 0, t = inputs.names; i < head.numInputs; i++, t++ )
	  {
	    *t = s;
	    while( *s++ != '\0' );
	    while( *s == '\0' ) s++;
	  }
	PUTC( '.' );
	FLUSH();
      }

		/* deallocate current triggers, if any */
    g = trigger.first;
    while( g != NULL )
      {
	next = g->next;
	Mfree( g, sizeof( TrigEnt ) );
	g = next;
      }
    trigger.first = trigger.last = NULL;


		/* Read in the trigger specifications */    
    for( n = 0, i = 0; i < head.nTrig; i++ )
      {
	if( !n )
	  {
	    g = (TrigEnt *) Malloc( sizeof( TrigEnt ) );
	    if( g == NULL )
	      {
		PRINT( "Not enough memory for triggers\n" );
		n = 1;		/* err flag */
	      }
	  }
	else		/* dirty, but size(TrigEnt) < size(CommHist) */
	  g = (TrigEnt *) &levBuff;

	if( read( fd, (char*)g, sizeof( TrigEnt ) ) != sizeof( TrigEnt ) )
	  {
	    PRINT( readErr );
	    close( fd );
	    trigger.first = trigger.last = NULL;
	    return;
	  }
	if( !n )
	  {
	    g->next = NULL;
	    if( i == 0 )
	      {
		trigger.first = g;
		trigger.last = g;
	      }
	    else
	      {
		trigger.last->next = g;
		trigger.last = g;
	      }
	  }
      }

		/* We got this far, deallocate current history */
    RecoverMem( times.last + 1, 0 );

		/* Read new history, as much as will fit into memory */
    for( i = head.first; i <= head.last; i++ )
      {
	if( read( fd, (char*)&levBuff, sizeof(TimeType) + head.numInputs ) < 0 )
	  {
	    PRINT( readErr );
	    RecoverMem( i, 0 );		/* get rid of it again */
	    close( fd );
	    return;
	  }
	if( AddReadHist( &levBuff, head.numInputs ) )
	  {
	    head.last = i - 1;
	    PRINT( "Not enough memory for the whole history\n" );
	    break;
	  }
	if( i % 100 == 0 )
	  {
	    PUTC( '.' );
	    FLUSH();
	  }
      }

    close( fd );
    inputs.numInputs = head.numInputs;
    traces.numTraces = head.ntraces;
    cursor.time = head.cursor;
    cursor.exists = -1;
    times.first = head.first;
    times.last = head.last;
    times.dispStart = head.start;
    times.dispSteps = head.steps;
    banner.left = AllocStr( strlen(names.source) + strlen(names.model) + 15 );
    if( banner.left == NULL )
	banner.left = names.model;
    else
	sprintf( banner.left, " %s analyzer (%s)", names.source, names.model);
    PRINT( "done\n" );
    traces.maxDigits = MaxTraceDigits();
    traces.maxName = MaxTraceName();
    SetWindowParms();
    GetSignalPos();
    RedrawBanner();
    RedrawTimes();
    RedrawNames();
    DrawScrollBar();
    RedrawTraces( times.dispStart, times.dispStart + times.dispSteps, 1 );
    DrawCursVal();
  }


#define	WRITE( a, b, c )			\
  {						\
    if( write( a, (char*)(b), c ) < 0 )		\
      {						\
	PRINT( "Error: write failed\n" );	\
	close( a );				\
      }						\
  }						\


void CmdWrite( narg, args )
  int   narg;
  char  *args[];
  {
    RdWrData  head;
    TimeType  last;
    int       fd, i, n, b;
    char      **t;
    TrigEnt   *g;
    HistRef   h;
    char      fname[ 256 ];
    
    switch( narg )
      {
	case 0:
	    sprintf( fname, "%s%s", names.model, FOUT_EXT );
	    last = times.last;
	    break;
	case 1:
	    if( sscanf( args[0], "t=%d", &last ) == 1 )
		sprintf( fname, "%s%s", names.model, FOUT_EXT );
	    else
	      {
		strcpy( fname, args[0] );
		last = times.last;
	      }
	    break;
	case 2:
	    if( sscanf( args[1], "t=%d", &last ) != 1 )
	      {
		PRINT( args[1] );
		PRINT( "? Incorrect syntax\n" );
		return;
	      }
	    strcpy( fname, args[0] );
	    break;
      }

    if( last > times.last )
      {
	PRINT( "Time out of range (abort)\n" );
	return;
      }
    fd = open( fname, O_RDWR | O_CREAT | O_TRUNC, 0644 );
    if( fd < 0 )
      {
	PRINT( "Can't create or open file: " );
	PRINT( fname );
	PUTC( '\n' );
	return;
      }
    
    PRINT( "Writing file..." );
    FLUSH();
    head.magicNum = MAGIC_NUM;
    head.magic2 = ~MAGIC_NUM;
    head.numInputs = inputs.numInputs;
    head.ntraces = traces.numTraces;
    head.cursor = cursor.time;
    head.first = times.first;
    head.last = last;
    if( times.dispStart + times.dispSteps > last )
	head.start = times.first;
    else
	head.start = times.dispStart;
    head.steps = times.dispSteps;
    for( g = trigger.first, n = 0; g != NULL; g = g->next, n++ );
    head.nTrig = n;
    n = 0;
    for( t = inputs.names, i = 0; i < inputs.numInputs; i++, t++ )
      {
	b = (strlen( *t ) + MEMUNIT ) / MEMUNIT;
	n += b * MEMUNIT;
      }
    b = ( strlen( names.source ) + MEMUNIT ) / MEMUNIT;
    n += b * MEMUNIT;
    b = (strlen( names.model ) + MEMUNIT) / MEMUNIT;
    n += b * MEMUNIT;
    head.strSize = n;
    WRITE( fd, (char*)&head, sizeof( head ) );

	/* Write all signal names and strings, alligned on MEMUNIT */

    b = strlen( names.source ) + 1;
    WRITE( fd, names.source, (b < MEMUNIT) ? MEMUNIT : b );
    b = strlen( names.model ) + 1;
    WRITE( fd, names.model, (b < MEMUNIT) ? MEMUNIT : b );

    for( t = inputs.names, i = 0; i < inputs.numInputs; i++, t++ )
      {
	b = (strlen( *t ) + MEMUNIT) / MEMUNIT;
	WRITE( fd, *t, b * MEMUNIT )
      }

	/* Write all the used traces */
    WRITE( fd, (char*)traces.traces, traces.numTraces * sizeof( TraceEnt ) )

	/* Write the trigger values */
    
    for( g = trigger.first; g != NULL; g = g->next )
      {
	b = ( sizeof( TrigEnt ) + MEMUNIT - 1 ) / MEMUNIT;
	WRITE( fd, g, sizeof( TrigEnt ) )
      }
	/* Write the history levels */

    h = GetHist( times.first );
    for( ; (h != NULL) && (h->time <= last); h = h->next )
      {
	WRITE( fd, &(h->time), sizeof( TimeType ) )
	WRITE( fd, h->levels, inputs.numInputs )
	if( (h->time % 100) == 0 )
	  {
	    PUTC( '.' );
	    FLUSH();
	  }
      }
    close( fd );
    PRINT( "done\n" );
  }
