
/*
 *
 * Version identification:
 * @(#)parser.c	1.2 11/23/92
 *
 */

#ifndef lint
static char rcsid[] = "$Header: parser.c,v 1.1 86/11/30 03:57:37 salz Exp $";
#endif
/*
 * String matching and lookup operations.
 */

#include <stdio.h>
#include <ctype.h>
#include "parser.h"


/*
 * Parse the string 'line' into unix-style parameter list.
 * Return number of arguments.
 */

int GetArgs( line, args )
  char  *line;
  char  *args[];
  {
    register char  *p;
    int      ac;
    
    ac = 0;
    p = line;
    for( ; ; )
      {
	while( *p == ' ' || *p == '\t' || *p == '\n' )
	    ++p;
	if( *p == '\0' )
	    break;

	args[ ac ] = p;
	ac++;
	while( *p != ' ' && *p != '\t' && *p != '\n' && *p != '\0' )
	    ++p;
	if( *p == '\0' )
	    break;

	*p = '\0';
	p++;
      }
    args[ ac ] = NULL;
    return( ac );
  }



/*
 * Searches a table of strings to find one that matches a given
 * string, allowing unique abbreviations.  If str is unambiguous
 * return a pointer to the matching entry, NULL if there is no match.
 * If str is ambiguous then print the ambiguous commands and return a
 * pointer to the last entry in the table (with NULL command name).
 */

LookupTable *LookupCmd( str, table )
  char         str[];		/* Pointer to a string to be looked up */
  LookupTable  *table;		/* Pointer to a array of valid commands */
  {
    /* The search is carried out by using two pointers, one which moves
     * forward through table from its start, and one which moves backward
     * through table from its end.  The two pointers mark the range of
     * strings that match the portion of str that we have scanned.  When
     * all of the characters of str have been scanned, then the two
     * pointers better be identical.
     */
    LookupTable  *bot, *top, *i, *last;
    char         currentchar;
    int          index;

    bot = table;
    for( top = table; top->cmd != NULL; top++ );
    last = top;
    if( top == bot )
	return( NULL );
    top--;

    for( index = 0; ; index++ )
      {
	/* Check for the end of string */

	currentchar = str[ index ];
	if( isupper( currentchar ) )
	   currentchar += 'a' - 'A';
	if( currentchar == '\0' )
	  {
	    if( bot == top )
	      return( bot );

	    /*
	     * Several entries match this one up to the last character
	     * of the string.  If one is an exact match, we allow it.
	     */
	    for( i = bot; bot <= top; bot++ )
	      {
		if( bot->cmd[ index ] == '\0' )
		    return( bot );
	      }
	    PRINT( "Ambiguous Command: " );
	    for( ; i <= top; i++ )
	      {
		PRINT( i->cmd );
	      }
	    PUTC( '\n' );
	    return( last );
	  }

	/* Move bot up until the string it points to matches str in the
	 * index-th position.  Make match refer to the index of bot in table.
	 */

	while( bot->cmd[ index ] != currentchar )
	  {
	    if( bot == top )
	      return( NULL );
	    bot++;
	  }

	/* Move top down until it matches */
	while( top->cmd[ index ] != currentchar )
	  {
	    if( bot == top )
	      return( NULL );
	    top--;
	  }
      }
  }



/*
 * Sees if two strings match, using csh-like pattern matching, return 1 if
 * there is match, 0 otherwise.  The first string can contain the special
 * characters *, ?, \, [, and [.  Note that [ and ] do the right thing for
 * numerical parameters.
 */


int MatchStr(pattern, string)
  register char *pattern;	/* csh-like pattern. */
  register char *string;	/* String to check against pattern. */
  {
    char  c2;
    int   n, n1, n2;

    for(;;)
      {
	/* See if we are at the end of both pattern and string.  If
	 * so, we succeeded.  If we are at the end of pattern, but not
	 * of string, we failed.
	 */
	
	if( *pattern == 0 )
	  {
	    if( *string == 0 )
	      return( 1 );
	    else
	      return( 0 );
	  }
	if( (*string == 0) && (*pattern != '*') )
	   return( 0 );

	/* Check for a "*" as the next pattern character.  It matches
	 * any substring.  We handle this by calling ourselves
	 * recursively for each postfix of string, until either we
	 * match or we reach the end of the string.
	 */
	
	if( *pattern == '*' )
	  {
	    pattern++;
	    if( *pattern == 0 )
	      return( 1 );
	    while( *string != 0 )
	      {
		if( MatchStr( pattern, string ) )
		  return( 1 );
		string++;
	      }
	    return( 0 );
	  }
    
	/* Check for a "?" as the next pattern character.  It matches
	 * any single character.
	 */

	if( *pattern == '?' )
	  goto thisCharOK;

	/* Check for a "[" as the next pattern character.  It is followed
	 * by a list of characters that are acceptable, by a range
	 * (two characters separated by "-"), or by a range of two numbers.
	 */
	
	if( *pattern == '[' )
	  {
	    pattern++;
	    if( (isdigit( *pattern )) && numRange( pattern, &n1, &n2 ) )
	      {
		while( *pattern != ']' )
		    pattern++;
		if( !isdigit( *string ) )
		    return( 0 );
		n = atoi( string );
		if( n < n1 || n > n2 )
		    return( 0 );
		while( isdigit( *string ) )
		    string++;
		string--;
		goto thisCharOK;
	      }
	    else
	      {
		for(;;)
		  {
		    if( (*pattern == ']') || (*pattern == 0) )
			return( 0 );
		    if( *pattern == *string )
			break;
		    if( pattern[1] == '-' )
		      {
			c2 = pattern[2];
			if( c2 == 0 )
			    return( 0 );
			if( (*pattern <= *string) && (c2 >= *string) )
			    break;
			if( (*pattern >= *string) && (c2 <= *string) )
			    break;
			pattern += 2;
		      }
		    pattern += 1;
		  }
		while( (*pattern != ']') && (*pattern != 0) )
		    pattern++;
		goto thisCharOK;
	      }
	  }
    
	/* If the next pattern character is '/', just strip off the '/'
	 * so we do exact matching on the character that follows.
 	 */
	
	if( *pattern == '\\' )
	  {
	    pattern++;
	    if( *pattern == 0 )
		return( 0 );
	  }

	/* There is no special character.  Just make sure that the next
	 * characters of each string match.
	 */
	
	if( *pattern != *string )
	    return( 0 );

	thisCharOK:
	pattern++;
	string++;
      }
  }


static int numRange( pattern, n1, n2 )
  char  *pattern;
  int   *n1, *n2;
  {
    *n1 = atoi( pattern );
    while( isdigit( *pattern ) )
	pattern++;
    if( *pattern != '-' )
	return( 0 );
    pattern++;
    if( !isdigit( *pattern ) )
	return( 0 );
    *n2 = atoi( pattern );
    while( isdigit( *pattern ) )
	pattern++;
    if( *pattern == ']' )
	return( 1 );
    return( 0 );
  }



/*
 * Find all matching instances of the pattern list in table, and put the
 * index of the matching entries in the result list.  Return the number
 * of matching instances found.
 */
int MatchNames( patterns, nPat, table, tableSize, resultList )
  char  **patterns;
  int   nPat;
  char  **table;
  int   tableSize;
  int   *resultList;
  {
    register  int  index;
    int		   nfound;
    
    
    for( nfound = 0; nPat; patterns++, nPat-- )
      {
	for( index = 0; index < tableSize; index++ )
	  {
	    if( MatchStr( *patterns, table[ index ] ) )
	      {
		resultList[ nfound++ ] = index;
	      }
	  }
      }
    return( nfound );
  }
