
/*
 *
 * Version identification:
 * @(#)names.c	1.2 11/23/92
 *
 */

#ifndef lint
static char rcsid[] = "$Header: names.c,v 1.2 87/01/28 00:19:58 salz Exp $";
#endif

/*
 * Signal name handler
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "defs.h"
#include "ipc.h"

/*
 * Allocate space for a string.  len should be strlen( name ) + 1 for the
 * terminator.  Notice that strings are allocated in multiples of MEMUNIT,
 * so strings smaller than a multiple of MEMUNIT are padded with NULL chars.
 */
char *AllocStr( len )
  int  len;
  {
    char  *new;
    int   newlen;

    new = Malloc( len );
    if( new != NULL )
      {
	newlen = (len + MEMUNIT - 1) / MEMUNIT;
	newlen *= MEMUNIT;
	while( len < newlen )
	    new[ len++ ] = '\0';		/* pad with NULL's */
      }
    return( new );
  }



/*
 * Read a signal name from the parent process and allocate space for it.
 */
char *GetName( commLink )
  int  commLink;
  {
    char      *name;
    MsgType   n;
    int	      len;
    char      *tmp;
    
    n = ipc_Receive( commLink, &name, &len );
    if( n != ADDSIGNAL )
	ANALYZER_Crash( "Error while reading signal names" );

    if( len == 0 ) len++;
    tmp = AllocStr( len );
    if( tmp == NULL )
	ANALYZER_Crash( "Not enough memory for signal names" );
    bcopy( name, tmp, len );
    return( tmp );
  }


/*
 * Add a new input.  Append input to input list and delete current history.
 */
void AddNewSignal( msg )
  AddSigMsg  *msg;
  {
    char  *s;

    if( inputs.numInputs >= MAXINPUTS )
      {
        char  numbuff[ 20 ];

        PRINT( "Can't add input, maximum is " );
	sprintf( numbuff, "%d\n", MAXINPUTS );
	PRINT( numbuff );
	return;
      }
		/* must do this since numInputs will increase */
    RecoverMem( times.last + 1, 0 );

    if( msg->len == 0 ) msg->len++;
    s = AllocStr( msg->len );
    if( s == NULL )
      {
	PRINT( "Can't add new signal, out of memory\n" );
	return;
      }
    bcopy( msg->name, s, msg->len );
    inputs.names[ inputs.numInputs++ ] = s;
  }


/*
 * Rename (reconnect) an input signal.  Simply change the name table.
 * Keep the trace history even though it may be incorrect, it's up to
 * the simulator to update it since the net-list has changed.
 */
void RenameSignal( msg )
  RenSigMsg  *msg;
  {
    int  maxName, sigNum;

    sigNum = msg->signum;
    if( (sigNum < 0) || sigNum > inputs.numInputs )
	PRINT( "Can't rename that signal-number (out of bounds)\n" );
    Mfree( inputs.names[ sigNum ], strlen( inputs.names[sigNum] ) + 1 );
    if( ( inputs.names[ sigNum ] = AllocStr( msg->len ) ) == NULL )
      {
	PRINT( "Can't rename signal: Out of memory for signal names\n" );
	return;
      }
    bcopy( msg->name, inputs.names[ sigNum ], msg->len );
    maxName = MaxTraceName();
    if( maxName != traces.maxName )
      {
	traces.maxName = maxName;
	SetWindowParms();
	RedrawNames();
	DrawScrollBar();
	RedrawTraces( times.dispStart, times.dispStart + times.dispSteps, 1 );
	RedrawTimes();
      }
    else
	RedrawNames();
  }


void DeleteOldSignal( msg )
  DelSigMsg  *msg;
  {
    register  sigNum;
    register  tnum;
    register  i, j, n;
    TraceEnt  *trace, *lastT;
    TrigEnt   *trig, *nextT;
    
    sigNum = msg->signum;
    if( sigNum >= inputs.numInputs )
      {
	PRINT( "Can't delete, nonexistent signal\n" );
	return;
      }
    Mfree( inputs.names[ sigNum ], strlen( inputs.names[ sigNum ] ) + 1 );

	/* Delete references to this signal from all traces */
    
    lastT = &(traces.traces[ traces.numTraces ]);
    for( trace = traces.traces; trace != lastT ; trace++ )
      {
        for( i = 0; i < trace->nsig; )
	  {
	    if( trace->signals[i] == sigNum )
	      {
		trace->nsig--;
		for( j = i; j < trace->nsig; j++ )
		    trace->signals[ j ] = trace->signals[ j+1 ];
	      }
	    else
	      {
		if( trace->signals[ i ] > sigNum )
		    trace->signals[ i ]--;		/* move index up */
		i++;
	      }
	  }
      }

	/* If there are now empty traces, delete them */
    tnum = 0;
    trace = traces.traces;
    while( tnum < traces.numTraces )
      {
	if( trace->nsig < 1 )
	  {
	    traces.numTraces--;
	    for( n = tnum; n < traces.numTraces; n++ )
		traces.traces[ n ] = traces.traces[ n+1 ];
	  }
	else
	  {
	    tnum++;
	    trace++;
	  }
      }

	/* Now shift the input names to delete the desired name */
    inputs.numInputs--;
    for( i = sigNum; i < inputs.numInputs; i++ )
        inputs.names[ i ] = inputs.names[ i + 1 ];


	/* Delete all references to sigNum from the trigger */
    for( trig = trigger.first; trig != NULL; trig = trig->next )
      {
	for( i = 0; i < trig->nsig; )
	  {
	    if( trig->index[ i ] == sigNum )
	      {
		trig->nsig--;
		for( j = i; j < trig->nsig; j++ )
		    trig->index[ j ] = trig->index[ j+1 ];
	      }
	    else
	      {
		if( trig->index[ i ] > sigNum )
		    trig->index[ i ]--;
		i++;
	      }
	  }
      }

	/* Now delete any empty triggers as a result from the last step */
    trig = trigger.first;
    if( trig != NULL )
	nextT = trig->next;
    else
	nextT = NULL;

    while( nextT != NULL )
      {
	if( nextT->nsig == 0 )
	  {
	    trig->next = nextT->next;
	    Mfree( nextT, sizeof( TrigEnt ) );
	    nextT = trig->next;
	  }
	else
	  {
	    trig = nextT;
	    nextT = nextT->next;
	  }
      }
    trigger.last = trig;
    trig = trigger.first;
    if( trig != NULL )
      {				    /* Now look at the 1st trigger, if any */
	if( trig->nsig == 0 )
	  {
	    trigger.first = trig->next;
	    Mfree( trig, sizeof( TrigEnt ) );
	    if( trig == trigger.last )
		trigger.last = NULL;	   /* first == last, empty list */
	  }
      }

    traces.maxDigits = MaxTraceDigits();
    traces.maxName = MaxTraceName();
    SetWindowParms();
    GetSignalPos();
    RecoverMem( times.last + 1, 0 );
    RedrawWindow( NULL );
  }


/*
 * Return s with any trailing digits or square brackets removed.
 */
char *Root( s )
  char *s;
  {
    static char result[ 256 ];
    register char *p, *q, *r;
    
    for( q = p = s; *p; p++ );
    p--;
    while( p > q && ( (*p >= '0' && *p <= '9') || *p == '[' || *p == ']' ) )
	p--;
    p++;
    for( r = result; q != p; )
	*r++ = *q++;
    *r = '\0';
    return( result );
  }



/*
 * Return 1 if all signals in a trace have the same root name, otherwise 0.
 */
int  IsSameRoot( index, n )
  int  *index;
  int  n;
  {
    char  root[ 50 ];
    
    (void) strcpy( root, Root( inputs.names[ *index ] ) );
    for( index++; n > 1; n--, index++ )
      {
	if( strcmp( root, Root( inputs.names[ *index ] ) ) )
	    return( 0 );
      }
    return( 1 );
  }
