
/*
 *
 * Version identification:
 * @(#)movetrace.c	1.1 8/26/91
 *
 */

#ifndef lint
static char rcsid[]= "$Header: movetrace.c,v 1.2 87/05/05 13:35:30 rokicki Exp $";
#endif

#include <stdio.h>
#include "defs.h"

extern int descent;

/*
 * Allow the user to select a trace and move it to another position.  If the
 * the new position is outside the traces height then delete that trace.
 */
void MoveTrace( yin )
  YCoord  yin;
  {
    XCoord      x1;
    YCoord      y0, y1, y, handle, height;
    int         i, tnum, pos;
    XEvent rep ;
    XMotionEvent *xke ;
    int newy ;
    TraceEnt    *t;


    xke = (XMotionEvent *)&rep ;
    if( traces.dispTraces == 0 )
	return;
    tnum = -1;
    for( i = 0, t = traces.traces; i < traces.dispTraces; i++, t++ )
      {
	if( yin >= t->bot )
	  {
	    tnum = i;
	    break;
	  }
      }
    if( tnum < 0 )		/* no trace selected */
	return;



    y0 = t->bot;
    x1 = sigNames.right - 2;
    y1 = t->top;
    handle = yin - t->bot;
    height = t->top - yin;
    
    mySetRendering( INVERT );
    myFilledRectangle( 2, y0, x1, y1 );
    myRectangle( 2, y0, x1, y1 );
    y = yin;
    while (1) {
          XNextEvent(display,&rep) ;
          if (rep.type == ButtonRelease)  break ;
          else if (rep.type == MotionNotify) {
            newy = YWINDOWSIZE - xke->y ;
            myRectangle( 2, y - handle, x1, y + height );
            y = newy ;
            myRectangle( 2, y - handle, x1, y + height );
          }
        }



    myRectangle( 2, y - handle, x1, y + height );
    myFilledRectangle( 2, y0, x1, y1 );
    mySetRendering( PAINTFGBG );
    if(  (y - handle > traces.traces[ 0 ].top) ||
         (y + height < traces.traces[ traces.dispTraces - 1 ].bot) )
      {
	DeleteTrace( tnum+1 );
      }
    else
      {
	y += (height - handle) / 2;	/* mid-point of a trace */
	pos = -1;
	for( i = 0, t = traces.traces; i < traces.dispTraces; i++, t++ )
	  {
	    if( y > t->bot )
	      {
		pos = i;
		break;
	      }
	  }
	if( pos < 0 )
	    PRINT( "Ambiguous position, between 2 traces\n" );
	else
	    MoveTracePos( tnum, pos );
      }
  }




void DeleteTrace( tnum )
  int  tnum;
  {
    int  len;

    for( tnum--; tnum < traces.numTraces - 1; tnum++ )
      {
	traces.traces[ tnum ] = traces.traces[ tnum + 1 ];
      }
    traces.numTraces--;
    
    tnum = MaxTraceDigits();
    len = MaxTraceName();
    if( (tnum != traces.maxDigits) || (len != traces.maxName) )
      {
	traces.maxDigits = tnum;
	traces.maxName = len;
	SetWindowParms();
	DrawScrollBar();
	RedrawTimes();
      }
    GetSignalPos();
    RedrawNames();
    RedrawTraces( times.dispStart, times.dispStart + times.dispSteps, 1 );
    DrawCursVal();
  }


void MoveTracePos( tnum, pos )
  int  tnum, pos;
  {
    int       i;
    TraceEnt  tmp;

    if( tnum == pos )
	return;				/* done same position */
    tmp = traces.traces[ tnum ];
    if( tnum < pos )
      {
	for( i = tnum; i < pos; i++ )
	    traces.traces[ i ] = traces.traces[ i + 1 ];
      }
    else				/* tnum > pos */
      {
	for( i = tnum; i > pos; i-- )
	    traces.traces[ i ] = traces.traces[ i - 1 ];
      }
    traces.traces[ pos ] = tmp;
    GetSignalPos();
    RedrawNames();
    RedrawTraces( times.dispStart, times.dispStart + times.dispSteps, 1 );
    DrawCursVal();
  }
