
/*
 *
 * Version identification:
 * @(#)ipc.c	1.2 11/23/92
 *
 */

#ifndef lint
static char rcsid[] = "$Header: ipc.c,v 1.1 86/11/30 03:57:30 salz Exp $";
#endif

/*
 * Inter-Process Communication procedures
 */

#include "ipc.h"

static  Message  message;		/* communication buffer */

/*
 * Read a message from channel into data, return data size in len
 */
MsgType ipc_Receive( channel, data, len )
  int   channel;
  char  **data;
  int   *len;
  {
    if( read ( channel, (char*)&message, sizeof( Header ) ) != (sizeof( Header )) ) {
	return( IPC_ERR );
    }
    *len = 0;
    if( message.header.length )
      {
	*len = read( channel, message.data, message.header.length );
	if( *len != message.header.length ) {
	    return( IPC_ERR );
	}
      }
    *data = message.data;
    return( message.header.type );
  }

/*
 * Send len bytes of data through channel.  Only return values are IPC_OK
 * or IPC_ERR in case of an error.
 */
MsgType ipc_Send( channel, data, len, msgType )
  int	   channel;
  char	   *data;
  int	   len;
  MsgType  msgType;
  {
    int  size;
    
    message.header.type = msgType;
    message.header.length = len;
    bcopy( data, message.data, len );
    size = sizeof( Header ) + len;

    if( write( channel, (char*)&message, size ) != size ) 
	return( IPC_ERR );
    else
	return( IPC_OK );
  }


/*
 * Return a ptr. to the data buffer.
 */
GetLastHist( ptr )
  char **ptr;
  {
    *ptr = message.data;
  }
