
/*
 *
 * Version identification:
 * @(#)history.h	1.1 8/26/91
 *
 */

#ifndef HIST_H

#define HIST_H
#define historyRCSID "$Header: history.h,v 1.1 86/12/07 15:25:52 salz Exp $";

#define MAXINPUTS	250

typedef int   TimeType;
typedef char  *Levels;			/* signal levels are kept as chars */

typedef struct HistEnt
  {
    TimeType	    time;		/* Simulation time of transition */
    Levels	    levels;		/* Levels of the signals */
    struct HistEnt  *next;		/* Next entry in time */
    struct HistEnt  *prev;		/* Previous entry in time */
  } HistEnt, *HistRef;



typedef struct		/* History entry for communication */
  {
    TimeType	    time;		/* Simulation time of transition */
    char	    levels[ MAXINPUTS];		/* Levels of the signals */
  } CommHist;


extern int        AddHist( );
extern HistRef    GetHist( );

#endif
