
/*
 *
 * Version identification:
 * @(#)convert.c	1.1 8/26/91
 *
 */

#ifndef lint
static char rcsid[] = "$Header: convert.c,v 1.3 87/07/22 17:12:51 rla Exp $";
#endif

#include "defs.h"

/*
 * Convert an ascii string to an unsigned integer.  Bases 2, 8, 16 and 10 are
 * specified by prefixing the number with 0b, 0, 0x, respectivelly.  Base 10
 * is the defult.
 */
Uint AsciiToInt( string, err )
  char  *string;
  int   *err;
  {
    char  c;
    int   base;
    Uint  num;

    if( *string == '0' )
      {
	string++;
	if( *string == 'x')
	  {
	    string++;
	    base = 16;
	  }
	else if( *string == 'b' )
	  {
	    string++;
	    base = 2;
	  }
	else
	    base = 8;
      }
    else
	base = 10;

    *err = 0;
    for( num = 0; *string > ' '; string++ )
      {
	c = (*string) | 0x20;				/* lower case it */
	if( base == 16 && c >= 'a' && c <= 'f' )
	    num = num * base + c - 'a' + 10;
	else if( c >= '0' && ( ( c -  '0' ) < base ) )
	    num = num * base + c - '0';
	else
	  *err = 1;
      }
    return( num );
  }


/*
 * Convert a trace entry (bus) to a display string
 */
char *Convert( levels, t )
  Levels    levels;
  TraceEnt  *t;
  {
    register       i, j;
    register char  *p; 
    int            digit;
    static char    result[ MAXBUSSIZE + 1 ];
    static char    HexMap[] = "0123456789abcdef";

    p = &(result[ MAXBUSSIZE ]);
    *p-- = '\0';
    for( i = t->nsig-1; i >= 0; i -= t->bits)
      {
	digit = 0;
	j = i - t->bits + 1;
	if (j < 0)
	    j = 0;
	for(; j <= i; ++j )
	  {
	    switch( levels[ t->signals[ j ] ] )
	      {
		case ZERO :
		    digit = (digit << 1);
		    break;
		case ONE :
		    digit = (digit << 1) | 1;
		    break;
		case FLOAT :
		    *p-- = 'Z';
		    goto next;
		case UNDEF :
		    *p-- = 'U';
		    goto next;
		default :
		    *p-- = 'U';
		    PRINT( "warning: strange value in signal " );
		    PRINT( inputs.names[ t->signals[ j ] ] );
		    PUTC( '\n' );
		    goto next;
	      }
	  }
	*p-- = HexMap[ digit ];
	next:  ;
      }
    return( ++p );
  }
