
/*
 *
 * Version identification:
 * @(#)commands.c	1.2 11/23/92
 *
 */

#ifndef lint
static char rcsid[] = "$Header: commands.c,v 1.1 86/11/30 03:57:17 salz Exp $";
#endif
/*
 * Contains the tables for command/parameter lookup.
 */

#include "parser.h"

/*
 * Command table: commands with the same prefixes must be adjacent in the
 * table.  The end of the table is indicated by a NULL string.  The strings
 * should all be in lower case.
 */

LookupTable CmdTable[] = {
  { "add ","signals [b=base]  => add signals to trace.", CmdAdd, Noop },
  { "autostop ","[on|off]  => turn stop-on-trigger on/off.", CmdAuto, Noop },
  { "base ","num base  => change display base of trace num.", CmdBase, Noop },
  { "blank ","  => clear the text window.", CmdClear, Noop },
  { "delete ","num  => delete trigger num from tracing.", CmdDelete, Noop},
  { "display ","num pos  => move trace num to trace pos", CmdMovetrace, Noop},
  { "exec ", "name  => execute commands from file name", CmdExec, Noop },
  { "continue ","  => continue simulation", CmdCont, Noop },
  { "first ","  => find first trigger point.", CmdFirst, Noop },
  { "last ","  => find last trigger point.", CmdLast, Noop },
  { "list ","signals  => list input signals.", CmdList, Noop },
  { "lines ","num  => set text window lines to num.", CmdLines, Noop },
  { "help ","[commands]  => print command description/list", CmdHelp, Noop },
  { "move ","{position | time}  => move to position/time.", CmdMove, Noop },
  { "next ","  => find next trigger point.", CmdNext, Noop },
  { "previous ","  => find previous trigger point.", CmdPrevious, Noop },
  { "print ","[file] [a-b] => write PostScript file from time a to b.", CmdPrint, Noop },
  { "quit ","  => exit analyzer", CmdQuit, Noop },
  { "remove ","num  => remove trace number.", CmdRemove, Noop },
  { "redraw ","  => (obsolete) redraw the window.", CmdRedraw, Noop },
  { "reclaim ","[num]  => reclaim memory up to num time.", CmdReclaim, Noop },
  { "read "," fname  => read history from fname.", CmdRead, Noop },
  { "status ","[num]  => status of trigger specs.", CmdStatus, Noop },
  { "stop ","  => stop simulation on next step", CmdStop, Noop },
  { "trace ","signals {=|} value  => trace signals on value.", CmdTrace, Noop },
  { "width ","num  => set display width to num time-steps.", CmdWidth, Noop },
  { "whatis ","num  => display specs of trace num.", CmdWhatis, Noop },
  { "write ","[fname] [t=num]  => write state to fname up to time num.", CmdWrite, Noop },
  { "zoom ","in|out|seeAll  => zoom in/out/show-all", CmdZoom, Noop },
  { 0, 0, nullF, Noop }
 };


LookupTable Positions[] =
 {
   { "left", 0, nullF, MovLeft },
   { "right", 0, nullF, MovRight },
   { "begining", 0, nullF, MovBeg },
   { "end", 0, nullF, MovEnd },
   { 0, 0, nullF, Noop }
 };


LookupTable ZoomDir[] =
  {
    { "in", 0, nullF, ZoomIN },
    { "out", 0, nullF, ZoomOUT },
    { "seeall", 0, nullF, SeeAll },
    { 0, 0, nullF, Noop }
  };

/* declare the dummy function */

void nullF() {}
