defstar {
	name {FloatRamp}
	domain {DE}
	version { @(#)DEFloatRamp.pl	1.5	11/25/92}
	author { Soonhoi Ha }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { DE main library }
	desc {
This star produces a ramp output when stimulated by an input.
A ramp is simply a monotonically increasing signal.
The time stamp of the output is the same as that of the input.
The value of the input is ignored.
	}
	input {
		name {input}
		type {anytype}
	}
	output {
		name {output}
		type {float}
	}
	defstate {
		name {value}
		type {float}
		default {"0.0"}
		desc { Starting and current state of the ramp. }
	}
	defstate {
		name {step}
		type {float}
		default {"1.0"}
		desc { Size of the ramp increments. }
	}

	go {
	   // if the star is triggered, generate ramp output (ignore input).
	   completionTime = arrivalTime;
	   double t = value;
           output.put(completionTime) << t;
           t += double(step);
           value = t;
	}
}
