static const char file_id[] = "defConstructs.cc";
#include "CaseScheduler.h"
#include "ForScheduler.h"
#include "DoWhileScheduler.h"
#include "RecurScheduler.h"
#include "defConstructs.h"
#include "DyConScheduler.h"

#ifdef __GNUG__
#pragma implementation
#endif

/**************************************************************************
Version identification:
@(#)defConstructs.cc	1.5	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Soonhoi Ha

 List the scheduler of the predefined dynamic constructs.
 If you add another construct, you have to update the defined variable,
 "NUM" and the structure, "defCons"

**************************************************************************/

#define NUM 4		// number of predefined constructs.

#define CASE 	4		// "Case" construct
#define FOR 	5		// "For" construct
#define DOWHILE 6		// "DoWhile" construct

// list of the scheduler
CaseScheduler caseSched;
ForScheduler forSched;
DoWhileScheduler doWhileSched;
RecurScheduler recurSched;

struct definedConstructs {
	int canDom;
	const char* name;
	DyConScheduler* sched;
};

static definedConstructs defCons[] = {
	{CASE, "case", (DyConScheduler*) &caseSched},
	{FOR, "for",  (DyConScheduler*) &forSched} ,
	{DOWHILE, "doWhile", (DyConScheduler*) &doWhileSched},
	{RECUR, "recur", (DyConScheduler*) &recurSched}
};

DyConScheduler* getScheduler(char* name) {

	// if the number of the constructs is large, we may want
	// binary search, but not now.

	for (int i = 0; i < NUM; i++) 
		if (!strcmp(defCons[i].name, name)) {
			return defCons[i].sched->copy();
		}

	// if name is not found.
	return (DyConScheduler*) 0;
}

DyConScheduler* getScheduler(int n) {

	// if the number of the constructs is large, we may want
	// binary search, but not now.

	for (int i = 0; i < NUM; i++) 
		if (defCons[i].canDom == n) {
			return (DyConScheduler*) defCons[i].sched->copy();
		}

	// if name is not found.
	return (DyConScheduler*) 0;
}

int getType(Galaxy& gal) {

	for (int i = 0; i < NUM; i++) {
		DyConScheduler* trySched = defCons[i].sched;
		if (trySched->checkType(gal)) 
			return defCons[i].canDom;
	}
	return DDF;
}
			
const char* nameType(int n) {

	for (int i = 0; i < NUM; i++) 
		if (defCons[i].canDom == n) {
			return defCons[i].name;
		}

	// if name is not found
	return "undefined";
}
