static const char file_id[] = "RecurScheduler.cc";
#ifdef __GNUG__
#pragma implementation
#endif

#include "type.h"
#include "RecurScheduler.h"
#include "Star.h"

/**************************************************************************
Version identification:
@(#)RecurScheduler.cc	1.7	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Soonhoi Ha
 Date of creation: 1/14/91
 Date of creation: 7/8/91

 Recur Scheduler methods

**************************************************************************/

/************************************************************************

	Recur Scheduler

*************************************************************************/

	////////////////////////////
	// run
	////////////////////////////

int RecurScheduler :: run () {

	ListIter pre(schedules[0]);
	ListIter unrecur(schedules[1]);
	ListIter recur(schedules[2]);
	ListIter post(schedules[3]);

	Star* s;

	while ((s = (Star*) pre++) != 0)
		s->run();
	
	// read the control value
	int test = (*testPort)%0;

	if ((test && selfArm == 2) || (!test && selfArm == 1)) {
		while ((s = (Star*) recur++) != 0)
			s->run();
	} else {
		while ((s = (Star*) unrecur++) != 0)
			s->run();
	}

	// fire EndCase Stars
	while((s = (Star*) post++) != 0)
		s->run();
	
	return TRUE;
}

int RecurScheduler :: checkType(Galaxy& galaxy) {
	Recur::clearSchedules();
	return Recur::checkTopology(galaxy);
}

DyConScheduler* RecurScheduler :: copy() 
	{ LOG_NEW; return new RecurScheduler; }

