static const char file_id[] = "For.cc";
#ifdef __GNUG__
#pragma implementation
#endif

#include "type.h"
#include "For.h"
#include "GalIter.h"
#include "DDFStar.h"

/**************************************************************************
Version identification:
@(#)For.cc	1.7	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Soonhoi Ha
 Date of creation: 7/8/91

 Methods for "For" construct.

**************************************************************************/

extern void renewNumTokens(Block* b, int flag);

	////////////////////////////
	// clearSchedules
	////////////////////////////

void For :: clearSchedules () {
	schedules[0].initialize();	// UpSample stars and a wormhole
	schedules[1].initialize();	// main wormhole 
	schedules[2].initialize();	// DownSample stars 
	testPort = 0;
}

	////////////////////////////
	// checkToppology
	////////////////////////////

int For :: checkTopology (Galaxy& galaxy) {

	// check the topology
	// 1. check whether stars are all Wormholes,
	//    UpSample Stars, or DownSample Stars. 
	// 2. check the Wormholes are connected to an UpSample and 
	//    a DownSample stars.
	
	int numUp = 0;

	GalStarIter nextStar(galaxy);
	Star* s;

	while ((s = nextStar++) != 0) {

		if (s->isItWormhole()) {

			// check connections.
			PortHole* p;
			BlockPortIter nextp(*s);
			int flag = 0;
	
			while ((p = nextp++) != 0) {

			   if (p->atBoundary()) {
				flag++;
				continue;
			   }

			   // check the numberTokens
			   if (p->numberTokens > 1) return FALSE;

			   DDFStar* ds = (DDFStar*) p->far()->parent();
			   if (p->isItInput()) {
				if (strcmp(ds->readTypeName(), "UpSample")) {
				   return FALSE;
				}
			   } else {
			      if (strcmp(ds->readTypeName(),"DownSample")  
				&& strcmp(p->far()->name(), "control"))
				   return FALSE;
			   }
			}
			if (flag == 0) 	   {
				schedules[1].prepend(s);
			}
			else if (flag == 1) schedules[0].prepend(s);
			else		    return FALSE;

		} else {
			DDFStar* ds = (DDFStar*) s;
			const char* str = ds->readTypeName();
			if (!strcmp(str, "UpSample")) {
				numUp++;
				PortHole* p;
				BlockPortIter nextp(*s);
				while ((p = nextp++) != 0) {
				    if (p->isItInput())
					if (strcmp(p->name(), "control"))
						if (!p->far()->isItInput())
							return FALSE;
				}
				schedules[0].put(s);

			} else if (!strcmp(str, "DownSample")) {
				PortHole* p;
				BlockPortIter nextp(*s);
				while ((p = nextp++) != 0) {
					if (p->isItOutput()) {
						if (p->far()->isItInput())
							return FALSE;
					} else if
					   (!strcmp(p->name(), "control"))
						testPort = p->far();
				}
				schedules[2].put(s);

			} else if (!strcmp(str, "Fork")) {
				PortHole* p;
				BlockPortIter nextp(*s);
				while ((p = nextp++) != 0) {
					if (p->isItOutput()) 
					   if(strcmp(p->far()->name(), 
						"control"))
						return FALSE;
				}
				schedules[0].prepend(s);
			} else {
				return FALSE;
			}
		}
	}

	if (numUp) noUp = FALSE;
	else	   noUp = TRUE;

	renewNumTokens(galaxy.parent(), FALSE);
	return TRUE;
}

