static const char file_id[] = "DoWhileScheduler.cc";
#ifdef __GNUG__
#pragma implementation
#endif

#include "type.h"
#include "DoWhileScheduler.h"
#include "Star.h"

/**************************************************************************
Version identification:
@(#)DoWhileScheduler.cc	1.8	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Soonhoi Ha
 Date of creation: 1/10/91
 Date of Revision: 7/8/91

 DoWhile Scheduler methods

**************************************************************************/

/************************************************************************

	DoWhile Scheduler

*************************************************************************/

	////////////////////////////
	// run
	////////////////////////////

int DoWhileScheduler :: run () {

	ListIter se(schedules[0]);
	ListIter sw(schedules[1]);

	Star* s;

	while((s = (Star*) se++) != 0)
		s->run();

	while ((s = (Star*) sw++) != 0)
		s->run();

	// read the control value
	int test = (*testPort)%0;

	while (test) {
		se.reset();
		while((s = (Star*) se++) != 0)
			s->run();
		sw.reset();
		while((s = (Star*) sw++) != 0)
			s->run();
		test = (*testPort)%0;
	}

	return TRUE;
}
		
int DoWhileScheduler :: checkType(Galaxy& galaxy) {
	DoWhile::clearSchedules();
	return DoWhile::checkTopology(galaxy);
}

DyConScheduler* DoWhileScheduler :: copy() 
	{ LOG_NEW; return new DoWhileScheduler; }
