#ifndef _CaseScheduler_h
#define _CaseScheduler_h 1
#ifdef __GNUG__
#pragma interface
#endif

#include "Scheduler.h"
#include "Galaxy.h"
#include "DataStruct.h"
#include "Case.h"
#include "DyConScheduler.h"

/**************************************************************************
Version identification:
@(#)CaseScheduler.h	1.6	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Soonhoi Ha
 Date of creation: 1/2/91
 Date of Revision: 7/8/91

 Use multiple inheritance.

**************************************************************************/

	////////////////////////////
	// CaseScheduler
	////////////////////////////

// It schedules the "Case" construct. 
// At compile time, it checks the topology for the Case domain.
// At runtime, it trivially fires the Case Star and the selected
// Wormhole, and EndCase Star.
// The Case domain is very restricted -> scheduler is simple accordingly.

class CaseScheduler : public DyConScheduler, public Case {

public:
	// Check the topology.
	// Verify the connection in the right order,
        int checkType(Galaxy&);

	// Trivial thing -- fire Case -> Wormhole -> EndCase Stars.
	int run();

	// copy
	DyConScheduler* copy();
};

#endif
