static const char file_id[] = "../../../../src/domains/cgc/targets/CGCUnixSend.pl";
// .cc file generated from ../../../../src/domains/cgc/targets/CGCUnixSend.pl by ptlang
/*
 * copyright (c) 1991 The Regents of the University of California
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCUnixSend.h"
#include "StringList.h"

const char *star_nm_CGCUnixSend = "CGCUnixSend";

const char* CGCUnixSend :: className() const {return star_nm_CGCUnixSend;}

Block* CGCUnixSend :: makeNew() const { LOG_NEW; return new CGCUnixSend;}

CodeBlock CGCUnixSend :: ipcHandler (
"\n"
"    void $val(IPCHandlerName)() {\n"
"	int timeout, localLoop;\n"
"	struct sockaddr_in addr;\n"
"\n"
"	/* connect to the server */\n"
"	for (timeout = 0; ; timeout++) {\n"
"		/* Open a TCP socket (an Internet stream socket */\n"
"		if (($starSymbol(sId) = socket(AF_INET, SOCK_STREAM, 0)) < 0) {\n"
"			printf(\"cannot open stream socket in $val(IPCHandlerName).\\n\");\n"
"			exit(1);\n"
"		}\n"
"\n"
"		/* Fill in the structure addr with the address of the server\n"
"	   	   that we want to connect with */\n"
"		bzero((char*) &addr, sizeof(addr));\n"
"		addr.sin_family = AF_INET;\n"
"		addr.sin_addr.s_addr = inet_addr(\"$val(hostAddr)\");\n"
"		addr.sin_port = htons($val(hostPort));\n"
"\n"
"		if (connect($starSymbol(sId), (struct sockaddr*) &addr, sizeof(addr) ) == 0) \n"
"			break;\n"
"		sleep(1);\n"
"		if (timeout > 10000) {\n"
"			printf(\"cannot connect to server on port $val(hostPort).\\n\");\n"
"			exit(1);\n"
"		}\n"
"		close($starSymbol(sId));\n"
"	}\n"
"    }	\n"
);

CodeBlock CGCUnixSend :: block (
"	int i, pos;\n"
"	union {\n"
"		unsigned long l;\n"
"		float f;\n"
"	} myData;\n"
"	\n"
"	for (i = 0; i < $val(numData); i++) {\n"
"		pos = $val(numData) - 1 + i;\n"
"		myData.f = (float) $ref(input,pos);\n"
"		myData.l = htonl(myData.l);\n"
"		if (write($starSymbol(sId), &myData.l, sizeof(myData)) != sizeof(myData)) {\n"
"			printf(\"write fails.\\n\");\n"
"			exit(1);\n"
"		}\n"
"	}\n"
);

CGCUnixSend::CGCUnixSend ()
{
	setDescriptor("Send star between UNIX processors.");
	addPort(input.setPort("input",this,FLOAT));
	addState(numData.setState("numData",this,"1","number of tokens to be transferred",
# line 26 "../../../../src/domains/cgc/targets/CGCUnixSend.pl"
A_NONSETTABLE));
	addState(IPCHandlerName.setState("IPCHandlerName",this,"IPCHandler","Name od sender's IPC handler function.",
# line 33 "../../../../src/domains/cgc/targets/CGCUnixSend.pl"
A_NONSETTABLE));
	addState(hostPort.setState("hostPort",this,"0","Host port number",
# line 40 "../../../../src/domains/cgc/targets/CGCUnixSend.pl"
A_NONSETTABLE));
	addState(hostAddr.setState("hostAddr",this," ","Host address for server",
# line 47 "../../../../src/domains/cgc/targets/CGCUnixSend.pl"
A_NONSETTABLE));


}

void CGCUnixSend::wrapup() {
# line 119 "../../../../src/domains/cgc/targets/CGCUnixSend.pl"
addCode("\tclose($starSymbol(sId));\n");
}

void CGCUnixSend::initCode() {
# line 88 "../../../../src/domains/cgc/targets/CGCUnixSend.pl"
StringList IPCproc = processCode(ipcHandler);	
		addProcedure(IPCproc);
		addGlobal("int $starSymbol(sId);\n");
		addInclude("<stdio.h>");
		addInclude("<sys/types.h>");
		addInclude("<sys/socket.h>");
		addInclude("<netinet/in.h>");
		addInclude("<arpa/inet.h>");
}

void CGCUnixSend::setup() {
# line 52 "../../../../src/domains/cgc/targets/CGCUnixSend.pl"
numData = input.numXfer();
}

void CGCUnixSend::go() {
# line 116 "../../../../src/domains/cgc/targets/CGCUnixSend.pl"
addCode(block);
}

// prototype instance for known block list
static CGCUnixSend proto;
static KnownBlock entry(proto,"UnixSend");
