static const char file_id[] = "../../../../src/domains/cgc/targets/CGCUnixReceive.pl";
// .cc file generated from ../../../../src/domains/cgc/targets/CGCUnixReceive.pl by ptlang
/*
 * copyright (c) 1991 The Regents of the University of California
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCUnixReceive.h"
#include "StringList.h"

const char *star_nm_CGCUnixReceive = "CGCUnixReceive";

const char* CGCUnixReceive :: className() const {return star_nm_CGCUnixReceive;}

Block* CGCUnixReceive :: makeNew() const { LOG_NEW; return new CGCUnixReceive;}

CodeBlock CGCUnixReceive :: ipcHandler (
"\n"
"    void $val(IPCHandlerName)() {\n"
"	int len;\n"
"	struct sockaddr_in addr, far_addr;\n"
"\n"
"	/* Open a TCP socket (an Internet stream socket */\n"
"	if (($starSymbol(sId) = socket(AF_INET, SOCK_STREAM, 0)) < 0) {\n"
"		printf(\"cannot open stream socket in $val(IPCHandlerName).\\n\");\n"
"		exit(1);\n"
"	}\n"
"\n"
"	/* Bind local address */\n"
"	bzero((char*) &addr, sizeof(addr));\n"
"	addr.sin_family = AF_INET;\n"
"	addr.sin_addr.s_addr = htonl(INADDR_ANY);\n"
"	addr.sin_port = htons($val(hostPort));\n"
"\n"
"	if (bind($starSymbol(sId),(struct sockaddr*) &addr,sizeof(addr)) < 0) {\n"
"		printf(\"bind on port $val(hostPort) failed.\\n\");\n"
"		exit(1);\n"
"	}\n"
"\n"
"	listen($starSymbol(sId), 5);\n"
"\n"
"	/* wait for connection from a sender */\n"
"	len = sizeof(far_addr);\n"
"	$starSymbol(newSId) = accept($starSymbol(sId), \n"
"		(struct sockaddr*) &far_addr, &len);\n"
"	if ($starSymbol(newSId) < 0) {\n"
"		printf(\"accept error on port $val(hostPort).\\n\");\n"
"		exit(1);\n"
"	}\n"
"	printf(\"accept connection on port $val(hostPort).\\n\");\n"
"    }	\n"
);

CodeBlock CGCUnixReceive :: block (
"	int i, pos;\n"
"	union {\n"
"		unsigned long l;\n"
"		float f;\n"
"	} myData;\n"
"\n"
"	for (i = 0; i < $val(numData); i++) {\n"
"		pos = $val(numData) - 1 + i;\n"
"		if (read($starSymbol(newSId), &myData.l, sizeof(myData)) != sizeof(myData)) {\n"
"			printf(\"write fails.\\n\");\n"
"			break;\n"
"		}\n"
"		myData.l = ntohl(myData.l);\n"
"		$ref(output,pos) = myData.f;\n"
"	}\n"
);

CGCUnixReceive::CGCUnixReceive ()
{
	setDescriptor("Receive star between Unix processors.");
	addPort(output.setPort("output",this,FLOAT));
	addState(numData.setState("numData",this,"1","number of tokens to be transferred",
# line 28 "../../../../src/domains/cgc/targets/CGCUnixReceive.pl"
A_NONSETTABLE));
	addState(IPCHandlerName.setState("IPCHandlerName",this,"IPCHandler","Name od sender's IPC handler function.",
# line 35 "../../../../src/domains/cgc/targets/CGCUnixReceive.pl"
A_NONSETTABLE));
	addState(hostPort.setState("hostPort",this,"0","Host port number",
# line 42 "../../../../src/domains/cgc/targets/CGCUnixReceive.pl"
A_NONSETTABLE));
	addState(hostAddr.setState("hostAddr",this," ","Host address for server",
# line 49 "../../../../src/domains/cgc/targets/CGCUnixReceive.pl"
A_NONSETTABLE));


}

void CGCUnixReceive::wrapup() {
# line 125 "../../../../src/domains/cgc/targets/CGCUnixReceive.pl"
addCode("\tclose($starSymbol(sId));\n");
		addCode("\tclose($starSymbol(newSId));\n");
}

void CGCUnixReceive::initCode() {
# line 93 "../../../../src/domains/cgc/targets/CGCUnixReceive.pl"
StringList IPCproc = processCode(ipcHandler);	
		addProcedure(IPCproc);
		addGlobal("int $starSymbol(sId);\n");
		addGlobal("int $starSymbol(newSId);\n");
		addInclude("<stdio.h>");
		addInclude("<sys/types.h>");
		addInclude("<sys/socket.h>");
		addInclude("<netinet/in.h>");
		addInclude("<arpa/inet.h>");
}

void CGCUnixReceive::setup() {
# line 53 "../../../../src/domains/cgc/targets/CGCUnixReceive.pl"
numData = output.numXfer();
}

void CGCUnixReceive::go() {
# line 122 "../../../../src/domains/cgc/targets/CGCUnixReceive.pl"
addCode(block);
}

// prototype instance for known block list
static CGCUnixReceive proto;
static KnownBlock entry(proto,"UnixReceive");
