static const char file_id[] = "../../../../src/domains/cgc/stars/CGCXgraph.pl";
// .cc file generated from ../../../../src/domains/cgc/stars/CGCXgraph.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCXgraph.h"
#include "Target.h"

const char *star_nm_CGCXgraph = "CGCXgraph";

const char* CGCXgraph :: className() const {return star_nm_CGCXgraph;}

Block* CGCXgraph :: makeNew() const { LOG_NEW; return new CGCXgraph;}

CodeBlock CGCXgraph :: err (
"    {\n"
"        fprintf(stderr,\"ERROR: cannot open output file for Xgraph star.\\n\");\n"
"	exit(1);\n"
"    }\n"
);

CodeBlock CGCXgraph :: closeFile (
"    fclose($starSymbol(fp));\n"
);

CGCXgraph::CGCXgraph ()
{
	setDescriptor("Generate a plot with the xgraph program.");
	addPort(input.setPort("input",this,ANYTYPE));
	addState(title.setState("title",this,"X graph","Title for the plot."));
	addState(saveFile.setState("saveFile",this,"","File to save the input to the xgraph program."));
	addState(options.setState("options",this,"","Command line options for xgraph."));
	addState(ignore.setState("ignore",this,"0","Number of initial values to ignore."));
	addState(xUnits.setState("xUnits",this,"1.0","For labeling, horizontal increment between samples."));
	addState(xInit.setState("xInit",this,"0.0","For labeling, horizontal value of the first sample."));
	addState(index.setState("index",this,"0.0","index",
# line 72 "../../../../src/domains/cgc/stars/CGCXgraph.pl"
A_NONSETTABLE|A_NONCONSTANT));


}

void CGCXgraph::wrapup() {
# line 113 "../../../../src/domains/cgc/stars/CGCXgraph.pl"
// close the files
		addCode(closeFile);

		StringList cmd;
		cmd << "( ";

		// save File
		const char* sf = saveFile;
		if (sf != NULL && *sf != 0) {
			cmd << "/bin/cat ";
			cmd << targetPtr->name(); 
			cmd << "_$starSymbol(temp)" << " >> ";
			cmd << sf << "; /bin/echo \"\" >> " << sf << "; ";
		}

		cmd << "xgraph ";

		// put title on command line

		const char* ttl = title;

		if (ttl && *ttl) {
			if (strchr(ttl,'\'')) {
				cmd << "-t \"" << ttl << "\" ";
			}
			else {
				cmd << "-t '" << ttl << "' ";
			}
		}

		const char* opt = options;

		// put options on the command line
		if (opt && *opt) {
			cmd << opt << " ";
		}

		// put file name
		cmd << targetPtr->name() << "_$starSymbol(temp)";

		// remove temporary files
		cmd << "; /bin/rm -f " << targetPtr->name();
		cmd << "_$starSymbol(temp)";

		cmd << ") &";
		StringList out = "    system(\"";
		out << cmd << "\");\n";
		addCode(out);
}

void CGCXgraph::initCode() {
# line 84 "../../../../src/domains/cgc/stars/CGCXgraph.pl"
addDeclaration("    FILE* $starSymbol(fp);");
                addInclude("<stdio.h>");
		StringList w = "    if(!($starSymbol(fp) = fopen(\"";
		w << targetPtr->name() << "_$starSymbol(temp)";
		w << "\",\"w\")))";
		addCode(w);
		addCode(err);
}

void CGCXgraph::setup() {
# line 77 "../../../../src/domains/cgc/stars/CGCXgraph.pl"
index = xInit;
		count = 0;
}

void CGCXgraph::go() {
# line 101 "../../../../src/domains/cgc/stars/CGCXgraph.pl"
count++;
		if (count <= int(ignore)) return;
		addCode(
"\tfprintf($starSymbol(fp),\"%g %g\\n\",$ref(index),$ref(input));\n");
		addCode("\t$ref(index) += $val(xUnits);\n");
}

// prototype instance for known block list
static CGCXgraph proto;
static KnownBlock entry(proto,"Xgraph");
